<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <!-- 
      
     This library works fine for the below check logic:
     
     
     <criteria operator="AND">
     <criterion comment="Test for the existence of the file" test_ref="oval:com.mcafee.oval:tst:98695" />
     <criterion comment="Test for the existence of the file - /etc/pam.d/password-auth" test_ref="oval:com.mcafee.oval:tst:247645" />
     <criterion comment="Verify for the entry auth required pam_faillock.so preauth audit silent deny=5 unlock_time=900 in /etc/pam.d/system-auth file." test_ref="oval:com.mcafee.oval:tst:244698" />
     <criterion comment="Verify for the entry auth [success=1 default=bad] pam_unix.so in /etc/pam.d/system-auth file." test_ref="oval:com.mcafee.oval:tst:244699" />
     <criterion comment="Verify for the entry auth [default=die] pam_faillock.so authfail audit deny=5 unlock_time=900 in /etc/pam.d/system-auth file." test_ref="oval:com.mcafee.oval:tst:244700" />
     <criterion comment="Verify for the entry auth sufficient pam_faillock.so authsucc audit deny=5 unlock_time=900 in /etc/pam.d/system-auth file." test_ref="oval:com.mcafee.oval:tst:244701" />
     <criterion comment="Verify for the entry auth required pam_faillock.so preauth audit silent deny=5 unlock_time=900 in /etc/pam.d/password-auth file." test_ref="oval:com.mcafee.oval:tst:244714" />
     <criterion comment="Verify for the entry auth [success=1 default=bad] pam_unix.so in /etc/pam.d/password-auth file." test_ref="oval:com.mcafee.oval:tst:244715" />
     <criterion comment="Verify for the entry auth [default=die] pam_faillock.so authfail audit deny=5 unlock_time=900 in /etc/pam.d/password-auth file." test_ref="oval:com.mcafee.oval:tst:244716" />
     <criterion comment="Verify for the entry auth sufficient pam_faillock.so authsucc audit deny=5 unlock_time=900 in /etc/pam.d/password-auth file." test_ref="oval:com.mcafee.oval:tst:244717" />
     </criteria>
     
     Example def if : oval:com.mcafee.oval:def:244697
    -->
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect service name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all results for the criterias in the variables ......................................... --> 
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        
        <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>        
        <xsl:variable name="result7" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[7]/@result"/>
        <xsl:variable name="result8" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[8]/@result"/>
        <xsl:variable name="result9" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[9]/@result"/>
        <xsl:variable name="result10" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[10]/@result"/>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>        
        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
        <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
        
        <xsl:variable name="fileTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="definitionFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id1]"/>        
        <xsl:variable name="filePath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest1/unix-def:object/@object_ref]/unix-def:path/text()" />
        <xsl:variable name="fileName1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest1/unix-def:object/@object_ref]/unix-def:filename/text()" />
        
        
        <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]"/>
        <xsl:variable name="textfile53Path1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]"/>
        <xsl:variable name="textfile53Path2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[3]/@id"/>
        <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id3]"/>
        <xsl:variable name="textfile53Path3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[4]/@id"/>
        <xsl:variable name="definitionTextFileTest4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id4]"/>
        <xsl:variable name="textfile53Path4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[5]/@id"/>
        <xsl:variable name="definitionTextFileTest5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id5]"/>
        <xsl:variable name="textfile53Path5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
                
        <xsl:variable name="fileContentTest_id6" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="definitionTextFileTest6" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id6]"/>
        <xsl:variable name="textfile53Path6" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest6/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name6" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest6/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat6" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest6/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id7" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="definitionTextFileTest7" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id7]"/>
        <xsl:variable name="textfile53Path7" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest7/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name7" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest7/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat7" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest7/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id8" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="definitionTextFileTest8" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id8]"/>
        <xsl:variable name="textfile53Path8" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest8/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name8" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest8/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat8" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest8/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileInfo">
            <xsl:value-of select="concat($filePath,'/', $fileName,', ',$filePath1,'/', $fileName1,' ')"/>
        </xsl:variable>
        
        <xsl:variable name="textfilePat">
            <xsl:value-of select="concat($textfilePat1,', ',$textfilePat2,', ',$textfilePat3,', ',$textfilePat4,', ',$textfilePat5,', ',$textfilePat6,', ',$textfilePat7,' &amp; ',$textfilePat8,' ')"/>
        </xsl:variable>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$result1 = 'false' and $result2 = 'false'">
                        <xsl:text>com.mcafee.pa.msg.configfilesDoesNotExists</xsl:text>
                    </xsl:when>
                    <xsl:when test="($result1 = 'true' and $result2 = 'true') and ($result2 = 'false' or $result3 = 'false' or $result4 = 'false' or $result5 = 'false' or $result6 = 'false' or $result7 = 'false' or $result8 = 'false')">
                        <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
                
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>        
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>                
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">pattern</xsl:attribute>
                    <xsl:value-of select="$textfilePat"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>