<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is to verify if the user dot files are set with required file permissions.
        
        <criteria operator="OR">
            <criterion comment="Test the existence of defined user home directories" negate="true" test_ref="oval:com.mcafee.oval:tst:249620" /> - Test for the existence of user home directories.
            <criterion comment="Test the Permissions of defined account home directories" test_ref="oval:com.mcafee.oval:tst:249626" /> - Test for the permissions of the user home directories.
        </criteria>
        
       Test Cases:
            1. Final Result is Pass - Permissions of all the user home directories are set as expected.
            2. Final Result is Fail - Permissions of one or more user home directories are not set as per the user input.
            
            Ex. OVAL ID - oval:com.mcafee.oval:def:249619
                                     
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="convertBinaryToOctal">
        <xsl:param name="value"/>        
        <xsl:variable name="octalVal">
            <xsl:choose>            
                <xsl:when test="contains($value, '000' )">
                    <xsl:text>0</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '001' )">
                    <xsl:text>1</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '010' )">
                    <xsl:text>2</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '011' )">
                    <xsl:text>3</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '100' )">
                    <xsl:text>4</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '101' )">
                    <xsl:text>5</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '110' )">
                    <xsl:text>6</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, '111' )">
                    <xsl:text>7</xsl:text>                    
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>0</xsl:text>
                </xsl:otherwise>
            </xsl:choose>            
        </xsl:variable>        
        <xsl:choose>            
            <xsl:when test="$octalVal != '' ">
                <xsl:value-of select="$octalVal"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$value"/>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
            <xsl:variable name="OvalResult"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="Tests"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
            
            <xsl:variable name="tests">
                <xsl:for-each
                    select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                    
                    <xsl:if test="not(@negate)">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/unix-def:file_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>fileTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="TestedItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
         
        <xsl:variable name="userPermList">
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fileTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                    <xsl:if test="@result='false'">
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="fileTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemRef]" />
                        
                        <xsl:variable name="decValOwner">
                            <xsl:call-template name="convertBinaryToOctal">
                                <xsl:with-param name="value" select="concat($fileTestItem/unix-sc:uread/text(),$fileTestItem/unix-sc:uwrite/text(),$fileTestItem/unix-sc:uexec/text())"/>
                            </xsl:call-template>
                        </xsl:variable>
                        
                        <xsl:variable name="decValGroup">
                            <xsl:call-template name="convertBinaryToOctal">
                                <xsl:with-param name="value" select="concat($fileTestItem/unix-sc:gread/text(),$fileTestItem/unix-sc:gwrite/text(),$fileTestItem/unix-sc:gexec/text())"/>
                            </xsl:call-template>
                        </xsl:variable>
                        
                        <xsl:variable name="decValOthers">
                            <xsl:call-template name="convertBinaryToOctal">
                                <xsl:with-param name="value" select="concat($fileTestItem/unix-sc:oread/text(),$fileTestItem/unix-sc:owrite/text(),$fileTestItem/unix-sc:oexec/text())"/>
                            </xsl:call-template>
                        </xsl:variable>
                       <xsl:if test="$fileTestItem/unix-sc:path/text()!=''">
                          <xsl:value-of select="concat($fileTestItem/unix-sc:path/text(), ' ---- ',$decValOwner,$decValGroup,$decValOthers,' ( ', $fileTestItem/unix-sc:uread/text(), $fileTestItem/unix-sc:uwrite/text(), $fileTestItem/unix-sc:uexec/text(), '  ',$fileTestItem/unix-sc:gread/text(), $fileTestItem/unix-sc:gwrite/text(), $fileTestItem/unix-sc:gexec/text(),'  ',$fileTestItem/unix-sc:oread/text(), $fileTestItem/unix-sc:owrite/text(), $fileTestItem/unix-sc:oexec/text(),' )    ')"/>        
                       </xsl:if>
                  </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="slashDirPerm">
            <xsl:variable name="itemIdSlash">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fileTest' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="type" select="@type"/>
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                        <xsl:if test="@result='false'">
                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="fileTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemRef]" />
                            <xsl:if test="not($fileTestItem/unix-sc:path/text())">
                                <xsl:element name="itemId">
                                    <xsl:value-of select="$fileTestItem/@id"/>
                                </xsl:element>   
                            </xsl:if>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="itemId" select="xalan:nodeset($itemIdSlash)/descendant::itemId[1]"/>
            <xsl:variable name="fileTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemId]"/>
            <xsl:if test="$fileTestItem!=''">
                <xsl:variable name="decValOwner">
                    <xsl:call-template name="convertBinaryToOctal">
                        <xsl:with-param name="value" select="concat($fileTestItem/unix-sc:uread/text(),$fileTestItem/unix-sc:uwrite/text(),$fileTestItem/unix-sc:uexec/text())"/>
                    </xsl:call-template>
                </xsl:variable>
                
                <xsl:variable name="decValGroup">
                    <xsl:call-template name="convertBinaryToOctal">
                        <xsl:with-param name="value" select="concat($fileTestItem/unix-sc:gread/text(),$fileTestItem/unix-sc:gwrite/text(),$fileTestItem/unix-sc:gexec/text())"/>
                    </xsl:call-template>
                </xsl:variable>
                
                <xsl:variable name="decValOthers">
                    <xsl:call-template name="convertBinaryToOctal">
                        <xsl:with-param name="value" select="concat($fileTestItem/unix-sc:oread/text(),$fileTestItem/unix-sc:owrite/text(),$fileTestItem/unix-sc:oexec/text())"/>
                    </xsl:call-template>
                </xsl:variable>
                <xsl:value-of select="concat(' / ', ' ---- ',$decValOwner,$decValGroup,$decValOthers,' ( ', $fileTestItem/unix-sc:uread/text(), $fileTestItem/unix-sc:uwrite/text(), $fileTestItem/unix-sc:uexec/text(), '  ',$fileTestItem/unix-sc:gread/text(), $fileTestItem/unix-sc:gwrite/text(), $fileTestItem/unix-sc:gexec/text(),'  ',$fileTestItem/unix-sc:oread/text(), $fileTestItem/unix-sc:owrite/text(), $fileTestItem/unix-sc:oexec/text(),' )    ')"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="homeDirPermList">
           <xsl:choose>
               <xsl:when test="$userPermList!='' and $slashDirPerm!=''">
                   <xsl:value-of select="concat($userPermList, '  ',$slashDirPerm)"/>
               </xsl:when>
               <xsl:when test="$userPermList!='' and $slashDirPerm=''">
                   <xsl:value-of select="$userPermList"/>
               </xsl:when>
               <xsl:when test="$userPermList='' and $slashDirPerm!=''">
                   <xsl:value-of select="$slashDirPerm"/>
               </xsl:when>
               <xsl:otherwise>
                   <xsl:value-of select="$userPermList"/>
               </xsl:otherwise>
           </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="expectedPerm">
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fileTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                
                <xsl:variable name="binVal1">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[1]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[1]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                <xsl:variable name="binVal2">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[2]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[2]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                
                <xsl:variable name="binVal3">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[3]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[3]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                
                <xsl:variable name="binVal4">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[4]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[4]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                <xsl:variable name="binVal5">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[5]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[5]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                <xsl:variable name="binVal6">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[6]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[6]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                <xsl:variable name="binVal7">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[7]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[7]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                <xsl:variable name="binVal8">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[8]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[8]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                <xsl:variable name="binVal9">
                    <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                        <xsl:if test="@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[9]/@id">
                            <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[9]/@id]/text()"/>    
                        </xsl:if>
                    </xsl:for-each>    
                </xsl:variable>
                        <xsl:variable name="octValue1">
                            <xsl:call-template name="convertBinaryToOctal">
                                <xsl:with-param name="value" select="concat($binVal1,$binVal2,$binVal3)"/>
                            </xsl:call-template>
                        </xsl:variable>
                        <xsl:variable name="octValue2">
                            <xsl:call-template name="convertBinaryToOctal">
                                <xsl:with-param name="value" select="concat($binVal4,$binVal5,$binVal6)"/>
                            </xsl:call-template>
                        </xsl:variable>
                        <xsl:variable name="octValue3">
                            <xsl:call-template name="convertBinaryToOctal">
                                <xsl:with-param name="value" select="concat($binVal7,$binVal8,$binVal9)"/>
                            </xsl:call-template>
                        </xsl:variable>
                <xsl:value-of select="concat($octValue1,$octValue2,$octValue3, '  ( ', $binVal1,$binVal2,$binVal3,'   ',$binVal4,$binVal5,$binVal6,'   ',$binVal7,$binVal8,$binVal9,' ) ')"/>
               </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="title">
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
               
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:text>com.mcafee.pa.msg.UserHomeDirPermSCAP</xsl:text>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">home_dir_perm_list</xsl:attribute>
                    <xsl:value-of select="$homeDirPermList"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">user_expc_perm</xsl:attribute>
                    <xsl:value-of select="$expectedPerm"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>