<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:linux-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#linux"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
  
  <!-- This library is to verify the OS release version.
    
    This library works fine for the below check logic:
    
    <criteria operator="OR">
    <criterion comment="Verify if snmp is installed on the system." negate="true" test_ref="oval:com.mcafee.oval:tst:1326820"/>
    <criterion comment="Verify snmp version on the system." test_ref="oval:com.mcafee.oval:tst:1326821"/>
    </criteria>
    
    oval:com.mcafee.oval:def:1326819
  -->
  
  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    
    <xsl:variable name="expectedReleaseVersion" select="/oval-res:oval_results/oval-res:results[1]/oval-res:system[1]/oval-res:tests[1]/oval-res:test[2]//oval-res:tested_variable[1]/text()"/>
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    <xsl:variable name="rpmName" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/linux-sc:rpminfo_item/linux-sc:name/text()"/>
    
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>       
    
    <xsl:variable name="ReleaseVersion">
      <xsl:choose>
        <xsl:when test="$result1 = 'false' and $result2 = 'false'">
          <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/linux-sc:rpminfo_item/linux-sc:version/text()"/>
          <!--    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/*[namespace-uri()='http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix' and local-name()='uname_item']/*[namespace-uri()='http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix' and local-name()='os_release']/text()"/> -->
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$expectedReleaseVersion"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
    <xsl:variable name="message_id">
    <xsl:if test="$result='true'">
      <xsl:choose>
        <xsl:when test="$result1 = 'false' and $result2 = 'true' ">
          <xsl:text>com.mcafee.pa.msg.ReleaseVersionStatus</xsl:text>
        </xsl:when>
      </xsl:choose>
      <xsl:choose>
        <xsl:when test="$result1 = 'true' and $result2 = 'false'">
          <xsl:text>com.mcafee.pa.msg.rpmPackageStatusSCAP</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:if> 
      <xsl:if test="$result='false'">
      <xsl:choose>
        <xsl:when test="$result1 = 'false' and $result2 = 'false'">
          <xsl:text>com.mcafee.pa.msg.ReleaseVersionStatus</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:if>
    </xsl:variable>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="key">Expected_ReleaseVersion</xsl:attribute>
        <xsl:value-of select="$expectedReleaseVersion" />
      </xsl:element>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>        
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>        
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">Release_Version</xsl:attribute>
          <xsl:value-of select="$ReleaseVersion"/>
        </xsl:element>   
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">rpm_name</xsl:attribute>
          <xsl:value-of select="$rpmName"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>
</xsl:stylesheet>