<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:linux-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#linux"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:linux-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#linux"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
   
    <!-- This library is to handle the OVAL checks with the sysctl test with external variable. 
             
             Logic :-
             <criteria operator="AND">
             <criterion negate="false" test_ref="oval:com.mcafee.oval:tst:2487742"/>
             </criteria>
                        
             with External variable.
             
             Ex. OVAL ID - oval:com.mcafee.oval:def:2487741
    --> 
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getNetworkParameterNameFromTitle">
        <xsl:param name="title"/>
        <xsl:variable name="NetworkParameterName">
                <xsl:value-of select="substring-after($title, 'status for - ')"/>                
            </xsl:variable>
        <xsl:choose>
            <xsl:when test="$NetworkParameterName != '' ">
                <xsl:value-of select="$NetworkParameterName"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
<!-- This library is for sysctl options checks in RHEL -->
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect configuration name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all the required data from the checks like test ref, obj ref, ste ref and their data and results ......................................... --> 
        <xsl:variable name="SysctlTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:sysctl_test/@id"/>
        <xsl:variable name="extVar_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable/@id"/>
        
        <xsl:variable name="definitionSysctlTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests//unix-def:sysctl_test[@id=$SysctlTest_id]"/>
        <xsl:variable name="NetworkParameter" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:sysctl_object[@id=$definitionSysctlTest/unix-def:object/@object_ref]/unix-def:name/text()"/>
        
        <xsl:variable name="NetworkParameterValue" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$SysctlTest_id]/oval-res:tested_variable[@variable_id=$extVar_id]/text()"/>       
                
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <!-- The Network Parameter $$network_parameter_name$$ is set to ##network_parameter_value## as expected. --> 
                <xsl:text>com.mcafee.pa.msg.NetworkParameterChecks</xsl:text>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false' ">   
                <!-- The Network Parameter $$network_parameter_name$$ is not set to ##network_parameter_value##. --> 
                <xsl:text>com.mcafee.pa.msg.NetworkParameterChecks</xsl:text>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="NetworkParameterName">
            <xsl:call-template name="getNetworkParameterNameFromTitle">
                <xsl:with-param name="title" select="$title"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">network_parameter_value</xsl:attribute>
                    <xsl:value-of select="$NetworkParameterValue" />
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">network_parameter_name</xsl:attribute>
                    <xsl:value-of select="$NetworkParameterName" />
                </xsl:element>
            </xsl:element>
        </xsl:element>
        
    </xsl:template>
</xsl:stylesheet>