<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to handle the OVAL checks with the two xmlfilecontent_test tests with a state.
        
        Logic :-
        <criteria operator="AND">
            <criteria comment=" The Apache Server service is disabled in /System/Library/LaunchDaemons/org.apache.httpd.plist file" operator="AND">
              <criterion test_ref="oval:com.mcafee.oval:tst:200804290547" comment="The key value is 'Disabled in /System/Library/LaunchDaemons/org.apache.httpd.plist"/>
              <criterion test_ref="oval:com.mcafee.oval:tst:200804290550" comment="The key value 'Disabled is set as 'true' in /System/Library/LaunchDaemons/org.apache.httpd.plist"/>
             </criteria>   
        </criteria>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:200804290546
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="xmlContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:xmlfilecontent_test[1]/@id"/>
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$xmlContentTest_id1]/@result"/>
        
        <xsl:variable name="definitionXmlFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:xmlfilecontent_test[@id=$xmlContentTest_id1]"/>
        <xsl:variable name="xmlfilePath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:xmlfilecontent_object[@id=$definitionXmlFileTest1/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="xmlfileName1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:xmlfilecontent_object[@id=$definitionXmlFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="xmlXpath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:xmlfilecontent_state[@id=$definitionXmlFileTest1/ind-def:state/@state_ref]/ind-def:value_of/text()" />
        
        <xsl:variable name="xmlContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:xmlfilecontent_test[2]/@id"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$xmlContentTest_id2]/@result"/>
        
        <xsl:variable name="definitionXmlFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:xmlfilecontent_test[@id=$xmlContentTest_id2]"/>
        <xsl:variable name="xmlfilePath2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:xmlfilecontent_object[@id=$definitionXmlFileTest2/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="xmlfileName2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:xmlfilecontent_object[@id=$definitionXmlFileTest2/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="xmlXpath2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:xmlfilecontent_object[@id=$definitionXmlFileTest2/ind-def:object/@object_ref]/ind-def:xpath/text()" />
        
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
        
        <xsl:variable name="fileInfo">
            <xsl:choose>
                <xsl:when test="($xmlfilePath1 and xmlfileName1) !=' ' ">
                    <xsl:value-of select="concat($xmlfilePath1,'/', $xmlfileName1)"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        
        <xsl:variable name="pattern">
            <xsl:choose>
                <xsl:when test="($xmlXpath1 and xmlxpath2) !=' ' ">
                    <xsl:value-of select="concat($xmlXpath1,' &amp; ', $xmlXpath2, ' value ' )"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        

        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <!-- Check if result is true ......................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>                       
            <!-- Check if result is false .......................................-->
            <xsl:if test="$result='false' ">
                 <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>                
            </xsl:if>    
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">pattern</xsl:attribute>
                    <xsl:value-of select="$pattern"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

