﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!--  FILENAME: MS_NW_Ser_SPN_TarName _Validation_Lev_SCAP.xsl         DATE: 10th Oct, 2011     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: MS_NW_Ser_SPN_TarName _Validation_Lev_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECKS to verify Server SPN target name validation level (Microsoft Network Server)-->
    <!-- This library is a modified version of winCompEventLogServSettings_SCAP.xsl-->
    
<!-- FOLLOWING ARE SOME OF THE ASSUMPTIONS TAKEN IN THE LOGIC FOR THE LIBRARY  -->
   <!--   1. Configuration/Policy name is extracted from the title of the check.
            2. Following are the 12 test cases which are taken into consideration for the logic:-
            3. In the below test cases, when system setting is Not Defined, then expected registry key or its item would be absent on the system and the setting is
                 nothing but "Not Configured". When it is set to Off then registry key would be present and value is set to 0 which is also "Not Configured" state.
    ______________________________________________________________________________________________________________________________________________________________________
       Test Case	External Variable    System Setting	                                                                                Check result      Message String                                          	                         Is Violation        Message ID
    ______________________________________________________________________________________________________________________________________________________________________
       
       Result1    Off (Not Configured)    Not Defined  	                                                                                    Pass              <tilte> configuration is set as expected	                               FALSE   com.mcafee.pa.msg.winConf_SCAP
       Result2    Accepted (1)                  Accepted (1)	                                                                                    Pass              <tilte> configuration is set as expected	                               FALSE   com.mcafee.pa.msg.winConf_SCAP
       Result3    Required (2)                  Required (2)	                                                                                    Pass              <tilte> configuration is set as expected	                               FALSE   com.mcafee.pa.msg.winConf_SCAP
       Result4    Off (Not Configured)    Off (0)	                                                                                                  Pass              <tilte> configuration is set as expected	                               FALSE   com.mcafee.pa.msg.winConf_SCAP
       Result5    Off (Not Configured)    Accepted (1)  	                                                                                   Fail                 <tilte> configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.winConf_SCAP
       Result6    Off (Not Configured)    Required (2	)                                                                                                 Fail                  <tilte> configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.winConf_SCAP
       Result7    Accepted (1)	       Not Defined                                                                                                   Fail                  <tilte> configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.winConf_SCAP
       Result8    Accepted (1)	        Off (0)                                                                                                             Fail                  <tilte> configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.winConf_SCAP
       Result9    Accepted (1)	        Required  (2)                                                                                                Fail                  <tilte> configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.winConf_SCAP
       Result10  Required (2)	         Accepted (1)                                                                                                Fail                  <tilte> configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.winConf_SCAP
       Result11  Required (2)	         Not Defined                                                                                                 Fail                  <tilte> configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.winConf_SCAP
       Result12  Required (2)	         Off (0)                                                                                                            Fail                  <tilte> configuration setings are not as expected	                TRUE     com.mcafee.pa.msg.winConf_SCAP
       ______________________________________________________________________________________________________________________________________________________________________    
   -->

    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <!-- Final result -->
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        
        <!-- Extract configuration/policy name from the check title -->
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>
        <xsl:variable name="result7"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[7]/@result"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="$result1 = 'true' and ($result2 = 'true' or $result3 = 'true')">
                            <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="$result4 = 'true' and $result5 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
                        </xsl:when>
                        <xsl:when test="$result6 = 'true' and $result7 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
                
                <!-- Check if result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                    <xsl:choose>
                        <xsl:when test="$result1 = 'true' and ($result5 = 'true' or $result7 = 'true')">
                            <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
                        </xsl:when>
                        
                        <xsl:when test="$result4 = 'true' and ($result2 = 'true' or $result3 = 'true' or $result7 = 'true')">
                            <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
                        </xsl:when>
                        
                        <xsl:when test="$result6 = 'true' and ($result2 = 'true' or $result3 = 'true' or $result5 = 'true')">
                            <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
  
            </xsl:variable>
            
        <xsl:variable name="expectedValue">
            <xsl:choose>
                <xsl:when test="$result1 = 'true' ">
                    <xsl:text>Off /Not Defined</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result4 = 'true' ">
                    <xsl:text>Accept if provided by client</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result6 = 'true' ">
                    <xsl:text>Required from client</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="actualValue">
            <xsl:choose>
                <xsl:when test="$result2 = 'true' ">
                    <xsl:text>Not Defined</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result3 = 'true' ">
                    <xsl:text>Off (0)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result5 = 'true' ">
                    <xsl:text>Accept if provided by client (1)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result7 = 'true' ">
                    <xsl:text>Required from client (2)</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="title">
                    <xsl:value-of select="$title"/>                                                    
                </instanceValue>
                <instanceValue key="expectedValue">
                    <xsl:value-of select="$expectedValue"/>                                                    
                </instanceValue>
                <actualValue key="actualValue">
                    <xsl:value-of select="$actualValue"/>                                                    
                </actualValue>
            </finding>
        </findings>
      
    </xsl:template>
</xsl:stylesheet>
