#!/bin/sh
logfile=/var/McAfee/agent/logs/msgbus_cert_updater.log
CURRENT_DIR=$(dirname $0)
current_time=$(date "+%Y.%m.%d-%H.%M.%S")

createSoftlink(){
	MA_BINARY_PATH=$1
	MA_VERSION="5.8"
	cwd=`pwd`
	cd $MA_BINARY_PATH
		
	if [ -f libcrypto.so.1.0.0 ] ; then
		ln -sf libcrypto.so.1.0.0 libcrypto.so
	fi
	if [ -f libma_client.so.$MA_VERSION ] ; then
			ln -sf libma_client.so.$MA_VERSION libma_client.so.5
			ln -sf libma_client.so.5 libma_client.so
	fi
	if [ -f libma_configurator.so.$MA_VERSION ] ; then
			ln -sf libma_configurator.so.$MA_VERSION libma_configurator.so.5
			ln -sf libma_configurator.so.5 libma_configurator.so
	fi
	if [ -f libma_crypto.so.$MA_VERSION ] ; then
			ln -sf libma_crypto.so.$MA_VERSION libma_crypto.so.5
			ln -sf libma_crypto.so.5 libma_crypto.so
	fi
	if [ -f libma_database.so.$MA_VERSION ] ; then
			ln -sf libma_database.so.$MA_VERSION libma_database.so.5
			ln -sf libma_database.so.5 libma_database.so
	fi
	if [ -f libma_datastore.so.$MA_VERSION ] ; then
			ln -sf libma_datastore.so.$MA_VERSION libma_datastore.so.5
			ln -sf libma_datastore.so.5 libma_datastore.so
	fi
	if [ -f libma_logger.so.$MA_VERSION ] ; then
			ln -sf libma_logger.so.$MA_VERSION libma_logger.so.5
			ln -sf libma_logger.so.5 libma_logger.so
	fi
	if [ -f libma_msgbus.so.$MA_VERSION ] ; then
			ln -sf libma_msgbus.so.$MA_VERSION libma_msgbus.so.5
			ln -sf libma_msgbus.so.5 libma_msgbus.so
	fi
	if [ -f libma_proxy.so.$MA_VERSION ] ; then
			ln -sf libma_proxy.so.$MA_VERSION libma_proxy.so.5
			ln -sf libma_proxy.so.5 libma_proxy.so
	fi
	if [ -f libma_repository.so.$MA_VERSION ] ; then
			ln -sf libma_repository.so.$MA_VERSION libma_repository.so.5
			ln -sf libma_repository.so.5 libma_repository.so
	fi
	if [ -f libma_serialization.so.$MA_VERSION ] ; then
			ln -sf libma_serialization.so.$MA_VERSION libma_serialization.so.5
			ln -sf libma_serialization.so.5 libma_serialization.so
	fi
	if [ -f libma_utils.so.$MA_VERSION ] ; then
			ln -sf libma_utils.so.$MA_VERSION libma_utils.so.5
			ln -sf libma_utils.so.5 libma_utils.so
	fi
	if [ -f libma_variant.so.$MA_VERSION ] ; then
			ln -sf libma_variant.so.$MA_VERSION libma_variant.so.5
			ln -sf libma_variant.so.5 libma_variant.so
	fi
	if [ -f libma_xml.so.$MA_VERSION ] ; then
			ln -sf libma_xml.so.$MA_VERSION libma_xml.so.5
			ln -sf libma_xml.so.5 libma_xml.so
	fi
	if [ -f libmfecryptc.so.$MA_VERSION ] ; then
			ln -sf libmfecryptc.so.$MA_VERSION libmfecryptc.so.5
			ln -sf libmfecryptc.so.5 libmfecryptc.so
	fi
	if [ -f libma_network.so.$MA_VERSION ] ; then
			ln -sf libma_network.so.$MA_VERSION libma_network.so.5
			ln -sf libma_network.so.5 libma_network.so
	fi
	if [ -f libmsgpackc.so.2.0.0 ] ; then
			ln -sf libmsgpackc.so.2.0.0 libmsgpackc.so.2
			ln -sf libmsgpackc.so.2 libmsgpackc.so
	fi
	if [ -f libssl.so.1.0.0 ] ; then
			ln -sf libssl.so.1.0.0 libssl.so
	fi
	if [ -f libmxml.so.1.6 ] ; then
			ln -sf libmxml.so.1.6 libmxml.so.1
			ln -sf libmxml.so.1 libmxml.so
	fi
	if [ -f libtrex.so.1.3 ] ; then
			ln -sf libtrex.so.1.3 libtrex.so.1
			ln -sf libtrex.so.1 libtrex.so
	fi

	if [ -f libuv.so.0.10 ] ; then
			ln -sf libuv.so.0.10 libuv.so.0
			ln -sf libuv.so.0 libuv.so
	fi
	if [ -f libcurl.so.4.8.0 ] ; then
			ln -sf libcurl.so.4.8.0 libcurl.so.4
			ln -sf libcurl.so.4 libcurl.so
	fi
	if [ -f libz.so.1.3.1 ] ; then
			ln -sf libz.so.1.3.1 libz.so.1
			ln -sf libz.so.1 libz.so
	fi
	cd $cwd
}

platform=`uname -m`
BIN_PATH_32="$CURRENT_DIR/lnx/intel_x86"
BIN_PATH_64="$CURRENT_DIR/lnx/intel_x64"
BIN_PATH_ARM64="$CURRENT_DIR/lnx/arm64"
BIN_PATH_MLOS="$CURRENT_DIR/lnx/mlos"
INSTALL_PATH="/opt/McAfee/agent/bin"

if [ -d $BIN_PATH_64 ] ; then
	createSoftlink $BIN_PATH_64
fi
if [ -d $BIN_PATH_32 ] ; then
	createSoftlink $BIN_PATH_32
fi
if [ -d $BIN_PATH_MLOS ] ; then
	createSoftlink $BIN_PATH_MLOS
fi
if [ -d $BIN_PATH_ARM64 ] ; then
	createSoftlink $BIN_PATH_ARM64
fi


if [ -f $BIN_PATH_32/ma_updater ] ; then
	chmod +x $BIN_PATH_32/ma_updater
fi
if [ -f $BIN_PATH_64/ma_updater ] ; then
	chmod +x $BIN_PATH_64/ma_updater
fi
if [ -f $BIN_PATH_ARM64/ma_updater ] ; then
	chmod +x $BIN_PATH_ARM64/ma_updater
fi
if [ -f $BIN_PATH_MLOS/ma_updater ] ; then
	chmod +x $BIN_PATH_MLOS/ma_updater
fi


if [ -f $logfile ] ; then
	mv $logfile /var/McAfee/agent/logs/msgbus_cert_updater_backup.log
fi

echo "start:-------------------------------------- "$current_time >> $logfile 2>&1
echo "platform is: $platform" >> $logfile 2>&1 
echo "CURRENT_DIR is: $CURRENT_DIR" >> $logfile	2>&1

if [ x$1 = x"MLOS" ]; then
	echo "ma_updater start to run for mlos" >> $logfile	2>&1
	LD_LIBRARY_PATH=${BIN_PATH_MLOS}:$LD_LIBRARY_PATH $BIN_PATH_MLOS/ma_updater -update_iam_trellix_url -logdir /var/McAfee/agent/logs >> $logfile 2>&1
	ret_code=$?
	echo "ret_code is from mlos: $ret_code" >> $logfile	2>&1
	exit 1
fi


if [ "$platform" = "x86_64" ] ;then
	echo "ma_updater start to run for intel 64 bit" >> $logfile	2>&1
	cp -rf $CURRENT_DIR/cmn.sh $INSTALL_PATH
	chmod +x $INSTALL_PATH/cmn.sh
	LD_LIBRARY_PATH=${BIN_PATH_64}:$LD_LIBRARY_PATH $BIN_PATH_64/ma_updater -update_iam_trellix_url -logdir /var/McAfee/agent/logs >> $logfile 2>&1
	ret_code=$?
	echo "ret_code is from intel 64 bit: $ret_code" >> $logfile	2>&1
	if [ $ret_code -eq 1 ] || [ $ret_code -eq 127 ] ; then
		LD_LIBRARY_PATH=${BIN_PATH_32}:$LD_LIBRARY_PATH $BIN_PATH_32/ma_updater -update_iam_trellix_url -logdir /var/McAfee/agent/logs >> $logfile 2>&1
		echo "ret_code is from intel 32 bit: $?" >> $logfile 2>&1
	fi	
elif [ "$platform" = "aarch64" ]; then
	echo "ma_updater start to run for arm 64 bit" >> $logfile 2>&1
	if [ -f $BIN_PATH_ARM64/ma_updater ] ;then
		LD_LIBRARY_PATH=${BIN_PATH_ARM64}:$LD_LIBRARY_PATH $BIN_PATH_ARM64/ma_updater -update_iam_trellix_url -logdir /var/McAfee/agent/logs >> $logfile 2>&1
		echo "ret_code is from arm 64 bit: $?" >> $logfile	2>&1
	fi
else
	echo "ma_updater start to run for intel 32 bit" >> $logfile	2>&1
	cp -rf $CURRENT_DIR/cmn.sh $INSTALL_PATH
	chmod +x $INSTALL_PATH/cmn.sh
	LD_LIBRARY_PATH=${BIN_PATH_32}:$LD_LIBRARY_PATH $BIN_PATH_32/ma_updater -update_iam_trellix_url -logdir /var/McAfee/agent/logs >> $logfile 2>&1
	echo "ret_code is from intel 32 bit: $?" >> $logfile 2>&1
fi

if [ -f $INSTALL_PATH/cmn.sh ]; then
	rm -rf $INSTALL_PATH/cmn.sh
fi