<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <xsl:template name="singleRunLevelDisabled">
        <!-- This template is used to match run level tests with the following:
            Test check="none satisfy" check_existence="any_exist"
            and state of <kill datatype="boolean">false</kill> or
            <kill datatype="boolean">0</kill>
            
            See Definition oval:com.mcafee.oval:def:8744 or oval:com.mcafee.oval:def:50417 or oval:com.mcafee.oval:def:200803030096
        -->
        <xsl:param name="definition_id" />
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="id"><xsl:value-of select="$definition_id"/></xsl:attribute>
                <xsl:variable name="test_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="runLevelTestDisabled">
                    <xsl:with-param name="test_Id" select="$test_id"/>
                </xsl:call-template>
            </xsl:element>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="singleRunLevelDisabledPositive">
        <xsl:param name="definition_id" />
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="id"><xsl:value-of select="$definition_id"/></xsl:attribute>
                <xsl:variable name="test_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="runLevelTestDisabledPositive">
                    <xsl:with-param name="test_Id" select="$test_id"/>
                </xsl:call-template>
            </xsl:element>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template name="runLevelTestDisabled">
        <xsl:param name="test_Id"/>
        <xsl:variable name="definitionTest" 
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:runlevel_test[@id=$test_Id]"/>
        <xsl:variable name="state_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:runlevel_test[@id=$test_Id]/unix-def:state/@state_ref"/>
        <xsl:variable name="state"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:runlevel_state[@id=$state_id]"/>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">service_name</xsl:attribute>
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:runlevel_object[@id=$definitionTest/unix-def:object/@object_ref]/unix-def:service_name/text()"/>
        </xsl:element>
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='true']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:runlevel_item[@id=$item_id]"/>
            <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                <!-- The service ##service_name## is is not killed at runlevel $$runlevel$$. !-->
                <xsl:attribute name="messageId">com.mcafee.pa.msg.unixSingleRunLevelDisabled0</xsl:attribute>
                <xsl:attribute name="isViolation">true</xsl:attribute>
                <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="instanceValue">
                    <xsl:attribute name="key">runlevel</xsl:attribute>
                    <xsl:value-of select="$item/unix-sc:runlevel/text()"/>
                </xsl:element>
            </xsl:element>
        </xsl:for-each>
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='false']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:runlevel_item[@id=$item_id]"/>
            <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                <!-- The service ##service_name## is killed at runlevel $$runlevel$$. !-->
                <xsl:attribute name="messageId">com.mcafee.pa.msg.unixSingleRunLevelDisabled0</xsl:attribute>
                <xsl:attribute name="isViolation">false</xsl:attribute>
                <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="instanceValue">
                    <xsl:attribute name="key">runlevel</xsl:attribute>
                    <xsl:value-of select="$item/unix-sc:runlevel/text()"/>
                </xsl:element>
            </xsl:element>
        </xsl:for-each>
        
    </xsl:template>


    <xsl:template name="runLevelTestDisabledPositive">
        <xsl:param name="test_Id"/>
        <xsl:variable name="definitionTest"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:runlevel_test[@id=$test_Id]"/>
        <xsl:variable name="state_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:runlevel_test[@id=$test_Id]/unix-def:state/@state_ref"/>
        <xsl:variable name="state"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:runlevel_state[@id=$state_id]"/>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">service_name</xsl:attribute>
            <xsl:value-of
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:runlevel_object[@id=$definitionTest/unix-def:object/@object_ref]/unix-def:service_name/text()"
            />
        </xsl:element>
        <xsl:choose>
            <xsl:when
                test="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item">
                <xsl:for-each
                    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='false']">
                    <xsl:variable name="item_id" select="@item_id"/>
                    <xsl:variable name="item"
                        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:runlevel_item[@id=$item_id]"/>
                    <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2"
                        name="finding">
                        <!-- The service ##service_name## is is not killed at runlevel $$runlevel$$. !-->
                        <xsl:attribute name="messageId"
                            >com.mcafee.pa.msg.unixSingleRunLevelDisabled0</xsl:attribute>
                        <xsl:attribute name="isViolation">true</xsl:attribute>
                        <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2"
                            name="instanceValue">
                            <xsl:attribute name="key">runlevel</xsl:attribute>
                            <xsl:value-of select="$item/unix-sc:runlevel/text()"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:for-each>
                <xsl:for-each
                    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='true']">
                    <xsl:variable name="item_id" select="@item_id"/>
                    <xsl:variable name="item"
                        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:runlevel_item[@id=$item_id]"/>
                    <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2"
                        name="finding">
                        <!-- The service ##service_name## is killed at runlevel $$runlevel$$. !-->
                        <xsl:attribute name="messageId"
                            >com.mcafee.pa.msg.unixSingleRunLevelDisabled0</xsl:attribute>
                        <xsl:attribute name="isViolation">false</xsl:attribute>
                        <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2"
                            name="instanceValue">
                            <xsl:attribute name="key">runlevel</xsl:attribute>
                            <xsl:value-of select="$item/unix-sc:runlevel/text()"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                    <!-- The service ##service_name## does not exist. !-->
                    <xsl:attribute name="messageId">com.mcafee.pa.msg.unixSingleRunLevelDisabled1</xsl:attribute>
                    <xsl:attribute name="isViolation">true</xsl:attribute>
                </xsl:element>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>
    


    <xsl:template name="singleRunLevelEnabled">
        <!-- This template is used to match run level tests with the following:
            Test check="all", check_existence="at_least_one_exists" or check_existence="all_exist", 
            and state of <start datatype="boolean">true</start> or
            <start datatype="boolean">0</start>
            
            See Definition oval:com.mcafee.oval:def:200803060031
        -->
        <xsl:param name="definition_id" />
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="id"><xsl:value-of select="$definition_id"/></xsl:attribute>
                <xsl:variable name="test_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="runLevelTestEnabled">
                    <xsl:with-param name="test_Id" select="$test_id"/>
                </xsl:call-template>
            </xsl:element>
        </xsl:if>
    </xsl:template>
    <xsl:template name="runLevelTestEnabled">
        <xsl:param name="test_Id"/>
        <xsl:variable name="definitionTest" 
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:runlevel_test[@id=$test_Id]"/>
        <xsl:variable name="state_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:runlevel_test[@id=$test_Id]/unix-def:state/@state_ref"/>
        <xsl:variable name="state"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:runlevel_state[@id=$state_id]"/>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">service_name</xsl:attribute>
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:runlevel_object[@id=$definitionTest/unix-def:object/@object_ref]/unix-def:service_name/text()"/>
        </xsl:element>
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='false']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:runlevel_item[@id=$item_id]"/>
            <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                <!-- The service ##service_name## is not started at runlevel $$runlevel$$. !-->
                <xsl:attribute name="messageId">com.mcafee.pa.msg.unixSingleRunLevelEnabled0</xsl:attribute>
                <xsl:attribute name="isViolation">true</xsl:attribute>
                <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="instanceValue">
                    <xsl:attribute name="key">runlevel</xsl:attribute>
                    <xsl:value-of select="$item/unix-sc:runlevel/text()"/>
                </xsl:element>
            </xsl:element>
        </xsl:for-each>
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='true']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:runlevel_item[@id=$item_id]"/>
            <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                <!-- The service ##service_name## is started at runlevel $$runlevel$$. !-->
                <xsl:attribute name="messageId">com.mcafee.pa.msg.unixSingleRunLevelEnabled0</xsl:attribute>
                <xsl:attribute name="isViolation">false</xsl:attribute>
                <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="instanceValue">
                    <xsl:attribute name="key">runlevel</xsl:attribute>
                    <xsl:value-of select="$item/unix-sc:runlevel/text()"/>
                </xsl:element>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>
        
</xsl:stylesheet>
