<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  xmlns:xalan="http://xml.apache.org/xalan"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
  
  <!-- This library is to handle the OVAL checks with the text file content 54 tests and a file existence test.
         Text file tests verify if specific patterns of text are present in the configuration file in test. If a specifi config file is
         present on the system, then these specific patterns should be part of the text files.

    Logic :-
    
    <criteria comment="Operating system version is Redhat Enterprise 5 on x86 or x64" operator="AND">
          <criterion comment="File existence pre-req" test_ref="oval:com.mcafee.oval:tst:200803070118"/>
          <criterion comment="File existence pre-req" test_ref="oval:com.mcafee.oval:tst:200803070119"/>
          <criterion comment="SELinux state should be set appropriate" test_ref="oval:com.mcafee.oval:tst:200803070120"/>
          <criterion comment="SELinux state should be set appropriate" negate="true" test_ref="oval:com.mcafee.oval:tst:200803070121"/>
    </criteria>
          
          
          Ex OVAL ID - oval:com.mcafee.oval:def:200803070117
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid" />
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    
    <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
    <xsl:variable name="fileTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test1/@id"/>
    <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[1]/@id"/>
    <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[2]/@id"/>
    
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
    <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
    <xsl:variable name="result4" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
    
    <xsl:variable name="definitionTextFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id]"/>
    <xsl:variable name="textfile53Path" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:path/text()" />
    <xsl:variable name="textfile53Name" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:filename/text()" />
    
    <xsl:variable name="textfilePattern1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:line/text()" />
    
    <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id1]"/>
    <xsl:variable name="textfile53Path1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()" />
    <xsl:variable name="textfile53Name1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()" />
    
    <xsl:variable name="textfilePattern" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:line/text()" />
  
    <xsl:variable name="file_info1" select="concat($textfile53Path,'/', $textfile53Name)"/>
    <xsl:variable name="file_info2" select="concat($textfile53Path1,'/', $textfile53Name1)"/>
    <xsl:variable name="file_info" select="concat($file_info1,' and ', $file_info2)"/>
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
      <!-- Check if result is true ......................................... -->
      <xsl:if test="$result='true'">
            <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
      </xsl:if>            
      <!-- Check if result is false .......................................-->
      <xsl:if test="$result='false' ">                
        <xsl:choose>
          <xsl:when test="$result1='false' and $result2='true'">
            <xsl:text>com.mcafee.pa.msg.configfile1DoesNotExists</xsl:text>
          </xsl:when>
          <xsl:when test="$result2='false' and $result1='true'">
            <xsl:text>com.mcafee.pa.msg.configfile2DoesNotExists</xsl:text>
          </xsl:when>
          <xsl:when test="$result1='false' and $result2='false'">
            <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>
          </xsl:when>
          <xsl:when test="$result3='false'">
            <xsl:text>com.mcafee.pa.msg.Pattern1MissingSCAP</xsl:text>
          </xsl:when>
          <xsl:when test="$result4='false'">
            <xsl:text>com.mcafee.pa.msg.PatternMatch2NegSCAP</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:if>  
    </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$file_info"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info2</xsl:attribute>
          <xsl:value-of select="$file_info2"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">text_file_info_1</xsl:attribute>
          <xsl:value-of select="$file_info1"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">text_file_pattern_1</xsl:attribute>
          <xsl:value-of select="$textfilePattern"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern2</xsl:attribute>
          <xsl:value-of select="$textfilePattern1"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>

