<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        This XSL is apply to the definition which are made to check whether for an application the required security update is installed or not. 
        This is specific to Microsoft Office Patch Checks of SCAP Content.
        
        Patch details will be piacked from the title. 
        
        Usual title pattern would be <Microsoft Security bulletin name> - Security Update for application name with/without service pack (Main KB name, Sub KB Name)
        
        Example: MS10-063 - Security Update for Microsoft Office 2007 SP2 (KB2320113, KB2288621)
        
         Criteria (and)
                  Criterion :  Reg or file test ( Check for application)  
                      one or more...
                  Criterion :  File or reg test ( Check service pack if required)  (OPTIONAL)
                      one or more...
                  Criterion :  File or reg test with negation=true (Check patch is installed) 
    -->
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
        
        
    </xsl:template>
    
    <!-- definition for getFindings() function -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        <xsl:call-template name="winSoftwareVersionCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- definition for winSoftwareVersionCheck() function -->
    <xsl:template name="winSoftwareVersionCheck">
        <xsl:param name="definitionId"/>       
        <xsl:param name="def_result"/>
        
         
         <xsl:variable name="title">
	<xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
                
        <xsl:variable name="software">
            <xsl:value-of select="$title"/>
        </xsl:variable>
        
       
        <xsl:variable name="tests">      
            <!-- traverse for all the tests in the criterion -->
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                
                <xsl:variable name="negationValue" select="@negate"/>
                <xsl:variable name="TestResult" select="@result"/>
                
                <xsl:variable name="test" select="@test_ref"/>
                
              <xsl:if test="$negationValue != '' ">
                  
                <!-- check if it is REGISTRY TEST -->
                <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                  
                    <xsl:variable name="object" select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>
                    <xsl:variable name="key" select="$Objects/win-def:registry_object[@id=$object]/win-def:key"/>
                    <xsl:variable name="name" select="$Objects/win-def:registry_object[@id=$object]/win-def:name"/>
                    
                    
                    
                    <xsl:variable name="externalVar" select="$States/win-def:registry_state[@id=$state]/win-def:value"/>
                    <xsl:variable name="datatype" select="$States/win-def:registry_state[@id=$state]/win-def:value/@datatype"/>
                    <xsl:variable name="operation" select="$States/win-def:registry_state[@id=$state]/win-def:value/@operation"/>
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="key">
                            <xsl:value-of select="$key"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="$name"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="operation">
                            <xsl:value-of select="$operation"/>
                        </xsl:attribute>
                        <xsl:attribute name="datatype">
                            <xsl:value-of select="$datatype"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="negationValue">
                            <xsl:value-of select="$negationValue"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="TestResult">
                            <xsl:value-of select="$TestResult"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="testtype">
                            <xsl:text>registry</xsl:text>
                        </xsl:attribute>                       
                   
                    </xsl:element>
                  
                </xsl:if>
                
                
                <!-- check if it is FILE TEST -->
                <xsl:if test="$Tests/win-def:file_test[@id=$test]">
                  
                    <xsl:variable name="state"  select="$Tests/win-def:file_test[@id=$test]/win-def:state/@state_ref"/>
                    
                    <xsl:if test="$States/win-def:file_state[@id=$state]/win-def:version">
                        <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:version)"/>
                        <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:version"/>
                        <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:version/@operation"/>
                        <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                        
                     <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                         <xsl:attribute name="versionnodename">
                             <xsl:value-of select="$versionnode"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="operation">
                            <xsl:value-of select="$operation"/>
                        </xsl:attribute>
                         <xsl:attribute name="negationValue">
                             <xsl:value-of select="$negationValue"/>
                         </xsl:attribute>
                         
                         <xsl:attribute name="TestResult">
                             <xsl:value-of select="$TestResult"/>
                         </xsl:attribute>
                         
                        <xsl:attribute name="testtype">
                            <xsl:text>file</xsl:text>
                        </xsl:attribute>
                      
                     </xsl:element>
                       
                   </xsl:if>
                    
                    <xsl:if test="$States/win-def:file_state[@id=$state]/win-def:product_version">
                        <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:product_version)"/>
                        <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:product_version"/>
                        <xsl:variable name="operation" select="$States/win-def:file_state[@id=$state]/win-def:product_version/@operation"/>
                        <xsl:variable name="datatype" select="$States/win-def:file_state[@id=$state]/win-def:version/@datatype"/>
                        
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="versionnodename">
                                <xsl:value-of select="$versionnode"/>
                            </xsl:attribute>
                            <xsl:attribute name="externalVar">
                                <xsl:value-of select="$externalVar"/>
                            </xsl:attribute>
                            <xsl:attribute name="operation">
                                <xsl:value-of select="$operation"/>
                            </xsl:attribute>
                            
                            <xsl:attribute name="negationValue">
                                <xsl:value-of select="$negationValue"/>
                            </xsl:attribute>
                            
                            <xsl:attribute name="TestResult">
                                <xsl:value-of select="$TestResult"/>
                            </xsl:attribute>
                            
                            <xsl:attribute name="testtype">
                                <xsl:text>file</xsl:text>
                            </xsl:attribute>
                            
                        </xsl:element>
                    </xsl:if>
                </xsl:if>
                
              </xsl:if>
            </xsl:for-each>                        
        </xsl:variable>
                     
            <!-- Now create Findings result xml -->

            <!-- Check if result is FALSE -->
        
        <!-- ******************************* for MS office swaped the results ********************  -->
        
               <xsl:if test="$def_result = 'true' ">
                   <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                       
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry'  ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="key" select="@key"/>
                    <xsl:variable name="name" select="@name"/>                   
                    <xsl:variable name="datatype" select="@datatype"/>
                    <xsl:variable name="externalVarId" select="@externalVar"/>
                    <xsl:variable name="operation" select="@operation"/>
                    <xsl:variable name="negationValue" select="@negationValue"/>
                    
                    <xsl:variable name="inputVersion" 
                        select="$externalVarId"/>
              
                                                            
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        <xsl:variable name="actualVersion" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                        <xsl:variable name="actualVersionStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                        
                        <xsl:variable name="message_id">
                            <xsl:choose>
                                <xsl:when test="$actualVersionStatus = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.SecUpdNotApplicable_MNAC</xsl:text>                                    
                                </xsl:when>
                                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                    <xsl:text>com.mcafee.pa.msg.winsoftwareversionreaderror</xsl:text>                                    
                                </xsl:when>                                
                                <xsl:otherwise>
                                    <xsl:choose>
                                        <xsl:when test="$operation = 'greater than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="$operation = 'less than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>          
                                        </xsl:otherwise>
                                    </xsl:choose>                                   
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        
                        <xsl:if test="$negationValue='true'">
                        <finding messageId="{$message_id}" isViolation="true">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue>
                            <instanceValue key="inputVersion">
                                <xsl:value-of select="$inputVersion"/>                                                    
                            </instanceValue>
                            <instanceValue key="neagtion">
                                <xsl:value-of select="$negationValue"/>                                                    
                            </instanceValue>
                            <instanceValue key="registry">
                                <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                            </instanceValue>                            
                            <actualValue key="actualVersion">
                                <xsl:value-of select="$actualVersion"/>                                                    
                            </actualValue>
                        </finding>
                        </xsl:if>
                    </xsl:for-each>
                    
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'  ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        <xsl:variable name="actualVersion" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                        <xsl:variable name="actualVersionStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                        
                        <xsl:variable name="message_id">
                            <xsl:choose>           
                                <xsl:when test="$operation = 'greater than or equal' ">
                                    <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                </xsl:when>
                                <xsl:when test="$operation = 'less than or equal' ">
                                    <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>          
                                </xsl:otherwise>
                            </xsl:choose>                                  
                        </xsl:variable>
                        
                        <xsl:if test="$negationValue='true'">
                        <finding messageId="{$message_id}" isViolation="true">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue> 
                            <instanceValue key="inputVersion">
                                <xsl:value-of select="$inputVersion"/>                                                    
                            </instanceValue>
                            <instanceValue key="neagtion">
                                <xsl:value-of select="$negationValue"/>                                                    
                            </instanceValue>
                            <instanceValue key="registry">
                                <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                            </instanceValue>                            
                            <actualValue key="actualVersion">
                                <xsl:value-of select="$actualVersion"/>                                                    
                            </actualValue>
                        </finding>
                            </xsl:if>
                    </xsl:for-each>
                    
                </xsl:for-each>
                       
               <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                    <xsl:variable name="test" select="@id"/>
                   <xsl:variable name="versionnode" select="@versionnode"/>
                    <xsl:variable name="externalVarId" select="@externalVar"/>
                    <xsl:variable name="operation" select="@operation"/>
                   <xsl:variable name="datatype" select="@datatype"/>
                   <xsl:variable name="negationValue" select="@negationValue"/>
                    
                   <xsl:variable name="inputVersion" 
                       select="$externalVarId"/>
                   
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                    <xsl:variable name="path" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:path"/>
                    <xsl:variable name="file" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename"/>
                    <xsl:variable name="fileStatus" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename/@status"/>
                        
                        <xsl:variable name="version">
                            <xsl:choose>
                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                                </xsl:when>
                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:variable>
                        
                        <xsl:variable name="versionStatus">
                            <xsl:choose>
                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version/@status"/>
                                </xsl:when>
                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version/@status"/>
                                </xsl:when>
                            </xsl:choose>                            
                        </xsl:variable>
                        
                        <xsl:variable name="message_id">
                            <xsl:choose>
                                <xsl:when test="$fileStatus = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.SecUpdNotApplicable_MNAC</xsl:text>                                    
                                </xsl:when>
                                <xsl:when test="$versionStatus = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.SecUpdNotApplicable_MNAC</xsl:text>                                    
                                </xsl:when>
                                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                    <xsl:text>com.mcafee.pa.msg.winsoftwarefileversionreaderror</xsl:text>                                    
                                </xsl:when>                                
                                <xsl:otherwise>
                                    <xsl:choose>
                                        <xsl:when test="$operation = 'greater than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="$operation = 'less than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>          
                                        </xsl:otherwise>
                                    </xsl:choose>                                   
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                                            
                        <xsl:if test="$negationValue='true'">
                        <finding messageId="{$message_id}" isViolation="true">
                            <instanceValue key="software">
                                <xsl:value-of select="$software"/>                                                    
                            </instanceValue>   
                            <instanceValue key="inputVersion">
                                <xsl:value-of select="$inputVersion"/>                                                    
                            </instanceValue>
                            <instanceValue key="filename">
                                <xsl:value-of select="$file"/>                                                    
                            </instanceValue> 
                            <instanceValue key="negation">
                                <xsl:value-of select="$negationValue"/>                                                    
                            </instanceValue>
                            <actualValue key="actualVersion">
                                <xsl:value-of select="$version"/>                                                    
                            </actualValue>
                        </finding>
                        </xsl:if>
                    </xsl:for-each>
                   
                   <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true' ] ">
                       
                       <xsl:variable name="itemRef" select="@item_id"/>
                       <xsl:variable name="result" select="@result"/>
                       
                       <xsl:variable name="path" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:path"/>
                       <xsl:variable name="file" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename"/>
                       <xsl:variable name="fileStatus" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename/@status"/>
                       
                       <xsl:variable name="version">
                           <xsl:choose>
                               <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                   <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                               </xsl:when>
                               <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                   <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                               </xsl:when>
                           </xsl:choose>
                       </xsl:variable>
                       
                       <xsl:variable name="versionStatus">
                           <xsl:choose>
                               <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                   <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version/@status"/>
                               </xsl:when>
                               <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                   <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version/@status"/>
                               </xsl:when>
                           </xsl:choose>                            
                       </xsl:variable>
                       
                       <xsl:variable name="message_id">
                           <xsl:choose>
                               <xsl:when test="$operation = 'greater than or equal' ">
                                   <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                               </xsl:when>
                               <xsl:when test="$operation = 'less than or equal' ">
                                   <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                               </xsl:when>
                               <xsl:otherwise>
                                   <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>          
                               </xsl:otherwise>
                           </xsl:choose>                                  
                       </xsl:variable>
                       
                       <xsl:if test="$negationValue='true'">
                       <finding messageId="{$message_id}" isViolation="true">
                           <instanceValue key="software">
                               <xsl:value-of select="$software"/>                                                    
                           </instanceValue>   
                           <instanceValue key="inputVersion">
                               <xsl:value-of select="$inputVersion"/>                                                    
                           </instanceValue>
                           <instanceValue key="negation">
                               <xsl:value-of select="$negationValue"/>                                                    
                           </instanceValue>
                           <instanceValue key="filename">
                               <xsl:value-of select="$path"/><xsl:text>\</xsl:text><xsl:value-of select="$file"/>                                                    
                           </instanceValue> 
                           <actualValue key="actualVersion">
                               <xsl:value-of select="$version"/>                                                    
                           </actualValue>
                       </finding>
                         </xsl:if>
                       
                   </xsl:for-each>
                   
                   
                </xsl:for-each>

                       
                </findings>
             </xsl:if>
        
        <!-- ******************************* for MS office swaped the results ********************  -->
        
        <!-- ======================================== Nandini ====================================================== -->
        
        <xsl:if test="$def_result = 'false' ">
            
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                
               <xsl:variable name="CheckSoftwareInstalled">
                    <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry'  ]">
                        <xsl:variable name="test" select="@id"/>          
                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                            <xsl:text>1</xsl:text>
                        </xsl:for-each>
                    </xsl:for-each> 
                    <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                        <xsl:variable name="test" select="@id"/>                           
                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                            <xsl:text>1</xsl:text>                                                                                             
                        </xsl:for-each>
                    </xsl:for-each>      
                </xsl:variable>
                
                <xsl:if test="not(contains($CheckSoftwareInstalled,'1'))">
                   <!-- <finding messageId="com.mcafee.pa.msg.winsoftwareversionnotexist" isViolation="false"> -->
                    <finding messageId="com.mcafee.pa.msg.SecUpdNotApplicable_MNAC" isViolation="false">
                        <instanceValue key="software">
                            <xsl:value-of select="$software"/>                                                    
                        </instanceValue>
                    </finding>
                </xsl:if>
                
                
                <!-- ==================================================================================================================== -->
                    
                <xsl:variable name="CheckSoftwareNotInstalled">
                    <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry'  ]">
                        <xsl:variable name="test" select="@id"/>          
                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                            <xsl:text>1</xsl:text>
                        </xsl:for-each>
                    </xsl:for-each> 
                    <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                        <xsl:variable name="test" select="@id"/>                           
                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                            <xsl:text>1</xsl:text>                                                                                             
                        </xsl:for-each>
                    </xsl:for-each>      
                </xsl:variable>
                
                <xsl:if test="contains($CheckSoftwareNotInstalled,'1')">
                   <!-- <finding messageId="com.mcafee.pa.msg.winsoftwareversionnotexist" isViolation="false"> -->
                    <finding messageId="com.mcafee.pa.msg.SecUpdNotApplicable_MNAC" isViolation="false">
                        <instanceValue key="software">
                            <xsl:value-of select="$software"/>                                                    
                        </instanceValue>
                    </finding>
                </xsl:if>
                    
                <!-- ==================================================================================================================== -->
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'registry'  ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="key" select="@key"/>
                    <xsl:variable name="name" select="@name"/>                   
                    <xsl:variable name="datatype" select="@datatype"/>
                    <xsl:variable name="externalVarId" select="@externalVar"/>
                    <xsl:variable name="operation" select="@operation"/>
                    <xsl:variable name="negationValue" select="@negationValue"/>
                    <xsl:variable name="TestResult" select="@TestResult"/>
                    
                    <xsl:variable name="inputVersion" 
                        select="$externalVarId"/>
                    
                    
                  <!-- <xsl:if test="TestResult='false'"> -->
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true'] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        <xsl:variable name="actualVersion" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                        <xsl:variable name="actualVersionStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                        
                        <xsl:variable name="message_id">
                            <xsl:choose>
                                <xsl:when test="$actualVersionStatus = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.SecUpdNotApplicable_MNAC</xsl:text>                                    
                                </xsl:when>
                                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                    <xsl:text>com.mcafee.pa.msg.winsoftwareversionreaderror</xsl:text>                                    
                                </xsl:when>                                
                                <xsl:otherwise>
                                    <xsl:choose>
                                        <xsl:when test="$operation = 'greater than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="$operation = 'less than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>          
                                        </xsl:otherwise>
                                    </xsl:choose>                                   
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        
                        <xsl:if test="$negationValue='true'">
                            <finding messageId="{$message_id}" isViolation="false">
                                <instanceValue key="software">
                                    <xsl:value-of select="$software"/>                                                    
                                </instanceValue>    
                                <instanceValue key="inputVersion">
                                    <xsl:value-of select="$inputVersion"/>                                                    
                                </instanceValue>
                                <instanceValue key="neagtion">
                                    <xsl:value-of select="$negationValue"/>                                                    
                                </instanceValue>
                                <instanceValue key="registry">
                                    <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                                </instanceValue>                            
                                <actualValue key="actualVersion">
                                    <xsl:value-of select="$actualVersion"/>                                                    
                                </actualValue>
                            </finding>
                        </xsl:if>
                    </xsl:for-each>
                <!--  </xsl:if>  -->

                </xsl:for-each>
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="versionnode" select="@versionnode"/>
                    <xsl:variable name="externalVarId" select="@externalVar"/>
                    <xsl:variable name="operation" select="@operation"/>
                    <xsl:variable name="datatype" select="@datatype"/>
                    <xsl:variable name="negationValue" select="@negationValue"/>
                    
                    <xsl:variable name="inputVersion" 
                        select="$externalVarId"/>
                  
                    <!-- <xsl:if test="TestResult='false'"> -->
                    <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true' ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                        
                        <xsl:variable name="path" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:path"/>
                        <xsl:variable name="file" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename"/>
                        <xsl:variable name="fileStatus" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename/@status"/>
                        
                        <xsl:variable name="version">
                            <xsl:choose>
                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version"/>
                                </xsl:when>
                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:variable>
                        
                        <xsl:variable name="versionStatus">
                            <xsl:choose>
                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:product_version/@status"/>
                                </xsl:when>
                                <xsl:when test="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version/@status"/>
                                </xsl:when>
                            </xsl:choose>                            
                        </xsl:variable>
                        
                        <xsl:variable name="message_id">
                            <xsl:choose>
                                <xsl:when test="$fileStatus = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.SecUpdNotApplicable_MNAC</xsl:text>                                    
                                </xsl:when>
                                <xsl:when test="$versionStatus = 'does not exist' ">
                                    <xsl:text>com.mcafee.pa.msg.SecUpdNotApplicable_MNAC</xsl:text>                                    
                                </xsl:when>
                                <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                    <xsl:text>com.mcafee.pa.msg.winsoftwarefileversionreaderror</xsl:text>                                    
                                </xsl:when>                                
                                <xsl:otherwise>
                                    <xsl:choose>
                                        <xsl:when test="$operation = 'greater than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                        </xsl:when>
                                        <xsl:when test="$operation = 'less than or equal' ">
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:text>com.mcafee.pa.msg.SecUpdInstalled_MNAC</xsl:text>          
                                        </xsl:otherwise>
                                    </xsl:choose>                                   
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:variable>
                        
                        <xsl:if test="$negationValue='true'">
                            <finding messageId="{$message_id}" isViolation="false">
                                <instanceValue key="software">
                                    <xsl:value-of select="$software"/>                                                    
                                </instanceValue>   
                                <instanceValue key="inputVersion">
                                    <xsl:value-of select="$inputVersion"/>                                                    
                                </instanceValue>
                                <instanceValue key="filename">
                                    <xsl:value-of select="$file"/>                                                    
                                </instanceValue> 
                                <instanceValue key="negation">
                                    <xsl:value-of select="$negationValue"/>                                                    
                                </instanceValue>
                                <actualValue key="actualVersion">
                                    <xsl:value-of select="$version"/>                                                    
                                </actualValue>
                            </finding>
                        </xsl:if>
                    </xsl:for-each>
           <!--     </xsl:if> --> 
                    
                </xsl:for-each>
                
                
            </findings>
        </xsl:if>
        
        <!-- ======================================== Nandini ====================================================== -->
        
    </xsl:template>
</xsl:stylesheet>