<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan" xmlns:fnd="http://results.pa.mcafee.com/findings/5.2">

    <!--
    
    	This XSLT is used to verify the certain lock out  policy setting against user input.
    	
        Criterio (and)
    	        citerion family test or extend def
    	        criterion  lockout  policy  test
        
    -->

    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>

    <xsl:template name="removeUnderScore">
        <xsl:param name="string"/>
        <xsl:param name="count"/>
        <xsl:param name="length"/>

        <xsl:if test="$count  &lt;= $length">

            <xsl:variable name="char">
                <xsl:value-of select="substring($string,$count,1)"/>
            </xsl:variable>

            <xsl:choose>
                <xsl:when test="$char != '_' ">
                    <xsl:value-of select="$char"/>
                    <xsl:call-template name="removeUnderScore">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="count" select="$count + 1"/>
                        <xsl:with-param name="length" select="$length"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="removeUnderScore">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="count" select="$count + 1"/>
                        <xsl:with-param name="length" select="$length"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>

    </xsl:template>

    <xsl:template name="getSuffixFormEventName">
        <xsl:param name="name"/>

        <xsl:variable name="suffix1">
            <xsl:call-template name="removeUnderScore">
                <xsl:with-param name="string" select="$name"/>
                <xsl:with-param name="length" select="string-length($name)"/>
                <xsl:with-param name="count" select="1 + 0"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$suffix1"/>
    </xsl:template>

    <xsl:template name="getMessageId">
        <xsl:param name="name"/>
        <xsl:param name="status"/>

        <xsl:if
            test="$name = 'lockout_duration'  or $name = 'lockout_threshold'   or $name = 'lockout_observation_window'  or $name = 'force_logoff' ">
            <xsl:variable name="suffiex">
                <xsl:call-template name="getSuffixFormEventName">
                    <xsl:with-param name="name" select="$name"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="$suffiex = '' ">
                    <xsl:text/>
                </xsl:when>
                <xsl:when test="$status = 'does not exist' ">
                    <xsl:value-of select="concat('com.mcafee.pa.msg.no',$suffiex)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('com.mcafee.pa.msg.',$suffiex)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>

    </xsl:template>

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

        <xsl:variable name="unorderedFindings">
            <xsl:call-template name="winLockoutPolicyCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
                <xsl:with-param name="def_result" select="$result"/>
            </xsl:call-template>
        </xsl:variable>

        <!-- Now arrange all the nodes to fit the schema. All <inputValue/> nodes must come first, followed by all <finding/> nodes-->

        <findings id="{xalan:nodeset($unorderedFindings)/descendant::fnd:findings/@id}"
            xmlns="http://results.pa.mcafee.com/findings/5.2">
            <xsl:copy>
                <xsl:copy-of select="xalan:nodeset($unorderedFindings)/descendant::fnd:inputValue"/>
                <xsl:copy-of select="xalan:nodeset($unorderedFindings)/descendant::fnd:finding"/>
            </xsl:copy>
        </findings>
    </xsl:template>

    <xsl:template name="winLockoutPolicyCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>


        <xsl:variable name="tests">
            <xsl:for-each
                select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:lockoutpolicy_test[@id=$test]">
                    <xsl:variable name="object"
                        select="$Tests/win-def:lockoutpolicy_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"
                        select="$Tests/win-def:lockoutpolicy_test[@id=$test]/win-def:state/@state_ref"/>

                    <xsl:variable name="externalVar"
                        select="$States/win-def:lockoutpolicy_state[@id=$state]/child::node()/@var_ref"/>

                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                        </xsl:attribute>
                        <xsl:attribute name="externalVar">
                            <xsl:value-of select="$externalVar"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>lockout</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>

                <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>family</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>

        </xsl:variable>


        <xsl:variable name="exDefinitionId">
            <xsl:for-each
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition[@result = 'false'] ">
                <xsl:if test="./parent::node()/@result = 'false' ">
                    <xsl:element name="extend_definition">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@definition_ref"/>
                        </xsl:attribute>
                        <xsl:attribute name="result">
                            <xsl:value-of select="@result"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>

        <xsl:variable name="rs_exDefinition">
            <xsl:value-of
                select="xalan:nodeset($exDefinitionId)/descendant::extend_definition/@result"/>
        </xsl:variable>

        <xsl:variable name="pre_test_result">
            <xsl:choose>
                <xsl:when test="$rs_exDefinition != '' ">
                    <xsl:value-of select="$rs_exDefinition"/>
                </xsl:when>
                <xsl:when
                    test="xalan:nodeset($tests)/descendant::test[ @type ='family' ]/@id != '' ">
                    <xsl:variable name="test"
                        select="xalan:nodeset($tests)/descendant::test[ @type ='family' ]/@id"/>
                    <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/@result"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>true</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:if test=" $pre_test_result = 'true'  and $def_result = 'false' ">
            <xsl:variable name="test"
                select="xalan:nodeset($tests)/descendant::test[ @type ='lockout' ]/@id"/>
            <xsl:variable name="state"
                select="xalan:nodeset($tests)/descendant::test[ @type ='lockout' ]/@state"/>
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

                <xsl:for-each
                    select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="result" select="@result"/>

                    <xsl:for-each select="$States/win-def:lockoutpolicy_state[@id=$state ]/*">
                        <xsl:variable name="lockoutpolicy_parameter" select="name(.)"/>
                        <xsl:variable name="externalVarId" select="@var_ref"/>
                        <xsl:variable name="externalVarValue"
                            select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                        <xsl:for-each select="$SystemData/win-sc:lockoutpolicy_item[@id=$itemRef]/*">
                            <xsl:if test="name(.) = $lockoutpolicy_parameter">
                                <xsl:variable name="actualParameterValue" select="text()"/>
                                <xsl:variable name="actualParameterStatus">
                                    <xsl:if test="$actualParameterValue = '' ">
                                        <xsl:text>does not exist</xsl:text>
                                    </xsl:if>
                                </xsl:variable>
                                <xsl:variable name="message_id">
                                    <xsl:call-template name="getMessageId">
                                        <xsl:with-param name="name"
                                            select="normalize-space($lockoutpolicy_parameter)"/>
                                        <xsl:with-param name="status"
                                            select="normalize-space($actualParameterStatus)"/>
                                    </xsl:call-template>
                                </xsl:variable>
                                <xsl:variable name="msgSuffix">
                                    <xsl:call-template name="getSuffixFormEventName">
                                        <xsl:with-param name="name"
                                            select="normalize-space($lockoutpolicy_parameter)"/>
                                    </xsl:call-template>
                                </xsl:variable>
                                <xsl:if
                                    test="$message_id != '' and $externalVarValue != $actualParameterValue">
                                    <xsl:variable name="inputKey"
                                        select="concat('inputValue_', $msgSuffix)"/>
                                    <inputValue key="{$inputKey}">
                                        <xsl:value-of select="$externalVarValue"/>
                                    </inputValue>
                                    <finding messageId="{$message_id}" isViolation="true">
                                        <actualValue key="actualValue">
                                            <xsl:value-of select="$actualParameterValue"/>
                                        </actualValue>
                                    </finding>
                                </xsl:if>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </findings>
        </xsl:if>

        <xsl:if test="$def_result = 'true' ">
            <xsl:variable name="test"
                select="xalan:nodeset($tests)/descendant::test[ @type ='lockout' ]/@id"/>
            <xsl:variable name="state"
                select="xalan:nodeset($tests)/descendant::test[ @type ='lockout' ]/@state"/>
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

                <xsl:for-each
                    select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result ='true' ] ">

                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="result" select="@result"/>
                    <xsl:variable name="testid" select="./parent::node()/@test_id"/>
                    ./parent::node()/@result = 'false' 
                    <xsl:for-each select="$States/win-def:lockoutpolicy_state[@id=$state ]/*">
                        <xsl:variable name="lockoutpolicy_parameter" select="name(.)"/>
                        <xsl:variable name="externalVarId" select="@var_ref"/>
                         <xsl:variable name="externalVarValue"
                            select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
                        <xsl:for-each select="$SystemData/win-sc:lockoutpolicy_item[@id=$itemRef]/*">
                            <xsl:if test="name(.) = $lockoutpolicy_parameter">
                                <xsl:variable name="actualParameterValue" select="text()"/>
                                <xsl:variable name="actualParameterStatus">
                                    <xsl:if test="$actualParameterValue = '' ">
                                        <xsl:text>does not exist</xsl:text>
                                    </xsl:if>
                                </xsl:variable>
                                <xsl:variable name="message_id">
                                    <xsl:call-template name="getMessageId">
                                        <xsl:with-param name="name"
                                            select="normalize-space($lockoutpolicy_parameter)"/>
                                        <xsl:with-param name="status"
                                            select="normalize-space($actualParameterStatus)"/>
                                    </xsl:call-template>
                                </xsl:variable>
                                <xsl:choose>
                                    <xsl:when test="$message_id != '' and $externalVarValue != $actualParameterValue and string($lockoutpolicy_parameter) != 'lockout_threshold'  " >
                                    <inputValue key="inputValue">
                                        <xsl:value-of select="$externalVarValue"/>
                                    </inputValue>
                                    <finding messageId="{$message_id}" isViolation="false">
                                        <actualValue key="actualValue">
                                            <xsl:value-of select="$actualParameterValue"/>
                                        </actualValue>
                                    </finding>
                                    </xsl:when>
                                    <xsl:when test="$externalVarValue = $actualParameterValue and string($lockoutpolicy_parameter) = 'lockout_threshold' and string($testid) = 'oval:com.mcafee.oval.windows:tst:20'">
                                        <inputValue key="inputValue">
                                            <xsl:value-of select="$externalVarValue"/>
                                        </inputValue>
                                         <finding messageId="com.mcafee.pa.msg.account.lockout.equal" isViolation="false">
                                            <actualValue key="actualValue">
                                                <xsl:value-of select="$actualParameterValue"/>
                                            </actualValue>
                                        </finding>
                                     </xsl:when> 
                                    <xsl:when test="$actualParameterValue  &lt; $externalVarValue and string($lockoutpolicy_parameter) = 'lockout_threshold' and string($testid) = 'oval:com.mcafee.oval.windows:tst:20'" >
                                        <inputValue key="inputValue">
                                            <xsl:value-of select="$externalVarValue"/>
                                        </inputValue>
                                         <finding messageId="com.mcafee.pa.msg.account.lockout.lt" isViolation="false">
                                            <actualValue key="actualValue">
                                                <xsl:value-of select="$actualParameterValue"/>
                                            </actualValue>
                                        </finding>
                                    </xsl:when>                                                               
                                </xsl:choose>
                              </xsl:if>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </findings>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
