<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with the 2 set of text file test and file existence test.
         Text file test verifies if a specific pattern of text is not present in the configuration file in test.
          
      <criteria operator="AND">
            <criteria comment="For RHEL 5 and earlier" operator="OR">
              <criterion comment="File existence pre-req" negate="true" test_ref="oval:com.mcafee.oval:tst:200803070028" />
              <criterion comment="Default routers should not be sent by the DHCP server as appropriate" test_ref="oval:com.mcafee.oval:tst:200803070029" />
              </criteria>
          <criteria comment="For RHEL 6" operator="OR">
              <criterion comment="File existence pre-req" negate="true" test_ref="oval:com.mcafee.oval:tst:240017" />
              <criterion comment="Default routers should not be sent by the DHCP server as appropriate" negate="true" test_ref="oval:com.mcafee.oval:tst:240025" />
          </criteria>
      </criteria>
          
          without external variable & OVAL State.
          
          Ex. OVAL ID's: oval:com.mcafee.oval:def:200803070027
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
   <xsl:variable name="fileContentVar1">
     <xsl:choose>
       <xsl:when test="count(/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test)=2">
         <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
       </xsl:when>
       <xsl:when test="count(/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test)=2">
         <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[1]/@id"/>
       </xsl:when>
       <xsl:when test="count(/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test)=1">
         <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
       </xsl:when>
     </xsl:choose>
   </xsl:variable> 
    
    <xsl:variable name="fileContentVar2">
      <xsl:choose>
        <xsl:when test="count(/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test)=2">
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        </xsl:when>
        <xsl:when test="count(/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test)=2">
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[2]/@id"/>
        </xsl:when>
        <xsl:when test="count(/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test)=1">
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[1]/@id"/>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="fileTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[1]/@id"/>
    
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id1]/@result"/>
          
    <xsl:variable name="result2">
      <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentVar1]/@result"/>
    </xsl:variable>
    
    <xsl:variable name="definitionFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id1]"/>
    
   <xsl:variable name="filePath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest1/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest1/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="textFilePath1">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar1]!=''">
          <xsl:variable name="definitionTextFile54Test1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test1/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentVar1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textFileName1">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar1]!=''">
          <xsl:variable name="definitionTextFile54Test1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test1/ind-def:object/@object_ref]/ind-def:name/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentVar1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:name/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textfilePattern1">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar1]!=''">
          <xsl:variable name="definitionTextFile54Test1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test1/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentVar1]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:line/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="fileInfo1">
      <xsl:choose>
        <xsl:when test="$fileTest_id1 != ' ' ">
          <xsl:value-of select="concat($filePath1,'/', $fileName1)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($textFilePath1,'/', $textFileName1)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="fileTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[2]/@id"/>
    
    <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id2]/@result"/>
    
    <xsl:variable name="result4">
      <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentVar2]/@result"/>
    </xsl:variable>
    
    <xsl:variable name="definitionFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id2]"/>
    
    <xsl:variable name="filePath2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest2/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest2/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="textFilePath2">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar2]!=''">
          <xsl:variable name="definitionTextFile54Test2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test2/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentVar2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:path/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textFileName2">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar2]!=''">
          <xsl:variable name="definitionTextFile54Test2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test2/ind-def:object/@object_ref]/ind-def:name/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentVar2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:name/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="textfilePattern2">
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar2]!=''">
          <xsl:variable name="definitionTextFile54Test2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentVar2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFile54Test2/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentVar2]"/>
          <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:line/text()"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="fileInfo2">
      <xsl:choose>
        <xsl:when test="$fileTest_id2 != ' ' ">
          <xsl:value-of select="concat($filePath2,'/', $fileName2)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="concat($textFilePath2,'/', $textFileName2)"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="fileInfo" select="concat($fileInfo1,', ', $fileInfo2)"/>
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
      <xsl:if test="$result='true'">
        <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
      </xsl:if>
      <xsl:if test="$result='false'">
        <xsl:text>com.mcafee.pa.msg.PatternsMatchNegSCAP</xsl:text>
      </xsl:if>
   </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern1</xsl:attribute>
          <xsl:value-of select="$textfilePattern1"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info1</xsl:attribute>
          <xsl:value-of select="$fileInfo1"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern2</xsl:attribute>
          <xsl:value-of select="$textfilePattern2"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info2</xsl:attribute>
          <xsl:value-of select="$fileInfo2"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$fileInfo"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>