<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        This library works for the below logic :-
        
        <criteria>
            <criteria operator="AND">
                <criterion comment="Registry key HKLM\System\CurrentControlSet\Control\LSA\\Notification Packages has type REG_MULTI_SZ" test_ref="oval:com.mcafee.oval.windows:tst:609"/> - Reg type test
                <criterion comment="HKLM\System\CurrentControlSet\Control\LSA\\Notification Packages = enpasflt" test_ref="oval:com.mcafee.oval.windows:tst:610"/> - Reg value test
            </criteria>
        </criteria>
     
     Ex: - oval:com.mcafee.oval.windows:def:230
     
     No external variable.
    -->
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    
    <xsl:template name="concatWithDelimiter">
        <xsl:param name="currIndex"/>
        <xsl:param name="paramValue"/>
        <xsl:param name="lastIndex"/>
        
        <xsl:choose>
            <xsl:when test="$currIndex &lt;=$lastIndex">
                
                <xsl:variable name="currValue" select="$SystemData/win-sc:registry_item/win-sc:value[$currIndex]/text()"/>
                
                <xsl:call-template name="concatWithDelimiter">
                    <xsl:with-param name="currIndex" select="$currIndex + 1"/>
                    <xsl:with-param name="paramValue" select="concat($paramValue, '  ', $currValue)"/>
                    <xsl:with-param name="lastIndex" select="$lastIndex"/>
                </xsl:call-template>
                
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$paramValue != ''">
                    <xsl:value-of select="substring($paramValue,2)"/>
                </xsl:if>                
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="regTypeRes"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="regRes"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        
        <xsl:variable name="title">
             <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
       
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="regTypeExpectecValue">
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/win-def:registry_state[2]/win-def:type/text()"/>
        </xsl:variable>
        
        <xsl:variable name="expectedValue">
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/win-def:registry_state[1]/win-def:value/text()"/>
        </xsl:variable>
        
        <xsl:variable name="actualValue">
            <xsl:variable name="RegItemId" select="$SystemData/win-sc:registry_item/@id"/>
            <xsl:choose>
                <xsl:when test="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value != ''">
                    
                        <xsl:call-template name="concatWithDelimiter">
                            <xsl:with-param name="currIndex" select="1"/>
                            <xsl:with-param name="paramValue"/>
                            <xsl:with-param name="lastIndex" select="count($SystemData/win-sc:registry_item/win-sc:value/text())"/>
                        </xsl:call-template>
                    
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>Not Configured/Disabled</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="regTypeActualValue">
            <xsl:variable name="RegItemId" select="$SystemData/win-sc:registry_item/@id"/>
            <xsl:choose>
                <xsl:when test="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:value != ''">
                    <xsl:value-of select="$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:type"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>Not Configured</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="regValue">
            <xsl:variable name="RegItemId" select="$SystemData/win-sc:registry_item/@id"/>
                <xsl:value-of select="concat($SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:key,'\',$SystemData/win-sc:registry_item[@id=$RegItemId]/win-sc:name)"/>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:variable name="regStatus" select="$SystemData/win-sc:registry_item/@status"/>
            <xsl:choose>
                <xsl:when test="$regStatus= 'does not exist'">
                    <xsl:text>com.mcafee.pa.msg.winnoconfiguration_SCAP</xsl:text>                    
                </xsl:when>
                <xsl:when test="$regTypeRes= 'true'">
                    <xsl:text>com.mcafee.pa.msg.winconfiguration_SCAP</xsl:text>                    
                </xsl:when>
                <xsl:when test="$regTypeRes= 'false' and $regRes='true'">
                    <xsl:text>com.mcafee.pa.msg.winRegType_SCAP</xsl:text>                    
                </xsl:when>
                <xsl:when test="$regTypeRes= 'false' and $regRes='false'">
                    <xsl:text>com.mcafee.pa.msg.winRegTypeRegVal_SCAP</xsl:text>                    
                </xsl:when>
            </xsl:choose>
        </xsl:variable>    
            
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                <inputValue key="expectedValue">
                      <xsl:value-of select="$expectedValue"/>
                </inputValue>
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">                                                            
                   <instanceValue key="config">
                         <xsl:value-of select="$title"/>
                   </instanceValue>                                      
                <instanceValue key="expectedRegType">
                    <xsl:value-of select="$regTypeExpectecValue"/>
                </instanceValue>
                <instanceValue key="actualRegType">
                    <xsl:value-of select="$regTypeActualValue"/>
                </instanceValue>
                <instanceValue key="RegValue">
                    <xsl:value-of select="$regValue"/>
                </instanceValue>
                <actualValue key="actualValue">
                          <xsl:value-of select="$actualValue"/>
                 </actualValue>
           </finding>
        </findings>
</xsl:template>
</xsl:stylesheet>