<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to handle the OVAL checks with the One file_test and two text files to match state pattern.
        
        Logic :-
        
        <criteria operator="AND">
        <criterion comment="The old password file exists" test_ref="oval:com.mcafee.oval:tst:51120" />
        <criterion comment="The number of passwords remembered is configured" test_ref="oval:com.mcafee.oval:tst:430797" />
        <criterion comment="The number of passwords remembered is configured" test_ref="oval:com.mcafee.oval:tst:430798" />
        </criteria>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:430796
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>        
        <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>        
        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
        <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
        
        <xsl:variable name="file_info">
            <xsl:value-of select="concat($filePath,$fileName)"/>
        </xsl:variable>
        
        
        <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id1]/@result"/>
        

        <xsl:variable name="extVar_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable/@id"/>
        
        <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]"/>
        <xsl:variable name="textfilePath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfileName1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="textfilePattern1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:pattern/text()" />
        
        <xsl:variable name="filecontentObj_ref1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]/ind-def:object/@object_ref" />
        <xsl:variable name="filecontentObj_flag1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$filecontentObj_ref1]/@flag"/>
        
        <xsl:variable name="filecontentitem_id1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id1]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="filecontentitem1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$filecontentitem_id1]"/>
        <xsl:variable name="actual_config1" select="$filecontentitem1/ind-sc:subexpression/text()"/>
        
        <xsl:variable name="file_info1">
            <xsl:value-of select="concat($textfilePath1,'/', $textfileName1)"/>
        </xsl:variable>
        
        
        <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id2]/@result"/>
        
        <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]"/>
        <xsl:variable name="textfilePath2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfileName2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="textfilePattern2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:pattern/text()" />
        
        <xsl:variable name="filecontentObj_ref2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]/ind-def:object/@object_ref" />
        <xsl:variable name="filecontentObj_flag2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$filecontentObj_ref2]/@flag"/>
        
        <xsl:variable name="filecontentitem_id2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id2]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="filecontentitem2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$filecontentitem_id2]"/>
        <xsl:variable name="actual_config2" select="$filecontentitem2/ind-sc:subexpression/text()"/>
        
        <xsl:variable name="file_info2">
            <xsl:value-of select="concat($textfilePath2,'/', $textfileName2)"/>
        </xsl:variable>
        
        
        <xsl:variable name="expected_config" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id1]/oval-res:tested_variable[@variable_id=$extVar_id]/text()"/>      
        
        
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <!-- Check if result is true ......................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>           
            
            <!-- Check if result is false .......................................-->
            <xsl:if test="$result='false' ">
                <xsl:choose>
                    <xsl:when test="$result1='false'">
                        <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>                
                    </xsl:when>
                    <xsl:when test="$filecontentObj_flag1='does not exist' and $filecontentObj_flag2='complete'">
                        <xsl:text>com.mcafee.pa.msg.config1DoesNotExists</xsl:text>                
                    </xsl:when>
                    <xsl:when test="$filecontentObj_flag2='does not exist' and $filecontentObj_flag1='complete'">
                        <xsl:text>com.mcafee.pa.msg.config2DoesNotExists</xsl:text>                
                    </xsl:when>
                    <xsl:when test="$filecontentObj_flag1='does not exist' and $filecontentObj_flag2='does not exist'">
                        <xsl:text>com.mcafee.pa.msg.config12DoesNotExists</xsl:text>                
                    </xsl:when>
                    <xsl:when test="$result1='true' and $result2='false' and $result3='true'">
                        <xsl:text>com.mcafee.pa.msg.State1ValuesStatusSCAP</xsl:text>                
                    </xsl:when>
                    <xsl:when test="$result1='true' and $result2='true' and $result3='false'">
                        <xsl:text>com.mcafee.pa.msg.State2ValuesStatusSCAP</xsl:text>                
                    </xsl:when>
                    <xsl:when test="$result1='true' and $result2='false' and $result3='false' ">
                        <xsl:text>com.mcafee.pa.msg.State12ValuesStatusSCAP</xsl:text>                
                    </xsl:when>
                </xsl:choose>
            </xsl:if>    
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">System Config1</xsl:attribute>
                    <xsl:value-of select="$actual_config1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern1</xsl:attribute>
                    <xsl:value-of select="$textfilePattern1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern2</xsl:attribute>
                    <xsl:value-of select="$textfilePattern2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expected_config</xsl:attribute>
                    <xsl:value-of select="$expected_config"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">System Config2</xsl:attribute>
                    <xsl:value-of select="$actual_config2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$file_info"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info1</xsl:attribute>
                    <xsl:value-of select="$file_info1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info2</xsl:attribute>
                    <xsl:value-of select="$file_info2"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

