<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
  xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">

  <!-- XSL for handling a single file test for file user and group ownership -->

  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <xsl:template name="filePlustfcDefinition">
    <xsl:param name="definition_id"/>
    <xsl:variable name="def"
      select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]"/>

    <xsl:variable name="result" select="$def/@result"/>
    <xsl:variable name="fileTestId" >
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$def//oval-res:criterion[1]/@test_ref]">
          <xsl:value-of select="$def//oval-res:criterion[1]/@test_ref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$def//oval-res:criterion[2]/@test_ref"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="fileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTestId]" />
    
    <xsl:variable name="tfc_id" >
      <xsl:choose>
        <xsl:when test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$def//oval-res:criterion[1]/@test_ref]">
          <xsl:value-of select="$def//oval-res:criterion[1]/@test_ref"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$def//oval-res:criterion[2]/@test_ref"/>
        </xsl:otherwise>
      </xsl:choose>    
    </xsl:variable>
    <xsl:variable name="tfcTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$tfc_id]" />
    
    <xsl:if test="$result='false'">
      <findings xmlns="http://results.pa.mcafee.com/findings/5.2" id="{$definition_id}">
        <xsl:call-template name="filePlustfcTest">
          <xsl:with-param name="fileTest" select="$fileTest"/>
          <xsl:with-param name="tfcTest" select="$tfcTest"/>
        </xsl:call-template>
      </findings>
    </xsl:if>
  </xsl:template>
  
  
  <xsl:template name="filePlustfcTest">
    <xsl:param name="fileTest"/>
    <xsl:param name="tfcTest"/>
    <xsl:variable name="fileObject"
      select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$fileTest/unix-def:object/@object_ref]"/>
    <xsl:variable name="textFileObject"
      select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$tfcTest/ind-def:object/@object_ref]"/>
    <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="key">filename</xsl:attribute>
      <xsl:call-template name="combinePaths">
        <xsl:with-param name="first" select="$fileObject/unix-def:path/text()"/>
        <xsl:with-param name="second" select="$fileObject/unix-def:filename/text()"/>
      </xsl:call-template>
    </xsl:element>
    <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="key">pattern</xsl:attribute>
      <xsl:value-of select="$textFileObject/ind-def:line/text()"/>
    </xsl:element>

    <xsl:choose>
      <xsl:when
        test="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileTest/@id]/@result='false'">
        <!-- File does not exist -->
        <!-- Message 'The file ##filename## does not exist.' -->
        <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
          <xsl:attribute name="messageId">com.mcafee.pa.msg.unixfile0</xsl:attribute>
          <xsl:attribute name="isViolation">true</xsl:attribute>
        </xsl:element>
      </xsl:when>
      <xsl:otherwise>
        <!-- Pattern does not exist in file -->
        <!-- Message 'The file ##filename## does not contain the pattern ##pattern##.' -->
        <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
          <xsl:attribute name="messageId">com.mcafee.pa.msg.unixFilePlusTFC0</xsl:attribute>
          <xsl:attribute name="isViolation">true</xsl:attribute>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:include href="unixUtils.xsl"/>
</xsl:stylesheet>

