<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to handle the OVAL checks with 1 file existence test and 3 text file tests.
        Text file test verifies if a specific patterns of text is present in the configuration file in test.
        
        Logic :-
        <criteria operator='AND'>
            <criterion comment='File existence pre-req' test_ref='oval:com.mcafee.oval:tst:249629' />
            <criterion comment='Test for space_left_action parameter in /etc/audit/auditd.conf file.' test_ref='oval:com.mcafee.oval:tst:403336' />
            <criterion comment='Test for action_mail_acct parameter in /etc/audit/auditd.conf file.' test_ref='oval:com.mcafee.oval:tst:403337' />
            <criterion comment='Test for admin_space_left_action parameter in /etc/audit/auditd.conf file.' test_ref='oval:com.mcafee.oval:tst:403338' />
        </criteria>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:403335
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="fileTestResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
        <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
        
        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
        <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
        
        <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id1]/@result"/>
        <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]"/>
        <xsl:variable name="textfilePath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfileName1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="textfilePattern1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:pattern/text()" />
        
        <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id2]/@result"/>
        <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]"/>
        <xsl:variable name="textfilePath2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfileName2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="textfilePattern2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:pattern/text()" />
        
        <xsl:variable name="fileContentTest_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[3]/@id"/>
        <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id3]/@result"/>
        <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id3]"/>
        <xsl:variable name="textfilePath3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:path/text()" />
        <xsl:variable name="textfileName3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:filename/text()" />
        <xsl:variable name="textfilePattern3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:pattern/text()" />
        
        <xsl:variable name="fileContentTestState_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/ind-def:state/@state_ref"/>
        <xsl:variable name="fileContentTestState_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/ind-def:state/@state_ref"/>
        <xsl:variable name="fileContentTestState_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[3]/ind-def:state/@state_ref"/>
        
        <xsl:variable name="stateID1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state[@id=$definitionTextFileTest1/ind-def:state/@state_ref]" />
        <xsl:variable name="extVar_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[@id=$stateID1/ind-def:subexpression/@var_ref]"/>
        
        <xsl:variable name="stateID2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state[@id=$definitionTextFileTest2/ind-def:state/@state_ref]" />
        <xsl:variable name="extVar_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[@id=$stateID2/ind-def:subexpression/@var_ref]"/>
        
        <xsl:variable name="stateID3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state[@id=$definitionTextFileTest3/ind-def:state/@state_ref]" />
        <xsl:variable name="extVar_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[@id=$stateID3/ind-def:subexpression/@var_ref]"/>
        
        <xsl:variable name="filecontentitem_id1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id1]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="filecontentitem1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$filecontentitem_id1]"/>
        <xsl:variable name="actualConfig1" select="$filecontentitem1/ind-sc:subexpression/text()"/>
        <xsl:variable name="expectedConfig1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id1]/oval-res:tested_variable[@variable_id=$extVar_id1/@id]/text()"/>
        
        <xsl:variable name="filecontentitem_id2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id2]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="filecontentitem2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$filecontentitem_id2]"/>
        <xsl:variable name="actualConfig2" select="$filecontentitem2/ind-sc:subexpression/text()"/>
        <xsl:variable name="expectedConfig2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id2]/oval-res:tested_variable[@variable_id=$extVar_id2/@id]/text()"/>
        
        <xsl:variable name="filecontentitem_id3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id3]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="filecontentitem3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item[@id=$filecontentitem_id3]"/>
        <xsl:variable name="actualConfig3" select="$filecontentitem3/ind-sc:subexpression/text()"/>
        <xsl:variable name="expectedConfig3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id3]/oval-res:tested_variable[@variable_id=$extVar_id3/@id]/text()"/>
        
        <xsl:variable name="expectedValueList1">
            <xsl:if test="$expectedConfig1='' or not($expectedConfig1)">
                <xsl:for-each select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[@id=$stateID1/ind-def:subexpression/@var_ref]/oval-def:possible_value">
                    <xsl:value-of select="concat(current(),'  ')"/>
                </xsl:for-each>
            </xsl:if>    
        </xsl:variable>
        
        <xsl:variable name="expectedValueList2">
            <xsl:if test="$expectedConfig2='' or not($expectedConfig2)">
                <xsl:for-each select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[@id=$stateID2/ind-def:subexpression/@var_ref]/oval-def:possible_value">
                    <xsl:value-of select="concat(current(),'  ')"/>
                </xsl:for-each>
            </xsl:if>    
        </xsl:variable>
        
        <xsl:variable name="expectedValueList3">
            <xsl:if test="$expectedConfig3='' or not($expectedConfig3)">
                <xsl:for-each select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[@id=$stateID3/ind-def:subexpression/@var_ref]/oval-def:possible_value">
                    <xsl:value-of select="concat(current(),'  ')"/>
                </xsl:for-each>
            </xsl:if>    
        </xsl:variable>
        
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        <xsl:variable name="fileInfo" select="concat($filePath,'/',$fileName)"/>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <!-- Check if result is true ......................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>           
            
            <!-- Check if result is false .......................................-->
            <xsl:if test="$result='false' ">
                <xsl:choose>
                    <xsl:when test="$fileTestResult='false'">
                        <xsl:choose>
                            <xsl:when test="$expectedValueList1!='' and $expectedValueList2!='' and $expectedValueList3!=''">
                                <xsl:text>com.mcafee.pa.msg.fileNotFoundNotConfigPat123ExpValues</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>com.mcafee.pa.msg.fileNotFoundNotConfigPat123</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='false'">
                        <xsl:choose>
                            <xsl:when test="($expectedConfig1!='' and $actualConfig1!='') and ($expectedConfig2!='' and $actualConfig2!='') and ($expectedConfig3!='' and $actualConfig3!='')">
                                <xsl:text>com.mcafee.pa.msg.PatMatExpAct123</xsl:text>
                            </xsl:when>
                            <xsl:when test="($expectedConfig1!='' and $actualConfig1!='') and ($expectedConfig2!='' and $actualConfig2!='') and ((($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3)))">
                                 <xsl:choose>
                                     <xsl:when test="$expectedValueList3!=''">
                                         <xsl:text>com.mcafee.pa.msg.PatMatExpAct12Pat3MissingExpVal</xsl:text>
                                     </xsl:when>
                                     <xsl:otherwise>
                                         <xsl:text>com.mcafee.pa.msg.PatMatExpAct12Pat3Missing</xsl:text>
                                     </xsl:otherwise>
                                 </xsl:choose>
                            </xsl:when>
                            <xsl:when test="($expectedConfig1!='' and $actualConfig1!='') and (($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2))) and ($expectedConfig3!='' and $actualConfig3!='')">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList2!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct13Pat2MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct13Pat2Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="($expectedConfig1!='' and $actualConfig1!='') and (($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2))) and ((($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList2!='' and $expectedValueList3!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct1Pat23MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct1Pat23Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))) and ($expectedConfig2!='' and $actualConfig2!='') and ($expectedConfig3!='' and $actualConfig3!='')">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct23Pat1MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct23Pat1Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))) and ($expectedConfig2!='' and $actualConfig2!='') and ((($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!='' and $expectedValueList3!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct2Pat13MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct2Pat13Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))) and (($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2))) and ($expectedConfig3!='' and $actualConfig3!='')">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!='' and $expectedValueList2!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct3Pat12MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct3Pat12Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))) and (($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2))) and ((($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!='' and $expectedValueList2!='' and $expectedValueList3!=''">
                                        <xsl:text>com.mcafee.pa.msg.All3PatMissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.All3PatMissing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                    
                    <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='false'">
                        <xsl:choose>
                            <xsl:when test="($expectedConfig2!='' and $actualConfig2!='') and ($expectedConfig3!='' and $actualConfig3!='')">
                                 <xsl:text>com.mcafee.pa.msg.PatMatExpAct23</xsl:text>
                            </xsl:when>
                            <xsl:when test="($expectedConfig2!='' and $actualConfig2!='') and ((($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList3!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct2Pat3MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct2Pat3Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2))) and ($expectedConfig3!='' and $actualConfig3!='')">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList2!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct3Pat2MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct3Pat2Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2))) and ((($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList2!='' and $expectedValueList3!=''">
                                        <xsl:text>com.mcafee.pa.msg.Patterns23MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.Patterns23Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                    
                    <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='true'">
                        <xsl:choose>
                            <xsl:when test="($expectedConfig1!='' and $actualConfig1!='') and ($expectedConfig2!='' and $actualConfig2!='')">
                                 <xsl:text>com.mcafee.pa.msg.PatMatExpAct12</xsl:text>
                            </xsl:when>
                            <xsl:when test="($expectedConfig1!='' and $actualConfig1!='') and (($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList2!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct1Pat2MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct1Pat2Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))) and ($expectedConfig2!='' and $actualConfig2!='')">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct2Pat1MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct2Pat1Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))) and (($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!='' and $expectedValueList2!=''">
                                        <xsl:text>com.mcafee.pa.msg.Patterns12MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.Patterns12Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                    
                    <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='false'">
                        <xsl:choose>
                            <xsl:when test="($expectedConfig1!='' and $actualConfig1!='') and ($expectedConfig3!='' and $actualConfig3!='')">
                                <xsl:text>com.mcafee.pa.msg.PatMatExpAct13</xsl:text>
                            </xsl:when>
                            <xsl:when test="($expectedConfig1!='' and $actualConfig1!='') and ((($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList3!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct1Pat3MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct1Pat3Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))) and ($expectedConfig3!='' and $actualConfig3!='')">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!=''">
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct3Pat1MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.PatMatExpAct3Pat1Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))) and ((($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3)))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!='' and $expectedValueList3">
                                        <xsl:text>com.mcafee.pa.msg.Patterns13MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.Patterns13Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                    
                    <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='true' and $result3='false'">
                        <xsl:choose>
                            <xsl:when test="$expectedConfig3!='' and $actualConfig3!=''">
                                <xsl:text>com.mcafee.pa.msg.PatMatExpAct3</xsl:text>
                            </xsl:when>
                            <xsl:when test="(($expectedConfig3='' or not($expectedConfig3)) or not($expectedConfig3)) and ($actualConfig3='' or not($actualConfig3))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList3!=''">
                                        <xsl:text>com.mcafee.pa.msg.Pat3MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.Pat3Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                    
                    <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='true'">
                        <xsl:choose>
                            <xsl:when test="$expectedConfig2!='' and $actualConfig2!=''">
                                <xsl:text>com.mcafee.pa.msg.PatMatExpAct2</xsl:text>
                            </xsl:when>
                            <xsl:when test="($expectedConfig2='' or not($expectedConfig2)) and ($actualConfig2='' or not($actualConfig2))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList2!=''">
                                        <xsl:text>com.mcafee.pa.msg.Pat2MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.Pat2Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                    
                    <xsl:when test="$fileTestResult='false' and $result1='true' and $result2='false' and $result3='true'">
                        <xsl:choose>
                            <xsl:when test="$expectedConfig1!='' and $actualConfig1!=''">
                                <xsl:text>com.mcafee.pa.msg.PatMatExpAct1</xsl:text>
                            </xsl:when>
                            <xsl:when test="($expectedConfig1='' or not($expectedConfig1)) and ($actualConfig1='' or not($actualConfig1))">
                                <xsl:choose>
                                    <xsl:when test="$expectedValueList1!=''">
                                        <xsl:text>com.mcafee.pa.msg.Pat1MissingExpVal</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:text>com.mcafee.pa.msg.Pat1Missing</xsl:text>
                                    </xsl:otherwise>
                                </xsl:choose>
                                
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>    
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedValue1</xsl:attribute>
                    <xsl:value-of select="$expectedConfig1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actualValue1</xsl:attribute>
                    <xsl:value-of select="$actualConfig1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedValue2</xsl:attribute>
                    <xsl:value-of select="$expectedConfig2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actualValue2</xsl:attribute>
                    <xsl:value-of select="$actualConfig2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedValue3</xsl:attribute>
                    <xsl:value-of select="$expectedConfig3"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actualValue3</xsl:attribute>
                    <xsl:value-of select="$actualConfig3"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedValueList1</xsl:attribute>
                    <xsl:value-of select="$expectedValueList1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedValueList2</xsl:attribute>
                    <xsl:value-of select="$expectedValueList2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedValueList3</xsl:attribute>
                    <xsl:value-of select="$expectedValueList3"/>
                </xsl:element>
                
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern1</xsl:attribute>
                    <xsl:value-of select="$textfilePattern1"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern2</xsl:attribute>
                    <xsl:value-of select="$textfilePattern2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">textfilePattern3</xsl:attribute>
                    <xsl:value-of select="$textfilePattern3"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>