<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <!-- 
       ===========================================================================
            This library has following test cases:
           1. INPUT=enable, SYSTEM Setting=enable, Final result=TRUE 
           2. INPUT=disable, SYSTEM Setting=disable, Final result=TRUE 
           3. INPUT=enable, SYSTEM Setting=disable, Final result=FALSE
           4. INPUT=disable, SYSTEM Setting=enable, Final result=FALSE
     ===========================================================================
     
     This library works fine for the below check logic:
     
     
     <criteria operator='OR' comment='Test the enable / disable status of IPv6'>
         <criteria comment="Check if IPv6 configuration is enabled as per the user input" operator="AND">
         <criterion comment='Test the user input is enable' test_ref='oval:com.mcafee.oval:tst:405140' />
         <criterion comment='Check if options ipv6 disable=1 in /etc/modprobe.d/ipv6.conf file' test_ref='oval:com.mcafee.oval:tst:405141' negate="true"/>
         <criterion comment='Check for install ipv6 /bin/true in any of the files under /etc/modprobe.d' test_ref='oval:com.mcafee.oval:tst:405142' negate="true"/>
         <criterion comment='Check for blacklist ipv6 in any of the files under /etc/modprobe.d' test_ref='oval:com.mcafee.oval:tst:405143' negate="true"/>
         <criterion comment='Check if net.ipv6.conf.all.disable_ipv6=1 in /etc/sysctl.conf file' test_ref='oval:com.mcafee.oval:tst:405144' negate="true"/>
         <criterion comment='Check if net.ipv6.conf.default.disable_ipv6=1 in /etc/sysctl.conf file' test_ref='oval:com.mcafee.oval:tst:405145' negate="true"/>
     </criteria>
         <criteria comment="Check if IPv6 configuration is disabled as per the user input" operator="AND">
         <criterion comment='Test the user input is enable' test_ref='oval:com.mcafee.oval:tst:405146' />
         <criterion comment='Check if net.ipv6.conf.all.disable_ipv6=1 in /etc/sysctl.conf file' test_ref='oval:com.mcafee.oval:tst:405144' />
         <criterion comment='Check if net.ipv6.conf.default.disable_ipv6=1 in /etc/sysctl.conf file' test_ref='oval:com.mcafee.oval:tst:405145' />
         <criterion comment='Check if options ipv6 disable=1 in /etc/modprobe.d/ipv6.conf file' test_ref='oval:com.mcafee.oval:tst:405141' />
         <criterion comment='Default setting for IPv6 Configuration should be enabled or disabled for network interfaces as appropriate' test_ref='oval:com.mcafee.oval:tst:200803030068' />
         <criterion comment='Global IPv6 initialization should be enabled or disabled as appropriate' test_ref='oval:com.mcafee.oval:tst:200803030093' />
         </criteria>
     </criteria>
     
     Example def if : oval:com.mcafee.oval:def:405139
    -->
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid" />
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect service name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all results for the criterias in the variables ......................................... --> 
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>
        
        <xsl:variable name="result7" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[7]/@result"/>
        <xsl:variable name="result8" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[8]/@result"/>
        <xsl:variable name="result9" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[9]/@result"/>
        <xsl:variable name="result10" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[10]/@result"/>
        <xsl:variable name="result11" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[11]/@result"/>
        <xsl:variable name="result12" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[12]/@result"/>
        
        <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]"/>
        <xsl:variable name="textfile53Path1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]"/>
        <xsl:variable name="textfile53Path2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[3]/@id"/>
        <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id3]"/>
        <xsl:variable name="textfile53Path3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[4]/@id"/>
        <xsl:variable name="definitionTextFileTest4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id4]"/>
        <xsl:variable name="textfile53Path4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        <xsl:variable name="fileContentTest_id5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[5]/@id"/>
        <xsl:variable name="definitionTextFileTest5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id5]"/>
        <xsl:variable name="textfile53Path5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:pattern/text()"/>
        
        
        <xsl:variable name="fileContentTest_id9" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[1]/@id"/>
        <xsl:variable name="definitionTextFileTest9" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id9]"/>
        <xsl:variable name="textfile53Path9" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest9/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name9" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest9/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat9" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest9/ind-def:object/@object_ref]/ind-def:line/text()"/>
        
        <xsl:variable name="fileContentTest_id10" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[2]/@id"/>
        <xsl:variable name="definitionTextFileTest10" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent_test[@id=$fileContentTest_id10]"/>
        <xsl:variable name="textfile53Path10" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest10/ind-def:object/@object_ref]/ind-def:path/text()"/>
        <xsl:variable name="textfile53Name10" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest10/ind-def:object/@object_ref]/ind-def:filename/text()"/>
        <xsl:variable name="textfilePat10" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent_object[@id=$definitionTextFileTest10/ind-def:object/@object_ref]/ind-def:line/text()"/>
        
        <xsl:variable name="fileInfo">
            <xsl:value-of select="concat($textfile53Path1,'/', $textfile53Name1,', ',$textfile53Path2,'/', $textfile53Name2,', ',$textfile53Path3,'/',$textfile53Name3,', ',$textfile53Path4,'/',$textfile53Name4,', ',$textfile53Path5,'/', $textfile53Name5,', ',$textfile53Path9,'/', $textfile53Name9,' &amp; ',$textfile53Path10,'/',$textfile53Name10,' ')"/>
        </xsl:variable>
        
        <xsl:variable name="textfilePat">
            <xsl:value-of select="concat($textfilePat1,', ',$textfilePat2,', ',$textfilePat3,', ',$textfilePat4,', ',$textfilePat5,', ',$textfilePat9,' &amp; ',$textfilePat10,' ')"/>
        </xsl:variable>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$result1 = 'true' and ($result8 = 'true' or $result9 = 'true' or $result10 = 'true' or $result11 = 'true' or $result12 = 'true')">
                        <xsl:text>com.mcafee.pa.msg.configDisabledSCAP</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result7 = 'true' and ($result2 = 'true' or $result3 = 'true' or $result4 = 'true' or $result5 = 'true' or $result6 = 'true')">
                        <xsl:text>com.mcafee.pa.msg.configEnabledSCAP</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
                
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>        
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>                
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_pattern</xsl:attribute>
                    <xsl:value-of select="$textfilePat"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>