<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
<!-- compliance finding library for 1 textfilecontent simple AND logic  -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getSoftwareNameFromTitle">
        <xsl:param name="title"/>
        
        <xsl:variable name="software">
            <xsl:if test="contains($title, 'Maximum' )">
                <xsl:value-of select="substring-before($title, 'for Mac Maximum' )"/>
            </xsl:if>
            <xsl:if test="contains($title, 'Minimum' )">
                <xsl:value-of select="substring-before($title, 'for Mac Minimum' )"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$software != '' ">
                <xsl:value-of select="$software"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
     
         <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test/@id"/>
         <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        <xsl:variable name="filecontentObj_ref" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id]/ind-def:object/@object_ref" />
         <xsl:variable name="filecontentObj_flag" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$filecontentObj_ref]/@flag"/>
        <xsl:variable name="filecontentitem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent54_item"/>
        <xsl:variable name="filecontentitem_1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item"/>
        <xsl:variable name="actualVersion" select="$filecontentitem_1/ind-sc:subexpression/text()"/>
        <xsl:variable name="extVar_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state/ind-def:subexpression/@var_ref"/>
        <xsl:variable name="inputVersion" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileContentTest_id]/oval-res:tested_variable[@variable_id=$extVar_id]/text()"/>       
        
        
        <xsl:variable name="software">
            <xsl:call-template name="getSoftwareNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
               
      
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result='false'  and $filecontentObj_flag='does not exist' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>   
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:choose>
                <xsl:when test="$result='false'  and $filecontentObj_flag='does not exist' ">
                <xsl:text>com.mcafee.pa.msg.macsoftwaredoesnotexistmessage</xsl:text>
                </xsl:when>   
                <xsl:when test="$result='true' ">
                    <xsl:text>com.mcafee.pa.msg.macsoftwareminimumversionmessage</xsl:text>
                </xsl:when>
                <xsl:when test="$result='false' ">
                <xsl:text>com.mcafee.pa.msg.macsoftwareminimumversionmessage</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
          
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                 <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">software</xsl:attribute>
                    <xsl:value-of select="$software"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actualVersion</xsl:attribute>
                    <xsl:value-of select="$actualVersion"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">inputVersion</xsl:attribute>
                    <xsl:value-of select="$inputVersion"/>
                </xsl:element>
               </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

