﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!--  FILENAME: winSecurityUpdate_AdobeFlashPlayer11_7_Version_PatchCheck_MNAC.xsl         DATE: 08th Jan, 2014     AUTHOR: Deepak Asawa   -->
    <!--  MAPPINGFILE: winSecurityUpdate_AdobeFlashPlayer11_7_Version_PatchCheck_MNAC_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR Adobe Flash Player checks 11.7.700.232 onwards where version 10.3 was replaced with 11.7 series  -->

    <!-- FOLLOWING ARE SOME OF THE ASSUMPTIONS TAKEN IN THE LOGIC FOR THE LIBRARY  -->
   <!--   1. Software name and patch number are extracted from the title of the check.
            2. Following are the test cases which are taken into consideration for the logic:-
            3. Final result is nagated since it is patch check
    ______________________________________________________________________________________________________________________________________________________________________
       Test Case  Final Result        Patch Status                     Is Violation        Message ID
    ______________________________________________________________________________________________________________________________________________________________________
    
      Result1       false     	              Patch installed                  FALSE               com.mcafee.pa.msg.winSoftwareVersionCheck_crd_MNAC
      Result2       false     	              Patch not applicable        FALSE               com.mcafee.pa.msg.winSoftwareVersionCheck_crd_NA_MNAC
      Result3       true	              Patch not installed            TRUE                com.mcafee.pa.msg.winSoftwareVersionCheck_crd_MNAC
       ______________________________________________________________________________________________________________________________________________________________________    
   -->

    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="definitionIdWithoutCommon">
            <xsl:choose>   
                <xsl:when test="contains($definitionId, '.common' )">
                    <xsl:value-of select="concat(substring-before($definitionId, '.common'), substring-after($definitionId, '.common'))"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$definitionId"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <!-- Final result -->
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        
        <!-- Extract application name and patch number from the check title -->
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionIdWithoutCommon ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        <xsl:variable name="software">
            <xsl:if test="contains($title, 'Security Update')">
                <xsl:value-of select="substring-before($title, 'Security Update' )"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="patchNumber">
            <xsl:if test="contains($title, 'for')">
                <xsl:value-of select="substring-before(substring-after($title, 'Security Update' ), ' for' )"/>
            </xsl:if>
        </xsl:variable>
        
     
        <xsl:variable name="resultCriteria3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/descendant::oval-res:criteria[3]/@result"/>
        <xsl:variable name="resultCriteria5"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/descendant::oval-res:criteria[5]/@result"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if final result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:text>com.mcafee.pa.msg.winSoftwareVersionCheck_crd_MNAC</xsl:text>
                </xsl:if>
                
                <!-- Check if final result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                    <xsl:choose>
                        <xsl:when test="($resultCriteria3 = 'false'  and $resultCriteria5 = 'false')">
                            <xsl:text>com.mcafee.pa.msg.winSoftwareVersionCheck_crd_NA_MNAC</xsl:text>
                        </xsl:when>
                        <xsl:when test="($resultCriteria3 = 'true'  or $resultCriteria5 = 'true')">
                            <xsl:text>com.mcafee.pa.msg.winSoftwareVersionCheck_crd_MNAC</xsl:text>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
            </xsl:variable>
            
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionIdWithoutCommon}" xmlns="http://results.pa.mcafee.com/findings/5.2">
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="software">
                    <xsl:value-of select="$software"/>                                                    
                </instanceValue>
                <instanceValue key="inputVersion">
                    <xsl:value-of select="$patchNumber"/>                                                    
                </instanceValue>
            </finding>
        </findings>
    </xsl:template>
</xsl:stylesheet>
