<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan">

    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl" scope="stylesheet">
        <xd:desc>
            <xd:p><xd:b>Created on:</xd:b> Mar 4, 2010</xd:p>
            <xd:p><xd:b>Author:</xd:b>dwhitehurst</xd:p>
            <xd:p/>
        </xd:desc>
    </xd:doc>

    <xsl:template name="getFindingsNoOtherAccess">
        <xsl:param name="definitionId"/>

        <xsl:variable name="OvalResultDefinitions"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
        <xsl:variable name="defResult"
            select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        <xsl:variable name="lookForOtherAccess" select="'false'"/>

        <xsl:if test="$defResult='false'">
            <xsl:call-template name="mfe-filePermissions">
                <xsl:with-param name="definitionId" select="$definitionId"/>
                <xsl:with-param name="lookForOtherAccess" select="$lookForOtherAccess"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="getFindingsWithOtherAccess">
        <xsl:param name="definitionId"/>
        <xsl:variable name="OvalResultDefinitions"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
        <xsl:variable name="defResult"
            select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        <xsl:variable name="lookForOtherAccess" select="'true'"/>

        <xsl:if test="$defResult='false'">
            <xsl:call-template name="mfe-filePermissions">
                <xsl:with-param name="definitionId" select="$definitionId"/>
                <xsl:with-param name="lookForOtherAccess" select="$lookForOtherAccess"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="mfe-filePermissions">
        <xsl:param name="definitionId"/>
        <xsl:param name="lookForOtherAccess"/>

        <findings xmlns="http://results.pa.mcafee.com/findings/5.2" id="{$definitionId}">
            <xsl:variable name="OvalResultTests"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            <xsl:variable name="OvalResultItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
            <xsl:variable name="OvalResultDefinitions"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="OvalResultTests1"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            <xsl:variable name="test1Id"
                select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()=1]/@test_ref"/>
            <xsl:variable name="test2Id"
                select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()=2]/@test_ref"/>
            <xsl:variable name="object1Id"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/win-def:fileeffectiverights53_test[@id=$test1Id]/win-def:object/@object_ref"/>
            <xsl:variable name="object2Id"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/win-def:fileeffectiverights53_test[@id=$test2Id]/win-def:object/@object_ref"/>
            <xsl:variable name="collectedObject2"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$object2Id]"/>

            <xsl:variable name="itemId" select="$collectedObject2/oval-sc:reference/@item_ref"/>
            <xsl:variable name="ferItem" select="$OvalResultItems/*[@id=$itemId]"/>
            <xsl:variable name="filePath" select="$ferItem/win-sc:path"/>
            <xsl:variable name="fileName" select="$ferItem/win-sc:filename"/>
            <xsl:variable name="filePathname">
                <xsl:value-of select="$filePath"/>
                <xsl:if test="substring($filePath,string-length($filePath)) != '\'">
                    <xsl:text>\</xsl:text>
                </xsl:if>
                <xsl:value-of select="$fileName"/>
            </xsl:variable>
            <xsl:variable name="critIndex">
                <xsl:choose>
                    <xsl:when test="string($lookForOtherAccess) = 'false' ">
                        <xsl:text>0</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>1</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:variable name="testId"
                select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()=($critIndex + 1) and @result = 'false']/@test_ref"/>

            <xsl:variable name="testId2"
                select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()=($critIndex ) and @result = 'false']/@test_ref"/>

            <!-- Check for file doesn't exist (criterion 2 fails and no tested item)  -->
            <xsl:variable name="test" select="$OvalResultTests/oval-res:test[@test_id=$testId]"/>
            <xsl:variable name="testedItemId" select="$test/oval-res:tested_item/@item_id"/>
            <xsl:variable name="noTestedItem"
                select="string($testedItemId) = '' and string($testId) !=''"/>
            <xsl:variable name="testedItem" select="$OvalResultItems/*[@id=$testedItemId]"/>
            <xsl:variable name="itemStatus" select="$testedItem/@status"/>

            <xsl:choose>
                <xsl:when test="$noTestedItem or $itemStatus='does not exist'">
                    <xsl:variable name="msgid">com.mcafee.pa.msg.filedoesnotexist</xsl:variable>
                    <finding messageId="{$msgid}" isViolation="true"
                        xmlns="http://results.pa.mcafee.com/findings/5.2">
                        <instanceValue key="filename">
                            <xsl:value-of select="$filePathname"/>
                        </instanceValue>
                    </finding>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="string($lookForOtherAccess) = 'true' ">
                        <!-- check for accounts that have rights and shouldn't -->
                           <xsl:call-template name="mfe-shouldhavenorights">
                            <xsl:with-param name="testId" select="$testId2"/>
                            <xsl:with-param name="filename" select="$filePathname"/>
                        </xsl:call-template>
                    </xsl:if>

                    <!-- check for accounts that don't have expected rights -->
                    <xsl:variable name="criterions"
                        select="$OvalResultDefinitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[position()>$critIndex and @result = 'false']"/>
                    <xsl:call-template name="mfe-notExpectedRights">
                        <xsl:with-param name="criterions" select="$criterions"/>
                        <xsl:with-param name="filename" select="$filePathname"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </findings>
    </xsl:template>

    <xsl:template name="mfe-notExpectedRights">
        <xsl:param name="criterions"/>
        <xsl:param name="filename"/>
        <xsl:variable name="OvalResultTests"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        <xsl:variable name="OvalResultItems"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
        <xsl:for-each select="$criterions">
            <xsl:variable name="testId" select="./@test_ref"/>
            <xsl:variable name="stateId"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/*[@id=$testId]/win-def:state/@state_ref"/>
            <xsl:variable name="expectedState"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/*[@id=$stateId]"/>
            <xsl:variable name="expectedPerms">
                <xsl:call-template name="mfe-getPermissionString">
                    <xsl:with-param name="ferItem" select="$expectedState"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="test" select="$OvalResultTests/oval-res:test[@test_id=$testId]"/>
            <xsl:variable name="testedItemId" select="$test/oval-res:tested_item/@item_id"/>
            <xsl:variable name="item"
                select="$OvalResultItems/win-sc:fileeffectiverights_item[@id=$testedItemId]"/>
            <xsl:variable name="p1">
                <xsl:call-template name="mfe-getPermissionString">
                    <xsl:with-param name="ferItem" select="$item"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:variable name="account" select="$item/win-sc:trustee_name"/>

            <finding messageId="com.mcafee.pa.msg.winfilerightsviolation" isViolation="true"
                xmlns="http://results.pa.mcafee.com/findings/5.2">
                <instanceValue key="account">
                    <xsl:value-of select="$account"/>
                </instanceValue>
                <instanceValue key="filename">
                    <xsl:value-of select="$filename"/>
                </instanceValue>
                <instanceValue key="permissions">
                    <xsl:value-of select="$expectedPerms"/>
                </instanceValue>
                <actualValue key="permissions">
                    <xsl:value-of select="$p1"/>
                </actualValue>
            </finding>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="mfe-shouldHaveFullRights"> </xsl:template>
    <xsl:template name="mfe-shouldhavenorights">
        <xsl:param name="testId"/>
        <xsl:param name="filename"/>
        <xsl:variable name="OvalResultTests"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        <xsl:variable name="OvalResultItems"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
        <xsl:variable name="test" select="$OvalResultTests/oval-res:test[@test_id=$testId]"/>
        <xsl:for-each select="$test/oval-res:tested_item[@result='false']">
            <xsl:variable name="itemId" select="@item_id"/>
            <xsl:variable name="item" select="$OvalResultItems/*[@id=$itemId]"/>
            <xsl:variable name="permissionString">
                <xsl:call-template name="mfe-getPermissionString">
                    <xsl:with-param name="ferItem" select="$item"/>
                </xsl:call-template>
            </xsl:variable>

            <xsl:variable name="trusteeName" select="$item/win-sc:trustee_name"/>
            <xsl:variable name="sid" select="$item/win-sc:trustee_sid"/>
            <xsl:variable name="account">
                <xsl:choose>
                    <xsl:when test="$trusteeName = ''">
                        <xsl:value-of select="$item/win-sc:trustee_sid"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$item/win-sc:trustee_name"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <finding messageId="com.mcafee.pa.msg.winfilenonerightsviolation" isViolation="true"
                xmlns="http://results.pa.mcafee.com/findings/5.2">
                <instanceValue key="account">
                    <xsl:value-of select="$account"/>
                </instanceValue>
                <instanceValue key="filename">
                    <xsl:value-of select="$filename"/>
                </instanceValue>
                <actualValue key="permissions">
                    <xsl:value-of select="$permissionString"/>
                </actualValue>
            </finding>

        </xsl:for-each>

    </xsl:template>
    <xsl:template name="mfe-getPermissionString">
        <xsl:param name="ferItem"/>
        <xsl:variable name="p">
            <xsl:call-template name="mfe-getPermissionString2">
                <xsl:with-param name="ferItem" select="$ferItem"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$p"/>
        <xsl:choose>
            <xsl:when test="$p=''">no permissions</xsl:when>
            <xsl:when test="'XRQNE' = $p">(Read&amp;Execute / List Folder Contents)</xsl:when>
            <xsl:when test="'RQNE' = $p">(Read)</xsl:when>
            <xsl:when test="'XRQNWATBUDEPO' = $p">(Full Control)</xsl:when>
            <xsl:when test="'XRQNWATBDE' = $p">(Modify)</xsl:when>
            <xsl:when test="'WATBE' = $p">(Write)</xsl:when>
        </xsl:choose>

    </xsl:template>
    <xsl:template name="mfe-getPermissionString2">
        <xsl:param name="ferItem"/>
        <xsl:text/>
        <xsl:variable name="testVal" select="$ferItem/*[local-name()='file_execute']"/>
        <xsl:if test="1 = $ferItem/*[local-name()='file_execute']">
            <xsl:value-of select="'X'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='file_read_data']">
            <xsl:value-of select="'R'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='file_read_attributes']">
            <xsl:value-of select="'Q'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='file_read_ea']">
            <xsl:value-of select="'N'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='file_write_data']">
            <xsl:value-of select="'W'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='file_append_data']">
            <xsl:value-of select="'A'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='file_write_attributes']">
            <xsl:value-of select="'T'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='file_write_ea']">
            <xsl:value-of select="'B'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='file_delete_child']">
            <xsl:value-of select="'U'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='standard_delete']">
            <xsl:value-of select="'D'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='standard_read_control']">
            <xsl:value-of select="'E'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='standard_write_dac']">
            <xsl:value-of select="'P'"/>
        </xsl:if>
        <xsl:if test="1 = $ferItem/*[local-name()='standard_write_owner']">
            <xsl:value-of select="'O'"/>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
