<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
xmlns:xalan="http://xml.apache.org/xalan">

<!--
	 This template expects the definition to have 
	criteria (AND)
	criteria (OR)
		criterion1 -  regkey does not exist ( service startup exist)  
		criterion2 -  reg key value  ( service startup varification against user input )
	Criterion windows platform  
	
	This will extract the service name from the Title so it should have service name followed by Service in the title
	else this will take the whole title is a service name.
	
	Nothing is output if any of the three criterion do not exist in the hierarchy as described above.
-->

<xsl:variable name="Definitions"
	select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
<xsl:variable name="Tests"
	select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
<xsl:variable name="TestedItems"
	select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
<xsl:variable name="CollectedObjects"
	select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
<xsl:variable name="SystemData"
	select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
<xsl:variable name="States"
	select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
<xsl:variable name="Objects"
	select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
<xsl:variable name="Variables"
	select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
<xsl:variable name="OvalResult"
	select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>


<xsl:template name="getServiceStartup">
	<xsl:param name="startValue"/>
	<xsl:choose>
		<xsl:when test="$startValue=2">Automatic(2)</xsl:when>
		<xsl:when test="$startValue=3">Manual(3)</xsl:when>
		<xsl:when test="$startValue=4">Disabled(4)</xsl:when>
		<xsl:otherwise>Unknown</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="getServiceName">
	<xsl:param name="title"/>
	<xsl:variable name="tmpTitle">
		<xsl:choose>
			<xsl:when test="starts-with($title , 'Service: ' ) ">
				<xsl:value-of select="substring-after($title,'Service: ' )"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$title"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	<xsl:variable name="service1">
		<xsl:choose>
			<xsl:when test="contains($tmpTitle , 'Service' ) ">
				<xsl:value-of select="substring-before($tmpTitle,'Service' )"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$tmpTitle"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:variable>

	<xsl:value-of select="normalize-space($service1)"/><xsl:text> Service</xsl:text>
</xsl:template>

<xsl:template name="getFindings">
	<xsl:param name="definitionId"/>

	<xsl:variable name="result"
		select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

	
		<xsl:call-template name="winServiceCheck">
			<xsl:with-param name="definitionId" select="$definitionId"/>
			<xsl:with-param name="def_result" select="$result"/>
		</xsl:call-template>
	

</xsl:template>

<xsl:template name="winServiceCheck">
	<xsl:param name="definitionId"/>
	<xsl:param name="def_result"/>

<xsl:variable name="tests">
	<xsl:for-each
		select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

			<xsl:variable name="test" select="@test_ref"/>
			<xsl:variable name="result" select="@result"/>

			<xsl:if test="$Tests/win-def:registry_test[@id=$test]">
				<xsl:variable name="object"
					select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>
				<xsl:variable name="state"
					select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>
				<xsl:variable name="key"
					select="$Objects/win-def:registry_object[@id=$object]/win-def:key"/>
				<xsl:variable name="name"
					select="$Objects/win-def:registry_object[@id=$object]/win-def:name"/>

				<xsl:variable name="externalVar"
				select="$States/win-def:registry_state[@id=$state]/win-def:value/@var_ref"/>
				
				<xsl:variable name="stateValue"
					select="$States/win-def:registry_state[@id=$state]/win-def:value"/>

				<xsl:element name="test">
					<xsl:attribute name="id">
						<xsl:value-of select="$test"/>
					</xsl:attribute>
					<xsl:attribute name="state">
						<xsl:value-of select="$state"/>
					</xsl:attribute>
					<xsl:attribute name="name">
						<xsl:value-of select="$name"/>
					</xsl:attribute>
					<xsl:attribute name="result">
						<xsl:value-of select="$result"/>
					</xsl:attribute>
					<xsl:attribute name="key">
						<xsl:value-of select="$key"/>
					</xsl:attribute>
					<xsl:attribute name="externalVar">
						<xsl:value-of select="$externalVar"/>
					</xsl:attribute>
					<xsl:attribute name="stateValue">
						<xsl:value-of select="$stateValue"/>
					</xsl:attribute>
				
				<xsl:choose>
					<xsl:when  test="normalize-space($state) = '' ">
						<xsl:attribute name="testtype">
							<xsl:text>startupexistcheck</xsl:text>
						</xsl:attribute>
					</xsl:when>
					<xsl:when test="$States/win-def:registry_state[@id=$state]/win-def:value">
						<xsl:attribute name="testtype">
							<xsl:text>primarytest</xsl:text>
						</xsl:attribute>
					</xsl:when>					
					<xsl:when test="$States/win-def:registry_state[@id=$state]/win-def:type and not($States/win-def:registry_state[@id=$state]/win-def:value)">
						<xsl:attribute name="testtype">
							<xsl:text>typecheckingtest</xsl:text>
						</xsl:attribute>
						<xsl:attribute name="typeName">
							<xsl:value-of select="$States/win-def:registry_state[@id=$state]/win-def:type"/>
						</xsl:attribute>
					</xsl:when>
				</xsl:choose>
				</xsl:element>
			</xsl:if>
			<xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
				<xsl:element name="test">
					<xsl:attribute name="id">
						<xsl:value-of select="$test"/>
					</xsl:attribute>
					<xsl:attribute name="testtype">
						<xsl:text>family</xsl:text>
					</xsl:attribute>
				</xsl:element>
			</xsl:if>
		</xsl:for-each>

	</xsl:variable>


	<xsl:variable name="pre_test">
		<xsl:value-of select="xalan:nodeset($tests)/test[@testtype='family']/@id"/>
	</xsl:variable>

	<xsl:variable name="pre_test_result">
		<xsl:choose>				
			<xsl:when test="$TestedItems/oval-res:test[@test_id=$pre_test ]">
				<xsl:value-of select="$TestedItems/oval-res:test[@test_id=$pre_test ]/@result"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="true()"/>
			</xsl:otherwise>
		</xsl:choose>

	</xsl:variable>

	<xsl:variable name="serviceName">
		<xsl:call-template name="getServiceName">
			<xsl:with-param name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
		</xsl:call-template>
	</xsl:variable>

	

		<xsl:if test=" $pre_test_result = 'true'  and $def_result = 'false' ">
			<findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
			<xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype ='typecheckingtest' ]">
				<xsl:variable name="test" select="@id"/>
				<xsl:variable name="key" select="@key"/>
				<xsl:variable name="name" select="@name"/>
				<xsl:variable name="typeName" select="@typeName"/>

				<xsl:for-each
					select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false' ] ">

					<xsl:variable name="itemRef" select="@item_id"/>
					<xsl:variable name="result" select="@result"/>

					<xsl:variable name="actualParameterType"
						select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:type"/>

					<xsl:if test="$actualParameterType != '' ">
						<finding messageId="com.mcafee.pa.msg.winserviceregistrystartuptypeisinvalid"  isViolation="true">
							<instanceValue key="service">
								<xsl:value-of select="$serviceName"/>
							</instanceValue>
							<instanceValue key="registry">
								<xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>
							</instanceValue>
							<instanceValue key="expectedType">
								<xsl:value-of select="$typeName"/>
							</instanceValue>
							<actualValue key="actualType">
								<xsl:value-of select="$actualParameterType"/>
							</actualValue>
						</finding>
					</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
			<xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype ='primarytest' ]">
				<xsl:variable name="test" select="@id"/>
				<xsl:variable name="state" select="@state"/>
				<xsl:variable name="key" select="@key"/>
				<xsl:variable name="name" select="@name"/>
				<xsl:variable name="externalVarId" select="@externalVar"/>
				<xsl:variable name="stateValue" select="@stateValue"/>
				
					<xsl:variable name="expectedStartValue">
					<xsl:choose>
						<xsl:when test="$externalVarId != '' ">
							<xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$stateValue"/>
						</xsl:otherwise>
					</xsl:choose>
					</xsl:variable>
				
					<xsl:variable name="expectedStartupString">
						<xsl:call-template name="getServiceStartup">
							<xsl:with-param name="startValue" select="$expectedStartValue"/>
						</xsl:call-template>
					</xsl:variable>

					<xsl:for-each
						select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">

						<xsl:variable name="itemRef" select="@item_id"/>
						<xsl:variable name="result" select="@result"/>

						<xsl:variable name="actualStartupValue"
							select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
						<xsl:variable name="actualServiceStatus"
							select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>

						<xsl:variable name="actualStartupString">
							<xsl:call-template name="getServiceStartup">
								<xsl:with-param name="startValue" select="$actualStartupValue"/>
							</xsl:call-template>
						</xsl:variable>

						<xsl:variable name="message_id">
							<xsl:choose>
								<xsl:when test="$actualServiceStatus = 'does not exist' ">
									<xsl:text>com.mcafee.pa.msg.winservicenotexist</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>com.mcafee.pa.msg.winservicestartupmessage</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>

						<finding messageId="{$message_id}" isViolation="true">
							<instanceValue key="service">
							     <xsl:value-of select="$serviceName"/>
							</instanceValue>
							<instanceValue key="expectedStartup">
							        <xsl:value-of select="$expectedStartupString"/>
							</instanceValue>
							<actualValue key="actualStartup">
							          <xsl:value-of select="$actualStartupString"/>
							</actualValue>
						</finding>
					</xsl:for-each>
				
				
			</xsl:for-each>
		               <!--<xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype ='startupexistcheck'  ]">	
		               	<xsl:variable name="test" select="@id"/>
		               	<xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">              		
		               		<xsl:variable name="itemRef" select="@item_id"/>
		               		
		               		<xsl:variable name="actualServiceStatus"
		               			select="$SystemData/win-sc:registry_item[@id=$itemRef]/@status"/>
					<xsl:if test="$actualServiceStatus = 'does not exist' ">               		
				                	<finding messageId="com.mcafee.pa.msg.winservicestartupnotexist" isViolation="true">
							<instanceValue key="service">
								<xsl:value-of select="$serviceName"/>
							</instanceValue>
				                	</finding>
					</xsl:if>
		               	</xsl:for-each>
		             </xsl:for-each>
			-->
			</findings>
		</xsl:if>
		
		<xsl:if test=" $def_result = 'true' ">
			<findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
				
			<xsl:for-each  select="xalan:nodeset($tests)/descendant::test[ @testtype ='primarytest' ]">
				<xsl:variable name="test" select="@id"/>
				<xsl:variable name="state" select="@state"/>
				<xsl:variable name="key" select="@key"/>
				<xsl:variable name="name" select="@name"/>
				<xsl:variable name="externalVarId" select="@externalVar"/>
				<xsl:variable name="stateValue" select="@stateValue"/>
				<xsl:variable name="expectedStartValue">
						<xsl:choose>
							<xsl:when test="$externalVarId != '' ">
								<xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $externalVarId]"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$stateValue"/>
							</xsl:otherwise>
						</xsl:choose>
				</xsl:variable>
				
					<xsl:variable name="expectedStartupString">
						<xsl:call-template name="getServiceStartup">
							<xsl:with-param name="startValue" select="$expectedStartValue"/>
						</xsl:call-template>
					</xsl:variable>
					
					<xsl:for-each
						select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
						
						<xsl:variable name="itemRef" select="@item_id"/>
						<xsl:variable name="result" select="@result"/>
						
						<xsl:variable name="actualStartupValue"
							select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
						<xsl:variable name="actualServiceStatus"
							select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
						
						<xsl:variable name="actualStartupString">
							<xsl:call-template name="getServiceStartup">
								<xsl:with-param name="startValue" select="$actualStartupValue"/>
							</xsl:call-template>
						</xsl:variable>
						
						<xsl:variable name="message_id">
							<xsl:choose>
								<xsl:when test="$actualServiceStatus = 'does not exist' ">
									<xsl:text>com.mcafee.pa.msg.winservicenotexist</xsl:text>
								</xsl:when>
								<xsl:otherwise>
									<xsl:text>com.mcafee.pa.msg.winservicestartupmessage</xsl:text>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						
						<finding messageId="{$message_id}" isViolation="false">
							<instanceValue key="service">
								<xsl:value-of select="$serviceName"/>
							</instanceValue>
							<instanceValue key="expectedStartup">
								<xsl:value-of select="$expectedStartupString"/>
							</instanceValue>
							<actualValue key="actualStartup">
								<xsl:value-of select="$actualStartupString"/>
							</actualValue>
						</finding>
					</xsl:for-each>
			
			</xsl:for-each>
			
				<!--<xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @testtype ='startupexistcheck'  ]">	
					<xsl:variable name="test" select="@id"/>
					<xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">              		
						<xsl:variable name="itemRef" select="@item_id"/>
						
						<xsl:variable name="actualServiceStatus"
							select="$SystemData/win-sc:registry_item[@id=$itemRef]/@status"/>
						<xsl:if test="$actualServiceStatus = 'does not exist' ">               		
							<finding messageId="com.mcafee.pa.msg.winservicestartupnotexist" isViolation="false">
								<instanceValue key="service">
									<xsl:value-of select="$serviceName"/>
								</instanceValue>
							</finding>
						</xsl:if>
					</xsl:for-each>
				</xsl:for-each>-->
	
			</findings>
		</xsl:if>
		
</xsl:template>
</xsl:stylesheet>
