<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:fnd="http://results.pa.mcafee.com/findings/5.2">

    
    <!--  FILENAME: winNoUsersUnderAGroup_SCAP.xsl   DATE: 7th Jan, 2013   AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winNoUsersUnderAGroup_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECKS to verify if a group has any users under it -->
    
    <!-- FOLLOWING ARE SOME OF THE TEST CASES FOR THE LIBRARY 
        Title - Allowed users - Power Users - None allowed
    
    Pass:
    =====
    
    1. Expected group exists and no user are the members of the expected group.
    2. Expected group does not exist.
        
    Fail:
    ===
    
    Expected group exists and one or more user are the members of the expected group.
       
    -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="OvalResult"
    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
  
     <xsl:call-template name="winConfigurationCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
          </xsl:call-template>
    </xsl:template>

    <xsl:template name="concatWithDelimiter">
        <xsl:param name="currIndex"/>
        <xsl:param name="paramValue"/>
        <xsl:param name="lastIndex"/>
        
        <xsl:choose>
            <xsl:when test="$currIndex &lt;=$lastIndex">
                
                <xsl:variable name="currValue" select="$SystemData/win-sc:group_item/win-sc:user[$currIndex]/text()"/>
                
                <xsl:call-template name="concatWithDelimiter">
                    <xsl:with-param name="currIndex" select="$currIndex + 1"/>
                    <xsl:with-param name="paramValue" select="concat($paramValue, ' | ', $currValue)"/>
                    <xsl:with-param name="lastIndex" select="$lastIndex"/>
                </xsl:call-template>
                
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$paramValue != ''">
                    <xsl:value-of select="substring($paramValue,2)"/>
                </xsl:if>                
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

        <xsl:variable name="tests">
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:group_test[@id=$test]">
                  
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="type">
                            <xsl:text>grouptest</xsl:text>
                        </xsl:attribute>                        
                    </xsl:element>
                </xsl:if>
           </xsl:for-each>

       </xsl:variable>
        
        <xsl:if test="$def_result = 'false' or $def_result = 'true' ">

            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='grouptest' ]">
                    <xsl:variable name="test" select="@id"/>
                    
                        <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]">
                            <xsl:variable name="result" select="@result"/>
                            <xsl:variable name="userGroup">
                                <xsl:choose>
                                    <xsl:when test="$SystemData/win-sc:group_item/win-sc:group!=''">
                                        <xsl:value-of select="$SystemData/win-sc:group_item/win-sc:group"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="substring-before(substring-after($Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title,'Allowed users - '),'- None allowed')"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                        
                            <xsl:variable name="userList">
                                <xsl:call-template name="concatWithDelimiter">
                                    <xsl:with-param name="currIndex" select="1"/>
                                    <xsl:with-param name="paramValue"/>
                                    <xsl:with-param name="lastIndex" select="count($SystemData/win-sc:group_item/win-sc:user/text())"/>
                                </xsl:call-template>
                                
                            </xsl:variable>
                            <xsl:variable name="isViolationValue">
                                <xsl:if test="$def_result = 'false' ">
                                    <xsl:text>true</xsl:text>
                                </xsl:if>
                                <xsl:if test="$def_result = 'true' ">
                                    <xsl:text>false</xsl:text>
                                </xsl:if>
                            </xsl:variable>
                            
                       <xsl:variable name="message_Id">
                           <xsl:choose>
                               <!-- When final result is Pass -->
                               <xsl:when test="$def_result = 'true'">
                                   <xsl:choose>
                                       <xsl:when test="$SystemData/win-sc:group_item/win-sc:group!=''">
                                           <xsl:text>com.mcafee.pa.msg.GroupSettingAsExpected_SCAP</xsl:text>
                                       </xsl:when>
                                       <xsl:otherwise>
                                           <xsl:text>com.mcafee.pa.msg.GroupDoesNotExist_SCAP</xsl:text>
                                       </xsl:otherwise>
                                   </xsl:choose>
                               </xsl:when>

                               <!-- When final result is Fail -->
                               <xsl:when test="$def_result = 'false'">
                                   <xsl:text>com.mcafee.pa.msg.UserList_SCAP</xsl:text>
                               </xsl:when>
                           </xsl:choose>
                       </xsl:variable> 
                            
                            <finding messageId="{$message_Id}" isViolation="{$isViolationValue}">
                                <instanceValue key="userList">
                                    <xsl:value-of select="$userList"/>
                                </instanceValue>
                                <instanceValue key="group">
                                    <xsl:value-of select="$userGroup"/>
                                </instanceValue>
                        </finding>
                        </xsl:for-each>
                </xsl:for-each>
            </findings>
         </xsl:if>     
    </xsl:template>
</xsl:stylesheet>