<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:fnd="http://results.pa.mcafee.com/findings/5.2">

    
    <!--  FILENAME: winSysProp_PerfOpt_DEPSetting_SCAP.xsl   DATE: 2nd Nov, 2011     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winSysProp_PerfOpt_DEPSetting_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECK to verify the security level of Data Execution Prevention (DEP) on your system. -->
        
    <!-- FOLLOWING ARE SOME OF THE TEST CASES FOR THE LIBRARY 
    
    Pass:
    =====
    
    1. When user input is OptIn (Default setting) and system is set to OptIn (Default setting) (Not configured)
    2. When user input is any of the other settings and system is set to same settings as user input
    
    Fail:
    ===
    
    3. When user input is OptIn (Default setting) and system is set to any other settings other than OptIn (Default setting).
    4. When user input is other than OptIn (Default setting) and system is set to OptIn (Default setting) or not configured.
       
    -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

        
     <xsl:call-template name="winConfigurationCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
          </xsl:call-template>
    </xsl:template>

    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

        <xsl:variable name="tests">
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/oval-ind:textfilecontent_test[@id=$test]">
                    <!-- <xsl:variable name="object"
                        select="$Tests/oval-ind:textfilecontent_test[@id=$test]/oval-ind:object/@object_ref"/> -->
                    <xsl:variable name="state"
                        select="$Tests/oval-ind:textfilecontent_test[@id=$test]/oval-ind:state/@state_ref"/>
                         
                    <xsl:variable name="extVarId"
                        select="$States/oval-ind:textfilecontent_state[$state]/oval-ind:subexpression/@var_ref"/>
                    
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                    
                        <xsl:attribute name="state">
                              <xsl:value-of select="$state"/>
                        </xsl:attribute>
                    
                         <xsl:attribute name="extVarID">
                               <xsl:value-of select="$extVarId"/>
                          </xsl:attribute>
                                
                        <xsl:attribute name="type">
                            <xsl:text>textfiletest</xsl:text>
                        </xsl:attribute>                        
                    </xsl:element>
                </xsl:if>
           </xsl:for-each>

        </xsl:variable>
        
        <xsl:if test="$def_result = 'false' or $def_result = 'true' ">
                
            <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
            <xsl:variable name="result2"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
            
            <xsl:if test="$result3='false'">
                
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='textfiletest' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"/>
                    <xsl:variable name="extVarID" select="@extVarID"/>
                    
                    
                  <xsl:if test="$state != ''">
                        
                    <xsl:if test="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable != ''">
                        <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                        
                            
                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:variable name="externalVarValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id=$extVarID]"/>
                            
                            <xsl:variable name="actualValue" select="$SystemData/ind-sc:textfilecontent_item[@id=$itemRef]/ind-sc:subexpression"/>
                            
                            
                            <xsl:variable name="isViolationValue">
                                <xsl:if test="$def_result = 'false' ">
                                    <xsl:text>true</xsl:text>
                                </xsl:if>
                                <xsl:if test="$def_result = 'true' ">
                                    <xsl:text>false</xsl:text>
                                </xsl:if>
                            </xsl:variable>
                            
                          
                            <xsl:variable name="userValue">
                                  <xsl:choose>
                                      <xsl:when test="contains($externalVarValue,'OptIn')">
                                          <xsl:text>OptIn (Default setting)</xsl:text>
                                      </xsl:when>
                                      <xsl:when test="contains($externalVarValue,'OptOut')">
                                          <xsl:text>OptOut (Some processes do not support DEP)</xsl:text>
                                      </xsl:when>
                                      <xsl:when test="contains($externalVarValue,'AlwaysOn')">
                                          <xsl:text>AlwaysOn (Full DEP coverage)</xsl:text>
                                      </xsl:when>
                                      <xsl:when test="contains($externalVarValue,'AlwaysOff')">
                                          <xsl:text>AlwaysOff (No DEP coverage)</xsl:text>
                                      </xsl:when>
                                  </xsl:choose>
                                
                            </xsl:variable>
                            
                            <xsl:variable name="sysValue">
                                <xsl:choose>
                                    <xsl:when test="contains($actualValue,'OptIn')">
                                        <xsl:text>OptIn (Default setting)</xsl:text>
                                    </xsl:when>
                                    <xsl:when test="contains($actualValue,'OptOut')">
                                        <xsl:text>OptOut (Some processes do not support DEP)</xsl:text>
                                    </xsl:when>
                                    <xsl:when test="contains($actualValue,'AlwaysOn')">
                                        <xsl:text>AlwaysOn (Full DEP coverage)</xsl:text>
                                    </xsl:when>
                                    <xsl:when test="contains($actualValue,'AlwaysOff')">
                                        <xsl:text>AlwaysOff (No DEP coverage)</xsl:text>
                                    </xsl:when>
                                    <xsl:when test="$actualValue=''">
                                        <xsl:text>NULL (No value is set)</xsl:text>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="$actualValue"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                          </xsl:variable>
                            
                       <xsl:variable name="message_Id">
                           <xsl:text>com.mcafee.pa.msg.dep_SCAP</xsl:text>
                       </xsl:variable>
                            
                        <inputValue key="expectedValue">
                            <xsl:value-of select="$userValue"/>
                        </inputValue>
                            <finding messageId="{$message_Id}" isViolation="{$isViolationValue}">
                                <actualValue key="actualValue">
                                    <xsl:value-of select="$sysValue"/>
                                </actualValue>
                        </finding>
                            </xsl:for-each>
                        
                    </xsl:if>
                  </xsl:if>  
                </xsl:for-each>
            </findings>
            </xsl:if>
            
            
            <xsl:if test="$result3='true'">
                
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    
                    <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='textfiletest' ]">
                        <xsl:variable name="test" select="@id"/>
                        <xsl:variable name="state" select="@state"/>
                        <xsl:variable name="extVarID" select="@extVarID"/>
                        
                        
                        <xsl:if test="$state != ''">
                                   <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable">
                                       
                                    <xsl:variable name="itemRef" select="@item_id"/>
                                       
                                    <xsl:variable name="externalVarValue" select="$SystemData/ind-sc:variable_item[@id=0]/ind-sc:value"/>
                                     
                                       <xsl:variable name="sysValue">
                                           <xsl:choose>
                                               <xsl:when test="$result2='true'">
                                                   <xsl:text>OptIn (Default setting)</xsl:text>      
                                               </xsl:when>
                                               <xsl:otherwise>
                                                   <xsl:text>Not Configured</xsl:text>
                                               </xsl:otherwise>
                                           </xsl:choose>
                                       </xsl:variable>
                                    
                                    
                                    <xsl:variable name="isViolationValue">
                                        <xsl:if test="$def_result = 'false' ">
                                            <xsl:text>true</xsl:text>
                                        </xsl:if>
                                        <xsl:if test="$def_result = 'true' ">
                                            <xsl:text>false</xsl:text>
                                        </xsl:if>
                                    </xsl:variable>
                                    
                                    <xsl:variable name="userValue">
                                        <xsl:choose>
                                            <xsl:when test="contains($externalVarValue,'OptIn')">
                                                <xsl:text>OptIn (Default setting)</xsl:text>
                                            </xsl:when>
                                            <xsl:when test="contains($externalVarValue,'OptOut')">
                                                <xsl:text>OptOut (Some processes do not support DEP)</xsl:text>
                                            </xsl:when>
                                            <xsl:when test="contains($externalVarValue,'AlwaysOn')">
                                                <xsl:text>AlwaysOn (Full DEP coverage)</xsl:text>
                                            </xsl:when>
                                            <xsl:when test="contains($externalVarValue,'AlwaysOff')">
                                                <xsl:text>AlwaysOff (No DEP coverage)</xsl:text>
                                            </xsl:when>
                                        </xsl:choose>
                                    </xsl:variable>
                                  
                                    <xsl:variable name="message_Id">
                                        <xsl:choose>
                                            <xsl:when test="$sysValue='OptIn (Default setting)'">
                                                <xsl:text>com.mcafee.pa.msg.dep_SCAP</xsl:text>        
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text>com.mcafee.pa.msg.dep.notconfigured_SCAP</xsl:text> 
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:variable>
                                    
                                    <inputValue key="expectedValue">
                                        <xsl:value-of select="$userValue"/>
                                    </inputValue>
                                    <finding messageId="{$message_Id}" isViolation="{$isViolationValue}">
                                        <actualValue key="actualValue">
                                            <xsl:value-of select="$sysValue"/>
                                        </actualValue>
                                    </finding>
                                </xsl:for-each>
                            </xsl:if>
                    </xsl:for-each>
                </findings>
            </xsl:if>
            
         </xsl:if>     
    </xsl:template>
</xsl:stylesheet>