<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with 2 file tests.
         1 file test verifies if a specific config file is present on the system. If this is true then, it mandates the
         other config file to exists on the system.
                   
          Logic 1 :-
          <criteria operator="OR">
            <criterion comment="Test for the existence of the file" negate="true" test_ref="oval:com.mcafee.oval:tst:79614"/> - File test 1
            <criterion comment="Test for the existence of the file /etc/vsftpd.ftpusers" test_ref="oval:com.mcafee.oval:tst:238313"/> - File test 2
          </criteria>
          
          without external variable & OVAL State.
          
          Ex. OVAL ID - oval:com.mcafee.oval:def:238312
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[1]/@result"/>
    
    <xsl:variable name="fileTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[1]/@id"/>
    <xsl:variable name="definitionFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id1]"/>
    <xsl:variable name="filePath1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest1/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest1/unix-def:object/@object_ref]/unix-def:filename/text()" />
    <xsl:variable name="fileInfo1" select="concat($filePath1,'/', $fileName1)"/>
    
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criterion[2]/@result"/>
    
    <xsl:variable name="fileTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[2]/@id"/>
    <xsl:variable name="definitionFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id2]"/>
    <xsl:variable name="filePath2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest2/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest2/unix-def:object/@object_ref]/unix-def:filename/text()" />
    <xsl:variable name="fileInfo2" select="concat($filePath2,'/', $fileName2)"/>
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="fileType">
      <xsl:choose>
        <xsl:when test="$fileName1!=''">
            <xsl:text>File</xsl:text>
        </xsl:when>
        <xsl:otherwise>
           <xsl:text>Directory</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      
    </xsl:variable>
    
    <xsl:variable name="isViolationValue">
      
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
      <xsl:if test="$result='true'">
        <xsl:choose>
          <xsl:when test="$result1='true' and  $result2='false'">
            <xsl:text>com.mcafee.pa.msg.configfile2DoesNotExists</xsl:text>
          </xsl:when>
          <xsl:when test="$result1='false' and $result2='true'">
            <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:if>
      <xsl:if test="$result='false'">
        <xsl:choose>
          <xsl:when test="$result1='false' and  $result2='false'">
            <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>
          </xsl:when>
        </xsl:choose>
      </xsl:if>
    </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="key">filename</xsl:attribute>
        <xsl:value-of select="$fileInfo2" />
      </xsl:element>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_type</xsl:attribute>
          <xsl:value-of select="$fileType"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$fileInfo1"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>