<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is specific to AIX Patch Checks of SCAP Content.
        
        Patch details will be piacked up based on the result of the applicability. 
        
        Usual title pattern would be Patch for AIX <cause of the vulnerability> vulnerability.
        
        Example:Patch for AIX openSSL advisory9
        
        This library is in specific for any AIX application related version verification. - Example OpenSSL
        Affected fileset is verified for a version >= fixed version. This is a modified version of aixPatchCheckLibrary_OpenSSL.
        
        <criteria>
            <criteria comment="Prerequisite tests">
            <criterion comment="openssl.base fileset existence test" test_ref="oval:com.mcafee.oval:tst:232415"/>
            </criteria>
            <criteria comment="Patch Criteria" negate="true" operator="OR">
                <criteria comment="Check if openssl.base fileset version is greater than 0.9.8.2501" operator="AND">
                <criterion test_ref="oval:com.mcafee.oval:tst:1234"/>
                <criterion test_ref="oval:com.mcafee.oval:tst:5678"/>
            </criteria>
            <criteria comment="Check if openssl.base fileset version is greater than 1.0.1.510" operator="AND">
                <criterion test_ref="oval:com.mcafee.oval:tst:1111"/>
                <criterion test_ref="oval:com.mcafee.oval:tst:232416"/>
                <criterion test_ref="oval:com.mcafee.oval:tst:9101"/>
            </criteria>
            <criteria comment="Check if openssl.base fileset version is greater than 12.9.8.2501" operator="AND">
                <criterion test_ref="oval:com.mcafee.oval:tst:232418"/>
                <criterion test_ref="oval:com.mcafee.oval:tst:1213"/>  
            </criteria>
                            
	Test Cases:
	1. Pass - Not Applicable - When OpenSSL is not installed (required fileset is not present) on the system.
	2. Pass - Fixed version of OpenSSL is installed on the system (Version Range 1).
	3. Pass - Fixed version of OpenSSL is installed on the system (Version Range 2).
	4. Pass - Fixed version of OpenSSL is installed on the system (Version Range 3).
	5. Fail - Vulnerable version of OpenSSL is installed on the system (Version Range 1).
	6. Fail - Vulnerable version of OpenSSL is installed on the system (Version Range 2).
	7. Fail - Vulnerable version of OpenSSL is installed on the system (Version Range 3).
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="appTestRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[1]/@result"/>
        
        <xsl:variable name="expectedVer">
            <xsl:choose>
                <xsl:when test="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[2]/@result='true'">
                    <xsl:variable name="testID" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[3]/@test_ref"/>
                    <xsl:variable name="steID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$testID]/aix-def:state/@state_ref"/>
                    <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/aix-def:fileset_state[@id=$steID]/aix-def:level/text()"/>
                </xsl:when>
                <xsl:when test="(/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[4]/@result='true' ) and (/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[5]/@result='true')">
                    <xsl:variable name="testID" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[6]/@test_ref"/>
                    <xsl:variable name="steID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$testID]/aix-def:state/@state_ref"/>
                    <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/aix-def:fileset_state[@id=$steID]/aix-def:level/text()"/>
                </xsl:when>
                <xsl:when test="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[7]/@result='true'">
                    <xsl:variable name="testID" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/descendant::oval-res:criterion[8]/@test_ref"/>
                    <xsl:variable name="steID"  select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$testID]/aix-def:state/@state_ref"/>
                    <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/aix-def:fileset_state[@id=$steID]/aix-def:level/text()"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test/@id"/>
        <xsl:variable name="fileTestItem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileTest_id]/oval-res:tested_item/@item_id"/>
        <xsl:variable name="fileTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/aix-sc:fileset_item[@id=$fileTestItem_id]" />        
        <xsl:variable name="actualVer" select="$fileTestItem/aix-sc:level/text()"/>
        
        <xsl:variable name="objID" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/aix-def:fileset_test[@id=$fileTest_id]/descendant::aix-def:object/@object_ref"/>
        <xsl:variable name="filesteName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/aix-def:fileset_object[@id=$objID]/aix-def:flstinst/text()"/>
        
        <xsl:variable name="title">
            <xsl:value-of select="substring-after(/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title,'Patch for ')"/>            
        </xsl:variable>
        <xsl:variable name="product">
            <xsl:text>OpenSSL</xsl:text>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                 <xsl:text>com.mcafee.pa.msg.aixAppVerNotInstalled</xsl:text>
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$actualVer!=''">
                        <xsl:text>com.mcafee.pa.msg.aixAppVerInstalled</xsl:text>
                    </xsl:when>
                    <xsl:when test="$appTestRes='false'">
                        <xsl:text>com.mcafee.pa.msg.aixAppVerNotApplicable</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="key">expectedValue</xsl:attribute>
                <xsl:value-of select="$expectedVer" />
            </xsl:element>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">vulnerability</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">product</xsl:attribute>
                    <xsl:value-of select="$product"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">fileset</xsl:attribute>
                    <xsl:value-of select="$filesteName"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actualValue</xsl:attribute>
                    <xsl:value-of select="$actualVer"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>