<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to handle the OVAL checks with the only two text file tests.
        Text file test verifies if a specific patterns of text is present in the configuration file in test.
        
        Logic :-
        <criteria operator="AND">
        <criterion comment="Check /etc/passwd for roots home directory" test_ref="oval:com.mcafee.oval:tst:5733" />
        </criteria>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:5723
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <!-- Collect the final result of the OVAL check -->
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect configuration name from the title --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[@id=$definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <!-- Collect all test references, test results and other misc data  required --> 
        <xsl:variable name="passwdTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test/@id"/>
        
        <xsl:variable name="definitionPasswdTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[@id=$passwdTest_id]"/>
        <xsl:variable name="userName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:password_object[@id=$definitionPasswdTest/unix-def:object/@object_ref]/unix-def:username/text()" />
        <xsl:variable name="expectedConfig" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:password_state[@id=$definitionPasswdTest/unix-def:state/@state_ref]/unix-def:home_dir/text()" />
        
        <xsl:variable name="passwdObj_ref" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:password_test[@id=$passwdTest_id]/unix-def:object/@object_ref" />
        <xsl:variable name="passwdObj_flag" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects/oval-sc:object[@id=$passwdObj_ref]/@flag"/>
        
        <xsl:variable name="passwditem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$passwdTest_id]/oval-res:tested_item/@item_id"/>        
        <xsl:variable name="passwditem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:password_item[@id=$passwditem_id]" />        
        <xsl:variable name="actualConfig" select="$passwditem/unix-sc:home_dir/text()"/>
        
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        
        <xsl:variable name="message_id">
            <!-- Check if result is true ......................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.configStatus</xsl:text>
            </xsl:if>           
            
            <!-- Check if result is false .......................................-->
            <xsl:if test="$result='false' ">
                <xsl:text>com.mcafee.pa.msg.configStatus</xsl:text>                
            </xsl:if>    
        </xsl:variable>
        
        
        <!-- The following section should be compliant to PA findings schema -->
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="key">expected_config</xsl:attribute>
                <xsl:value-of select="$expectedConfig" />
            </xsl:element>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">user_name</xsl:attribute>
                    <xsl:value-of select="$userName"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actual_config</xsl:attribute>
                    <xsl:value-of select="$actualConfig"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

