
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan">
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>

    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
    
    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>


    </xsl:template>

    <xsl:template name="getConstantVariables">
        <xsl:param name="var_ref"/>
        <xsl:if test="$var_ref != '' ">
            <xsl:variable name="tmpValues">
                <xsl:for-each select="$Variables/oval-def:constant_variable[@id=$var_ref ]/*">
                    <xsl:value-of select="."/>
                    <xsl:if test="position() != last()">
                        <xsl:text> or </xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>

            <xsl:if test="$tmpValues = '' ">
                <xsl:value-of select="$var_ref"/>
            </xsl:if>
            <xsl:if test="$tmpValues != '' ">
                <xsl:value-of select="$tmpValues"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template name="formatDisplayOpration">
        <xsl:param name="operation"/>
        <xsl:param name="datatype"/>
        
        <xsl:choose>
            <xsl:when test="$datatype = 'int' ">

                <xsl:choose>
                    <xsl:when test=" $operation = 'equals' ">
                        <xsl:text>should be equal to</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'not equal' ">
                        <xsl:text>should not be equal to</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'greater than' ">
                        <xsl:text>should be greater than</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'less than' ">
                        <xsl:text>should be less than</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'greater than or equal' ">
                        <xsl:text>should be greater than or equal to</xsl:text>
                    </xsl:when>

                    <xsl:when test=" $operation = 'less than or equal' ">
                        <xsl:text>should be less than or equal to</xsl:text>
                    </xsl:when>


                </xsl:choose>
            </xsl:when>
            
            <xsl:when test="$datatype = 'boolean' ">

                <xsl:choose>
                    <xsl:when test=" $operation = 'equals' ">
                        <xsl:text>should be</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'not equal' ">
                        <xsl:text>should not be</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            
            <xsl:when test="$datatype = 'string' ">
                
                <xsl:choose>
                    <xsl:when test=" $operation = 'equals' ">
                        <xsl:text>should be</xsl:text>
                    </xsl:when>
                    <xsl:when test=" $operation = 'not equal' ">
                        <xsl:text>should not be</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>should be like</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
