﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
    <!--  FILENAME: winCompEventLogServSettings_1_SCAP.xsl         DATE: 15th Jan, 2013     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winCompEventLogServSettings_1_SCAP_xsl.txt    -->
    
    <!-- This is a modified version of  winCompEventLogServSettings_SCAP.xsl library -->
        
<!-- FOLLOWING ARE SOME OF THE ASSUMPTIONS TAKEN IN THE LOGIC FOR THE LIBRARY  -->
   <!--   1. Configuration/Policy name is extracted from the title of the check.
       
    Library works fine for the below check logic:
    
    <criteria operator="AND">
        <criteria operator="OR">
            <criteria operator="AND">
                <criterion comment="External Variable = Not Configured" negate="false" test_ref="oval:com.mcafee.oval:tst:240673"/>
                <criterion comment="HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\(Reserved) does not exist" negate="false" test_ref="oval:com.mcafee.oval:tst:239100"/>
                <criterion comment="HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\Explorer.exe does not exist" negate="false" test_ref="oval:com.mcafee.oval:tst:240609"/>
                <criterion comment="HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\Iexplore.exe does not exist" negate="false" test_ref="oval:com.mcafee.oval:tst:240610"/>
            </criteria>
        <criteria operator="AND">
            <criterion comment="External Variable = Enabled" negate="false" test_ref="oval:com.mcafee.oval:tst:240665"/>
            <criterion comment="Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\(Reserved) = 1" negate="false" test_ref="oval:com.mcafee.oval:tst:240666"/>
            <criterion comment="Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\Explorer.exe = 1" negate="false" test_ref="oval:com.mcafee.oval:tst:240667"/>
            <criterion comment="Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\Iexplore.exe = 1" negate="false" test_ref="oval:com.mcafee.oval:tst:240668"/>
        </criteria>
        <criteria operator="AND">
            <criterion comment="External Variable = Disabled" negate="false" test_ref="oval:com.mcafee.oval:tst:240669"/>
            <criterion comment="Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\(Reserved) = 0" negate="false" test_ref="oval:com.mcafee.oval:tst:240670"/>
            <criterion comment="Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\Explorer.exe = 0" negate="false" test_ref="oval:com.mcafee.oval:tst:240671"/>
            <criterion comment="Registry key HKLM\Software\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_MIME_SNIFFING\Iexplore.exe = 0" negate="false" test_ref="oval:com.mcafee.oval:tst:240672"/>
          </criteria>
      </criteria>
   </criteria>
   
   <external_variable id='oval:com.mcafee.oval:var:231226' version='5' datatype='string' comment='Mime Sniffing Safety Feature: Internet Explorer Processes'>
       <possible_value hint='Enabled'>Enabled</possible_value>
       <possible_value hint='Disabled'>Disabled</possible_value>
       <possible_value hint='Not Configured'>Not Configured</possible_value>
   </external_variable>
   
   Ex: OVAL ID :- oval:com.mcafee.oval.ie7:def:317
   
   -->

    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <!-- Final result -->
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        
        <!-- Extract configuration/policy name from the check title -->
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>
        <xsl:variable name="result7"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[7]/@result"/>
        <xsl:variable name="result8"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[8]/@result"/>
        <xsl:variable name="result9"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[9]/@result"/>
        <xsl:variable name="result10"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[10]/@result"/>
        <xsl:variable name="result11"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[11]/@result"/>
        <xsl:variable name="result12"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[12]/@result"/>
        
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                 <xsl:text>com.mcafee.pa.msg.winConf_SCAP</xsl:text>
             </xsl:variable>
            
        <xsl:variable name="expectedValue">
            <xsl:choose>
                <xsl:when test="$result1 = 'true' ">
                    <xsl:text>Not Configured</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result5 = 'true' ">
                    <xsl:text>Enabled (1)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result9 = 'true' ">
                    <xsl:text>Disabled (0)</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="actualValue">
            <xsl:choose>
                <xsl:when test="$result2 = 'true' and $result3 = 'true' and $result4 = 'true'">
                    <xsl:text>Not Configured</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result6 = 'true' and $result7 = 'true' and $result8 = 'true'">
                    <xsl:text>Enabled (1)</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result10 = 'true' and $result11 = 'true' and $result12 = 'true'">
                    <xsl:text>Disabled (0)</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="title">
                    <xsl:value-of select="$title"/>                                                    
                </instanceValue>
                <instanceValue key="expectedValue">
                    <xsl:value-of select="$expectedValue"/>                                                    
                </instanceValue>
                <actualValue key="actualValue">
                    <xsl:value-of select="$actualValue"/>                                                    
                </actualValue>
            </finding>
        </findings>
      
    </xsl:template>
</xsl:stylesheet>
