<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:fnd="http://results.pa.mcafee.com/findings/5.2">

    
    <!--  FILENAME: winUserStatusCheck_SCAP.xsl   DATE: 14th Oct, 2011     AUTHOR: Nandini NR   -->
    <!--  MAPPINGFILE: winUserStatusCheck_SCAP_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECKS to verify the status (Enabled, Disabled and Does not exist) of the User Account/Accounts entered by the user -->
        
    <!-- FOLLOWING ARE SOME OF THE TEST CASES FOR THE LIBRARY 
    
        1. All exist - Enable, disable, does not exist - User Input - 1 and Multiple Users Accounts are entered by user - Fail
        2. All exist - Enable, disable, does not exist - User Input - 0 and Multiple Users Accounts are entered by user - Fail
        3. Enable, Disable user accounts exist - User Input - 1 and Multiple Users Accounts are entered by user - Fail
        4. Enable, Disable user accounts exist - User Input - 0 and Multiple Users Accounts are entered by user - Fail
        5. Enable, Does not exist user accounts - User Input - 1 and Multiple Users Accounts are entered by user - Pass
        6. Enable, Does not exist user accounts - User Input - 0 and Multiple Users Accounts are entered by user  - Fail
        7. Disable, Does not exist user accounts - User Input - 1 and Multiple Users Accounts are entered by user - Fail
        8. Disable, Does not exist - user accounts - User Input - 0 and Multiple Users Accounts are entered by user - Pass
        9. Does Not Exist user accounts - User Input - 0/1 and Multiple (one or more) Users Accounts are entered by user - Fail
        10. Enable user accounts - User Input - 1 and Multiple (one or more) Users Accounts are entered by user - Pass
        11. Enable user accounts - User Input - 0 and Multiple (one or more) Users Accounts are entered by user - Fail
        12. Disable user accounts - User Input - 1 and Multiple (one or more) Users Accounts are entered by user - Fail
        13. Disable user accounts - User Input - 0 and Multiple (one or more) Users Accounts are entered by user - Pass
        14. General - When none of the above cases work, general message of all the entered user account status would be disaplyed - Pass/Fail  -->
    
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:template name="concatWithDelimiter">
        <xsl:param name="currIndex"/>
        <xsl:param name="paramValue"/>
        <xsl:param name="itemRef"/>
        <xsl:param name="lastIndex"/>
        
        <xsl:variable name="userExistanceStatus" select="$SystemData/win-sc:user_item[@id=$itemRef]/@status"/>
        <xsl:variable name="actualParameterValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:enabled"/>
        
        <xsl:choose>
            <xsl:when test="$currIndex &lt;= $lastIndex">
                
                <xsl:variable name="currValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:user"/>
                
                <xsl:if test="$userExistanceStatus = 'does not exist'">
                    <xsl:call-template name="concatWithDelimiter">
                        <xsl:with-param name="currIndex" select="$currIndex + 1"/>
                        <xsl:with-param name="paramValue" select="concat($paramValue, '|', $currValue)"/>
                        <xsl:with-param name="itemRef" select="$itemRef + 1"/>
                        <xsl:with-param name="lastIndex" select="$lastIndex"/>
                    </xsl:call-template>
                </xsl:if>
                
                <xsl:if test="$actualParameterValue = '0' or $actualParameterValue = '1'">
                    <xsl:call-template name="concatWithDelimiter">
                        <xsl:with-param name="currIndex" select="$currIndex + 1"/>
                        <xsl:with-param name="paramValue" select="$paramValue"/>
                        <xsl:with-param name="itemRef" select="$itemRef + 1"/>
                        <xsl:with-param name="lastIndex" select="$lastIndex"/>
                    </xsl:call-template>
                </xsl:if>
                
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$paramValue != ''">
                    <xsl:value-of select="substring($paramValue,2)"/>
                </xsl:if>                
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>

    <xsl:template name="concatWithDelimiter_Dis">
        <xsl:param name="currIndex"/>
        <xsl:param name="paramValue"/>
        <xsl:param name="itemRef"/>
        <xsl:param name="lastIndex"/>
        
        <xsl:variable name="userExistanceStatus" select="$SystemData/win-sc:user_item[@id=$itemRef]/@status"/>
        <xsl:variable name="actualParameterValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:enabled"/>
        
        <xsl:choose>
            <xsl:when test="$currIndex &lt;= $lastIndex">
                
                <xsl:variable name="currValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:user"/>
                
                <xsl:if test="$userExistanceStatus = 'does not exist'  or $actualParameterValue = '1'">
                    <xsl:call-template name="concatWithDelimiter_Dis">
                        <xsl:with-param name="currIndex" select="$currIndex + 1"/>
                        <xsl:with-param name="paramValue" select="$paramValue"/>
                        <xsl:with-param name="itemRef" select="$itemRef + 1"/>
                        <xsl:with-param name="lastIndex" select="$lastIndex"/>
                    </xsl:call-template>
                </xsl:if>
                
                <xsl:if test="$actualParameterValue = '0'">
                    <xsl:call-template name="concatWithDelimiter_Dis">
                        <xsl:with-param name="currIndex" select="$currIndex + 1"/>
                        <xsl:with-param name="paramValue" select="concat($paramValue, '|', $currValue)"/>
                        <xsl:with-param name="itemRef" select="$itemRef + 1"/>
                        <xsl:with-param name="lastIndex" select="$lastIndex"/>
                    </xsl:call-template>
                </xsl:if>
                
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$paramValue != ''">
                    <xsl:value-of select="substring($paramValue,2)"/>
                </xsl:if>                
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="concatWithDelimiter_Ena">
        <xsl:param name="currIndex"/>
        <xsl:param name="paramValue"/>
        <xsl:param name="itemRef"/>
        <xsl:param name="lastIndex"/>
        
        <xsl:variable name="userExistanceStatus" select="$SystemData/win-sc:user_item[@id=$itemRef]/@status"/>
        <xsl:variable name="actualParameterValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:enabled"/>
        
        <xsl:choose>
            <xsl:when test="$currIndex &lt;= $lastIndex">
                
                <xsl:variable name="currValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:user"/>
                
                <xsl:if test="$userExistanceStatus = 'does not exist'  or $actualParameterValue = '0'">
                    <xsl:call-template name="concatWithDelimiter_Ena">
                        <xsl:with-param name="currIndex" select="$currIndex + 1"/>
                        <xsl:with-param name="paramValue" select="$paramValue"/>
                        <xsl:with-param name="itemRef" select="$itemRef + 1"/>
                        <xsl:with-param name="lastIndex" select="$lastIndex"/>
                    </xsl:call-template>
                </xsl:if>
                
                <xsl:if test="$actualParameterValue = '1'">
                    <xsl:call-template name="concatWithDelimiter_Ena">
                        <xsl:with-param name="currIndex" select="$currIndex + 1"/>
                        <xsl:with-param name="paramValue" select="concat($paramValue, '|', $currValue)"/>
                        <xsl:with-param name="itemRef" select="$itemRef + 1"/>
                        <xsl:with-param name="lastIndex" select="$lastIndex"/>
                    </xsl:call-template>
                </xsl:if>
                
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$paramValue != ''">
                    <xsl:value-of select="substring($paramValue,2)"/>
                </xsl:if>                
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

        <xsl:variable name="unorderedFindings">
            <xsl:call-template name="winConfigurationCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
        </xsl:call-template>
        </xsl:variable>
        
        <!-- Now arrange all the nodes to fit the schema. All <inputValue/> nodes must come first, followed by all <finding/> nodes-->
        
            <findings id="{xalan:nodeset($unorderedFindings)/descendant::fnd:findings/@id}"  xmlns="http://results.pa.mcafee.com/findings/5.2">
                <xsl:copy>
                    <xsl:copy-of select="xalan:nodeset($unorderedFindings)/descendant::fnd:inputValue"/>
                    <xsl:copy-of select="xalan:nodeset($unorderedFindings)/descendant::fnd:finding"/>
                </xsl:copy>
            </findings>
    </xsl:template>

    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

        <xsl:variable name="tests">
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:user_test[@id=$test]">
                    <xsl:variable name="object"
                        select="$Tests/win-def:user_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"
                        select="$Tests/win-def:user_test[@id=$test]/win-def:state/@state_ref"/>

                    <xsl:variable name="enabledVarId" select="$States/win-def:user_state[@id=$state]/win-def:enabled/@var_ref"/>
                                                            
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        
                       <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                       </xsl:attribute>

                        <xsl:attribute name="enabledVarId">
                            <xsl:value-of select="$enabledVarId"/>
                        </xsl:attribute>
                        
                        <xsl:attribute name="type">
                            <xsl:text>usertest</xsl:text>
                        </xsl:attribute>                        
                    </xsl:element>
                </xsl:if>
           </xsl:for-each>

        </xsl:variable>
        
        <xsl:if test="$def_result = 'false' or $def_result = 'true' ">

            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='usertest' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="state" select="@state"/>
                    <xsl:variable name="enabledVarId" select="@enabledVarId"/>
                    
                    <xsl:if test="$enabledVarId != '' ">
                        <xsl:variable name="enabledVarValue" select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $enabledVarId]"/>

                        <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @item_id = '0']">

                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>

                            <xsl:variable name="actualParameterValue" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:enabled"/>
                            <xsl:variable name="userExistanceStatus" select="$SystemData/win-sc:user_item[@id=$itemRef]/@status"/>
                            <xsl:variable name="userName" select="$SystemData/win-sc:user_item[@id=$itemRef]/win-sc:user"/>
                            
                            <xsl:variable name="userNamesDoesNotExist">
                                <xsl:call-template name="concatWithDelimiter">
                                    <xsl:with-param name="currIndex" select="1"/>
                                    <xsl:with-param name="paramValue"/>
                                    <xsl:with-param name="itemRef" select="$itemRef"/>
                                    <xsl:with-param name="lastIndex" select="count($SystemData/win-sc:user_item)"/>
                                </xsl:call-template>
                            </xsl:variable>
                            
                            <xsl:variable name="userNamesDisabled">
                                <xsl:call-template name="concatWithDelimiter_Dis">
                                    <xsl:with-param name="currIndex" select="1"/>
                                    <xsl:with-param name="paramValue"/>
                                    <xsl:with-param name="itemRef" select="$itemRef"/>
                                    <xsl:with-param name="lastIndex" select="count($SystemData/win-sc:user_item)"/>
                                </xsl:call-template>
                            </xsl:variable>
                            
                            <xsl:variable name="userNamesEnabled">
                                <xsl:call-template name="concatWithDelimiter_Ena">
                                    <xsl:with-param name="currIndex" select="1"/>
                                    <xsl:with-param name="paramValue"/>
                                    <xsl:with-param name="itemRef" select="$itemRef"/>
                                    <xsl:with-param name="lastIndex" select="count($SystemData/win-sc:user_item)"/>
                                </xsl:call-template>
                            </xsl:variable>
                            
                            <xsl:variable name="isViolationValue">
                                <xsl:if test="$def_result = 'false' ">
                                    <xsl:text>true</xsl:text>
                                </xsl:if>
                                <xsl:if test="$def_result = 'true' ">
                                    <xsl:text>false</xsl:text>
                                </xsl:if>
                            </xsl:variable>
                            
                       <xsl:variable name="message_Id">
                            <xsl:choose>
                                <xsl:when test="$enabledVarValue = '1' and $userNamesDoesNotExist != '' and $userNamesDisabled != '' and $userNamesEnabled != ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserStatusAll_UI_Ena_SCAP</xsl:text>
                                </xsl:when>
                                <xsl:when test="$enabledVarValue = '0' and $userNamesDoesNotExist != '' and $userNamesDisabled != '' and $userNamesEnabled != ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserStatusAll_UI_Dis_SCAP</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$enabledVarValue = '1' and $userNamesDoesNotExist != '' and $userNamesDisabled != '' and $userNamesEnabled = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserNotExistDisabledStatus_UI_Ena_SCAP</xsl:text>
                                </xsl:when>
                                <xsl:when test="$enabledVarValue = '1' and $userNamesDoesNotExist != '' and $userNamesEnabled != '' and $userNamesDisabled = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserNotExistEnabledStatus_UI_Ena_SCAP</xsl:text>
                                </xsl:when>
                                <xsl:when test="$enabledVarValue = '1' and $userNamesDisabled != '' and $userNamesEnabled != '' and $userNamesDoesNotExist = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserEnabledDisabledStatus_UI_Ena_SCAP</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$enabledVarValue = '0' and $userNamesDoesNotExist != '' and $userNamesDisabled != '' and $userNamesEnabled = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserNotExistDisabledStatus_UI_Dis_SCAP</xsl:text>
                                </xsl:when>
                                <xsl:when test="$enabledVarValue = '0' and $userNamesDoesNotExist != '' and $userNamesEnabled != '' and $userNamesDisabled = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserNotExistEnabledStatus_UI_Dis_SCAP</xsl:text>
                                </xsl:when>
                                <xsl:when test="$enabledVarValue = '0' and $userNamesDisabled != '' and $userNamesEnabled != '' and $userNamesDoesNotExist = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserEnabledDisabledStatus_UI_Dis_SCAP</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$enabledVarValue = '1' and $userNamesDoesNotExist = '' and $userNamesDisabled != '' and $userNamesEnabled = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserDisabledStatus_UI_Ena_SCAP</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$enabledVarValue = '1' and $userNamesDisabled = '' and $userNamesEnabled != '' and $userNamesDoesNotExist = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserEnabledStatus_UI_Ena_SCAP</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$enabledVarValue = '0' and $userNamesDoesNotExist = '' and $userNamesDisabled != '' and $userNamesEnabled = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserDisabledStatus_UI_Dis_SCAP</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$enabledVarValue = '0' and $userNamesDisabled = '' and $userNamesEnabled != '' and $userNamesDoesNotExist = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserEnabledStatus_UI_Dis_SCAP</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$userNamesDoesNotExist != '' and $userNamesEnabled = '' and $userNamesDisabled = ''">
                                    <xsl:text>com.mcafee.pa.msg.winUserNotExist_AnyUI_SCAP</xsl:text>
                                </xsl:when>
                                
                                <xsl:otherwise>
                                    <xsl:text>com.mcafee.pa.msg.winUserStatusGeneral_SCAP</xsl:text>
                                </xsl:otherwise>
                            </xsl:choose>
                            
                            </xsl:variable> 
                            
                        <inputValue key="expectedValue">
                            <xsl:value-of select="$enabledVarValue"/>
                        </inputValue>
                            <finding messageId="{$message_Id}" isViolation="{$isViolationValue}">
                            <instanceValue key="userDoesNotExist">
                                <xsl:value-of select="$userNamesDoesNotExist"/>
                            </instanceValue>
                            <instanceValue key="userDisabled">
                                <xsl:value-of select="$userNamesDisabled"/>
                            </instanceValue>
                            <instanceValue key="userEnabled">
                                <xsl:value-of select="$userNamesEnabled"/>
                            </instanceValue>
                        </finding>
                        </xsl:for-each>
                    </xsl:if>
                </xsl:for-each>
            </findings>
  </xsl:if>     
    </xsl:template>
</xsl:stylesheet>
