<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to handle the OVAL checks with the Process_test
        
        Logic :-
        <criteria operator="AND">
        <criterion test_ref="oval:com.mcafee.oval:tst:245733" comment="Test if the syslogd daemon is configured to containe -r option." />
        </criteria>
        
        Without State and External Variable.
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:245732
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="processTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:process_test/@id"/>
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$processTest_id]/@result"/>
        
        <xsl:variable name="definitionTextFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:process_test[@id=$processTest_id]"/>
        <xsl:variable name="command" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:process_object[@id=$definitionTextFileTest/unix-def:object/@object_ref]/unix-def:command/text()" />
        
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <!-- Check if result is true ......................................... -->
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.ProcessMatchSCAP</xsl:text>
            </xsl:if>           
            
            <!-- Check if result is false .......................................-->
            <xsl:if test="$result='false' ">
                <xsl:text>com.mcafee.pa.msg.ProcessMatchSCAP</xsl:text>                
            </xsl:if>    
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">command</xsl:attribute>
                    <xsl:value-of select="$command"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

