<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
   
    <!-- This library is to handle the OVAL checks with 2 external variable. 
             
             Logic :-
             <criteria operator="OR">
             <criterion comment="Test the existence of tftp daemon /usr/sbin/in.tftpd" negate="true" test_ref="oval:com.mcafee.oval:tst:234383" />
             <criterion comment="The tftp daemon /usr/sbin/in.tftpd has the suid or sgid bit set." test_ref="oval:com.mcafee.oval:tst:234384" />
             </criteria>
                        
             with 2 External variables.
             
             Ex. OVAL ID - oval:com.mcafee.oval:def:234355
    --> 
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <!--  Convert binary to Octal value -->
    <xsl:template name="convertBinaryToString">
        <xsl:param name="value"/>        
        <xsl:variable name="stringVal">
            <xsl:choose>            
                <xsl:when test="contains($value, 'false' )">
                    <xsl:text>0</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, 'true' )">
                    <xsl:text>1</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, 'FALSE' )">
                    <xsl:text>0</xsl:text>                    
                </xsl:when>
                <xsl:when test="contains($value, 'TRUE' )">
                    <xsl:text>1</xsl:text>                    
                </xsl:when>
            </xsl:choose>            
        </xsl:variable>        
        <xsl:choose>            
            <xsl:when test="$stringVal != '' ">
                <xsl:value-of select="$stringVal"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$value"/>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect configuration name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all the required data from the checks like test ref, obj ref, ste ref and their data and results ......................................... --> 
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="fileTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[1]/@id"/>
        <xsl:variable name="extVar_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[1]/@id"/>
        <xsl:variable name="extVar_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables/oval-def:external_variable[2]/@id"/>
        
        <xsl:variable name="fileTestResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id1]/@result"/>
        
        <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
        <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
        
        <!--  Extract input value -->

        <xsl:variable name="testedVar" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileTest_id1]"/>
        
        <xsl:variable name="expected_config1">
            <xsl:call-template name="convertBinaryToString">
                <xsl:with-param name="value" select="$testedVar/oval-res:tested_variable[1]"/>
            </xsl:call-template>            
        </xsl:variable>
        <xsl:variable name="expected_config2">
            <xsl:call-template name="convertBinaryToString">
                <xsl:with-param name="value" select=" $testedVar/oval-res:tested_variable[2]"/>
            </xsl:call-template>                
        </xsl:variable>
        
        <xsl:variable name="fileInfo">
              <xsl:value-of select="concat($filePath,'/', $fileName)"/>
        </xsl:variable>
        
        <!-- Verify the actual values in existing on the system........................................................................................... -->
        <xsl:variable name="fileTestItem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$fileTest_id1]/oval-res:tested_item/@item_id"/>
        <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$fileTestItem_id]"/>               
        
        <!-- Extract actual value -->
                    <xsl:variable name="actualConfig1">
                        <xsl:call-template name="convertBinaryToString">
                            <xsl:with-param name="value" select="$item/unix-sc:suid/text()"/>            
                        </xsl:call-template>                
                    </xsl:variable>                    
                   <xsl:variable name="actualConfig2">
                        <xsl:call-template name="convertBinaryToString">
                            <xsl:with-param name="value" select="$item/unix-sc:gread/text()"/>            
                        </xsl:call-template>                
                    </xsl:variable>
        

        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="$fileTestResult = 'false' and $result1 = 'true' " >
                        <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
                    </xsl:when>                    
                    <xsl:when test="$fileTestResult= 'true' and $result1 = 'false'" >
                        <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false' ">                
                <xsl:choose>
                    <xsl:when test="$fileTestResult='false' and $result1 = 'false' and (not($actualConfig1) or not($actualConfig2) or $actualConfig1='' or $actualConfig2='')">
                        <xsl:text>com.mcafee.pa.msg.configNotSet</xsl:text>
                    </xsl:when>
                    <xsl:when test="$fileTestResult='false' and $result1 = 'false' and $actualConfig1!='' and $actualConfig2!=''">
                        <xsl:text>com.mcafee.pa.msg.configValuesStatusSCAP</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2" >
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                
                <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">User SUID value</xsl:attribute>
                    <xsl:value-of select="$expected_config1"/>
                </xsl:element>
                <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">User SGID Value</xsl:attribute>
                    <xsl:value-of select="$expected_config2"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">System SUID Value</xsl:attribute>
                    <xsl:value-of select="$actualConfig1"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">System SGID Value</xsl:attribute>
                    <xsl:value-of select="$actualConfig2"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_info</xsl:attribute>
                    <xsl:value-of select="$fileInfo"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>