<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with the multiple text file tests (5) and one file existence test.
         Text file test verifies if a specific patterns of text is present in the configuration file in test.
          
          Logic :-
          <criteria operator="AND">
          <criterion comment="Test for the existence of the file - /etc/audit/audit.rules" test_ref="oval:com.mcafee.oval:tst:98687" />
          <criterion comment="Verify if the /etc/audit/audit.rules file is set with appropriate identity identifier for /etc/group file." test_ref="oval:com.mcafee.oval:tst:249963" />
          <criterion comment="Verify if the /etc/audit/audit.rules file is set with appropriate identity identifier for /etc/passwd file." test_ref="oval:com.mcafee.oval:tst:249964" />
          <criterion comment="Verify if the /etc/audit/audit.rules file is set with appropriate identity identifier for /etc/gshadow file." test_ref="oval:com.mcafee.oval:tst:249965" />
          <criterion comment="Verify if the /etc/audit/audit.rules file is set with appropriate identity identifier for /etc/shadow file." test_ref="oval:com.mcafee.oval:tst:249966" />
          <criterion comment="Verify if the /etc/audit/audit.rules file is set with appropriate identity identifier for /etc/security/opasswd." test_ref="oval:com.mcafee.oval:tst:249967" />
          </criteria>
          
          Ex. OVAL ID - oval:com.mcafee.oval:def:249962 - one file test and 5 textfilecontent54_tests
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid" />
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
    <xsl:variable name="fileTestResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>
    
    <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
    <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
    <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id1]/@result"/>
    <xsl:variable name="definitionTextFileTest1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id1]"/>
    <xsl:variable name="textfilePattern1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest1/ind-def:object/@object_ref]/ind-def:pattern/text()" />
    
    <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
    <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id2]/@result"/>
    <xsl:variable name="definitionTextFileTest2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id2]"/>
    <xsl:variable name="textfilePattern2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest2/ind-def:object/@object_ref]/ind-def:pattern/text()" />
    
    <xsl:variable name="fileContentTest_id3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[3]/@id"/>
    <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id3]/@result"/>
    <xsl:variable name="definitionTextFileTest3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id3]"/>
    <xsl:variable name="textfilePattern3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest3/ind-def:object/@object_ref]/ind-def:pattern/text()" />
    
    <xsl:variable name="fileContentTest_id4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[4]/@id"/>
    <xsl:variable name="result4" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id4]/@result"/>
    <xsl:variable name="definitionTextFileTest4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id4]"/>
    <xsl:variable name="textfilePattern4" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest4/ind-def:object/@object_ref]/ind-def:pattern/text()" />
    
    <xsl:variable name="fileContentTest_id5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[5]/@id"/>
    <xsl:variable name="result5" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id5]/@result"/>
    <xsl:variable name="definitionTextFileTest5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id5]"/>
    <xsl:variable name="textfilePattern5" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest5/ind-def:object/@object_ref]/ind-def:pattern/text()" />
    
  
    <xsl:variable name="fileInfo">
          <xsl:value-of select="concat($filePath,'/', $fileName)"/>
    </xsl:variable>
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
          <!-- Check if result is true ......................................... -->
          <xsl:if test="$result='true'">
            <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
          </xsl:if>            
          <!-- Check if result is false .......................................-->
          <xsl:if test="$result='false' ">
            <xsl:choose>
              <xsl:when test="$fileTestResult='false'">
                <xsl:text>com.mcafee.pa.msg.configfileDoesNotExists</xsl:text>    
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='false' and $result4='false' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.All5PatternsMissingSCAP</xsl:text>                
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='false' and $result4='false' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns1234MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='false' and $result4='true' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns1235MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='false' and $result4='true' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns123MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='true' and $result4='false' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns1245MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='true' and $result4='false' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns124MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='true' and $result4='true' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns125MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='false' and $result3='true' and $result4='true' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns12MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='false' and $result4='false' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns1345MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='false' and $result4='false' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns134MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='false' and $result4='true' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns135MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='false' and $result4='true' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns13MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='true' and $result4='false' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns145MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='true' and $result4='false' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns14MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='true' and $result4='true' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns15MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='false' and $result2='true' and $result3='true' and $result4='true' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns1MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='false' and $result4='false' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns2345MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='false' and $result4='false' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns234MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='false' and $result4='true' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns235MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='false' and $result4='true' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns23MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='true' and $result4='false' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns245MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='true' and $result4='false' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns24MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='true' and $result4='true' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns25MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='false' and $result3='true' and $result4='true' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns2MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='true' and $result3='false' and $result4='false' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns345MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='true' and $result3='false' and $result4='false' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns34MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='true' and $result3='false' and $result4='true' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns35MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='true' and $result3='false' and $result4='true' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns3MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='true' and $result3='true' and $result4='false' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns45MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='true' and $result3='true' and $result4='false' and $result5='true'">
                <xsl:text>com.mcafee.pa.msg.Patterns4MissingSCAP</xsl:text>
              </xsl:when>
              
              <xsl:when test="$fileTestResult='true' and $result1='true' and $result2='true' and $result3='true' and $result4='true' and $result5='false'">
                <xsl:text>com.mcafee.pa.msg.Patterns5MissingSCAP</xsl:text>
              </xsl:when>
            </xsl:choose>
          </xsl:if>    
   </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">textfilePattern1</xsl:attribute>
          <xsl:value-of select="$textfilePattern1"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">textfilePattern2</xsl:attribute>
          <xsl:value-of select="$textfilePattern2"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">textfilePattern3</xsl:attribute>
          <xsl:value-of select="$textfilePattern3"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">textfilePattern4</xsl:attribute>
          <xsl:value-of select="$textfilePattern4"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">textfilePattern5</xsl:attribute>
          <xsl:value-of select="$textfilePattern5"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">file_info</xsl:attribute>
          <xsl:value-of select="$fileInfo"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>

