<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
  xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
  xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
  xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
  xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
  xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
  exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
  <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

  <!-- This library is to handle the OVAL checks with the text file test.
         Text file test verifies if a specific pattern of text is not present in the configuration file/files in specific path.
         This is the modified version of LinuxConfigTextFileCont54PatMatchChecks.xsl
          
          <criteria operator="AND">
            <criterion comment="Test to verify that dccp is disabled." test_ref="oval:com.mcafee.oval:tst:402668"/> - textfilecontent54_test
          </criteria>
          
          without external variable & OVAL State.
          
          Ex. OVAL ID - oval:com.mcafee.oval:def:402664
  -->

  <xsl:param name="defid" />
  <xsl:template match="/">
    <xsl:call-template name="getFindings">
      <xsl:with-param name="definitionId" select="$defid"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="getFindings">
    <xsl:param name="definitionId"/>
    <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
    
    
    <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
    <xsl:variable name="fileContentTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test/@id"/>
    <xsl:variable name="textfileContRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id]/@result"/>
    
    <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
    <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
    <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
    
    <xsl:variable name="definitionTextFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[@id=$fileContentTest_id]"/>
    <xsl:variable name="textfilePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:path/text()" />
    
    <xsl:variable name="textfilePattern" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/ind-def:textfilecontent54_object[@id=$definitionTextFileTest/ind-def:object/@object_ref]/ind-def:pattern/text()" />
    
    <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
    
    <xsl:variable name="isViolationValue">
      <xsl:choose>
        <xsl:when test="$result = 'false' ">
          <xsl:text>true</xsl:text>
        </xsl:when>
        <xsl:when test="$result = 'true' ">
          <xsl:text>false</xsl:text>
        </xsl:when>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="message_id">
      <xsl:choose>
        <xsl:when test="$textfileContRes='true' ">
          <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
        </xsl:when>
        <xsl:when test="$textfileContRes='false' ">
          <xsl:text>com.mcafee.pa.msg.PatMatFilesUndDirSCAP</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>com.mcafee.pa.msg.configNotSet</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    
    <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
      <xsl:attribute name="id">
        <xsl:value-of select="$definitionId"/>
      </xsl:attribute>
      <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
        <xsl:attribute name="messageId">
          <xsl:value-of select="$message_id"/>
        </xsl:attribute>
        <xsl:attribute name="isViolation">
          <xsl:value-of select="$isViolationValue"/>
        </xsl:attribute>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">config_name</xsl:attribute>
          <xsl:value-of select="$title"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">pattern</xsl:attribute>
          <xsl:value-of select="$textfilePattern"/>
        </xsl:element>
        <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
          <xsl:attribute name="key">dir_info</xsl:attribute>
          <xsl:value-of select="$textfilePath"/>
        </xsl:element>
      </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>

