<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is to verify if all the defined user home directories exist on the system.
        
        <criteria operator="OR">
            <criterion comment="Test for the existence of non-system accounts." negate="true" test_ref="oval:com.mcafee.oval:tst:246563"/>
            <criterion comment="Test for the existence of user home directories." test_ref="oval:com.mcafee.oval:tst:246564"/>
        </criteria>
        
       Test Cases:
            1. Final Result is Pass - All the user home directories defined exist on the system.
            2. Final Result is Fail - One or more user home directories do not exist on the system.
            
            Ex. OVAL ID - oval:com.mcafee.oval:def:246562
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>

 
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="homeDirList">
            <xsl:variable name="OvalResult"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="Tests"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
            
            <xsl:variable name="tests">
                <xsl:for-each
                    select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/unix-def:file_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>fileTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="TestedItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fileTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
              
              <xsl:variable name="userWithhomeDir">
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                    <xsl:variable name="itemId" select="@item_id"/>
                    <xsl:variable name="TestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemId]" />
                 
                    <xsl:for-each select="$TestItem">
                        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemId]/unix-sc:path/text()"/>  
                        <xsl:if test="@status!='does not exist' or not(@status)">
                            <xsl:value-of select="concat($filePath,'    ')"/>
                        </xsl:if>
                    </xsl:for-each>
               </xsl:for-each>
              </xsl:variable>
                
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                    <xsl:variable name="itemId" select="@item_id"/>
                    <xsl:variable name="TestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemId]" />
                  
                    <xsl:for-each select="$TestItem">
                        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemId]/unix-sc:path/text()"/>  
                        <xsl:if test="@status='does not exist' and not(contains($userWithhomeDir,$filePath))">
                            <xsl:value-of select="concat($filePath,'  |  ')"/>
                        </xsl:if>
                    </xsl:for-each>     
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>

        <xsl:variable name="title">
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:text>com.mcafee.pa.msg.UserHomeDirListSCAP</xsl:text>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">home_dir_list</xsl:attribute>
                    <xsl:value-of select="$homeDirList"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>