<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    
    <!-- XSL for handling a single file test for file user and group ownership -->
    
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <xsl:template name="fileOwnerGroupDefinition">
        <xsl:param name="definition_id"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <findings xmlns="http://results.pa.mcafee.com/findings/5.2" id="{$definition_id}">
                <xsl:variable name="test_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="fileOwnerGroupTest">
                        <xsl:with-param name="test_Id" select="$test_id"/>
                </xsl:call-template>
            </findings>
        </xsl:if>
    </xsl:template>
    <xsl:template name="fileOwnerGroupTest">
        <xsl:param name="test_Id"/>
        <xsl:variable name="state_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$test_Id]/unix-def:state/@state_ref"/>
        <xsl:variable name="state"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:file_state[@id=$state_id]"/>
        <xsl:variable name="obj_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$test_Id]/unix-def:object/@object_ref"/>
        <xsl:variable name="object"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$obj_id]"/>
        <xsl:variable name="path" select="$object/unix-def:path/text()"/>
        <xsl:variable name="filename" select="$object/unix-def:filename"/>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">filename</xsl:attribute>
            <xsl:call-template name="combinePaths">
                <xsl:with-param name="first" select="$path" />
                <xsl:with-param name="second" select="$filename" />
            </xsl:call-template>
        </xsl:element>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">group_id</xsl:attribute>
            <xsl:value-of select="$state/unix-def:group_id/text()"/>
        </xsl:element>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">user_id</xsl:attribute>
            <xsl:value-of select="$state/unix-def:user_id/text()"/>
        </xsl:element>
        
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='false' or @result='not evaluated']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$item_id]"/>
            <xsl:variable name="status" select="$item/@status"/>
            <xsl:choose>
                <xsl:when test="$item/@status='does not exist'">
                    <!-- Message  'The file ##filename## does not exist.' -->
                    <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.unixfile0" isViolation="true">
                    </finding>
                </xsl:when>
                <xsl:when test="not($item/@status)">
                    <!-- Message  'The file ##filename## should belong to GID ##group_id## and UID ##user_id##, belongs to GID %%group_id%% and UID  %%user_id%%-->
                    <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.unixfile4" isViolation="true">
                        <actualValue xmlns="http://results.pa.mcafee.com/findings/5.2" key="group_id"><xsl:value-of select="$item/unix-sc:group_id/text()"/></actualValue>
                        <actualValue xmlns="http://results.pa.mcafee.com/findings/5.2" key="user_id"><xsl:value-of select="$item/unix-sc:user_id/text()"/></actualValue>
                    </finding>
                </xsl:when>
               
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:include href="unixUtils.xsl"/>
</xsl:stylesheet>

