<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <xsl:template name="filePermissionDefinition">
        <xsl:param name="definition_id"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="id"><xsl:value-of select="$definition_id"/></xsl:attribute>
                <xsl:variable name="test_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="filePermissionTest">
                    <xsl:with-param name="test_Id" select="$test_id"/>
                </xsl:call-template>
            </xsl:element>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="dualFilePerm">
        <xsl:param name="definition_id"/>
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <xsl:variable name="def"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]"/>
            <xsl:variable name="filePermId">
                <xsl:choose>
                    <xsl:when
                        test="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$def//oval-res:criterion[1]/@test_ref and @check='all']">
                        <xsl:value-of select="$def//oval-res:criterion[1]/@test_ref"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$def//oval-res:criterion[2]/@test_ref"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="id">
                    <xsl:value-of select="$definition_id"/>
                </xsl:attribute>
                <xsl:variable name="test_id"
                    select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="filePermissionTest">
                    <xsl:with-param name="test_Id" select="$filePermId"/>
                </xsl:call-template>
            </xsl:element>
        </xsl:if>
    </xsl:template>
    
    
    
    <xsl:template name="filePermissionTest">
        <xsl:param name="test_Id"/>
        <xsl:variable name="state_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$test_Id]/unix-def:state/@state_ref"/>
        <xsl:variable name="state"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:file_state[@id=$state_id]"/>
        <xsl:variable name="obj_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$test_Id]/unix-def:object/@object_ref"/>
        <xsl:variable name="object"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$obj_id]"/>
        <xsl:variable name="path" select="$object/unix-def:path/text()"/>
        <xsl:variable name="filename" select="$object/unix-def:filename"/>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">filename</xsl:attribute>
            <xsl:call-template name="combinePaths">
                <xsl:with-param name="first" select="$path" />
                <xsl:with-param name="second" select="$filename" />
            </xsl:call-template>
        </xsl:element>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">permissions</xsl:attribute>
            <xsl:call-template name="writePerms">
                <xsl:with-param name="read" select="$state/unix-def:uread/text()"/>
                <xsl:with-param name="write" select="$state/unix-def:uwrite/text()"/>
                <xsl:with-param name="exec" select="$state/unix-def:uexec/text()"/>
            </xsl:call-template>
            <xsl:call-template name="writePerms">
                <xsl:with-param name="read" select="$state/unix-def:gread/text()"/>
                <xsl:with-param name="write" select="$state/unix-def:gwrite/text()"/>
                <xsl:with-param name="exec" select="$state/unix-def:gexec/text()"/>
            </xsl:call-template>
            <xsl:call-template name="writePerms">
                <xsl:with-param name="read" select="$state/unix-def:oread/text()"/>
                <xsl:with-param name="write" select="$state/unix-def:owrite/text()"/>
                <xsl:with-param name="exec" select="$state/unix-def:oexec/text()"/>
            </xsl:call-template>
        </xsl:element>
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='false' or @result='not evaluated']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$item_id]"/>
            <xsl:variable name="status" select="$item/@status"/>
            <xsl:choose>
                <xsl:when test="$item/@status='does not exist'">
                    <!-- Message 'The file ##filename## does not exist.' -->
                    <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                        <xsl:attribute name="messageId">com.mcafee.pa.msg.unixfile0</xsl:attribute>
                        <xsl:attribute name="isViolation">true</xsl:attribute>
                    </xsl:element>
                </xsl:when>
                
                <xsl:when test="(not($item/@status)) or ($item/@status='exists')">
                    <!-- Message 'The file ##filename## has permissions %%permissions%%, should have permissions ##permissions##. -->
                    <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
                        <xsl:attribute name="messageId">com.mcafee.pa.msg.unixfile1</xsl:attribute>
                        <xsl:attribute name="isViolation">true</xsl:attribute>
                    
                        <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="actualValue">
                            <xsl:attribute name="key">permissions</xsl:attribute>
                            <xsl:call-template name="writePerms">
                                <xsl:with-param name="read" select="$item/unix-sc:uread/text()"/>
                                <xsl:with-param name="write" select="$item/unix-sc:uwrite/text()"/>
                                <xsl:with-param name="exec" select="$item/unix-sc:uexec/text()"/>
                            </xsl:call-template>
                            <xsl:call-template name="writePerms">
                                <xsl:with-param name="read" select="$item/unix-sc:gread/text()"/>
                                <xsl:with-param name="write" select="$item/unix-sc:gwrite/text()"/>
                                <xsl:with-param name="exec" select="$item/unix-sc:gexec/text()"/>
                            </xsl:call-template>
                            <xsl:call-template name="writePerms">
                                <xsl:with-param name="read" select="$item/unix-sc:oread/text()"/>
                                <xsl:with-param name="write" select="$item/unix-sc:owrite/text()"/>
                                <xsl:with-param name="exec" select="$item/unix-sc:oexec/text()"/>
                            </xsl:call-template>
                        </xsl:element>
                    </xsl:element>
                </xsl:when>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    <xsl:include href="unixUtils.xsl"/>
</xsl:stylesheet>

