<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        
        This XSL is apply to the definition which are made to check whether a installed 
        software meets  the minimum or maximum version requirement. 
        
        Software name will be get from the title. 
        title should start with software name as below. 
        
        <software name> Security Update ...
        
         Criteria (and)
                  Criterion :  File test  ( Check Software file  version)
                  Criterion :  File test  ( Check Software file  version)
    -->
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
    
    <xsl:template name="getSoftwareNameFromTitle">
        <xsl:param name="title"/>
        
         <xsl:variable name="software">
             <xsl:if test="contains($title, 'Security Update' )">
                 <xsl:value-of select="substring-before($title, 'Security' )"/>
             </xsl:if>
         </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$software != '' ">
                <xsl:value-of select="$software"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="definitionIdWithoutCommon">
            <xsl:if test="contains($definitionId, '.common' )">
            <xsl:value-of select="concat(substring-before($definitionId, '.common'), substring-after($definitionId, '.common'))"/>
            </xsl:if>
            <xsl:if test="not(contains($definitionId, '.common' ))">
                <xsl:value-of select="$definitionId"/>
                </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionIdWithoutCommon]/@result"/>
        <xsl:call-template name="winSoftwareVersionCheck">
            <xsl:with-param name="definitionId" select="$definitionIdWithoutCommon"/>
            <xsl:with-param name="def_result" select="$result"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="winSoftwareVersionCheck">
        <xsl:param name="definitionId"/>       
        <xsl:param name="def_result"/>
        
         
         <xsl:variable name="title">
	<xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
                
        <xsl:variable name="software">
            <xsl:call-template name="getSoftwareNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
       
        <xsl:variable name="tests">        
            <xsl:for-each select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                
                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:file_test[@id=$test]">
                    <xsl:variable name="state"  select="$Tests/win-def:file_test[@id=$test]/win-def:state/@state_ref"/>
                    <xsl:if test="$States/win-def:file_state[@id=$state]/win-def:version/@operation='less than'">
                        
                        <xsl:variable name="versionnode" select="name($States/win-def:file_state[@id=$state]/win-def:version)"/>
                        <xsl:variable name="externalVar" select="$States/win-def:file_state[@id=$state]/win-def:version"/>
                        
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="versionnodename">
                                <xsl:value-of select="$versionnode"/>
                            </xsl:attribute>
                            <xsl:attribute name="externalVar">
                                <xsl:value-of select="$externalVar"/>
                            </xsl:attribute>
                            
                            <xsl:attribute name="testtype">
                                <xsl:text>file</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
           </xsl:if>
            </xsl:for-each>                        
        </xsl:variable>
            
               <xsl:if test="$def_result = 'false' ">
                   
                   <xsl:variable name="result1"
                       select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
                   <xsl:variable name="result2"
                       select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
                   
                   <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                       <xsl:choose>
                           <xsl:when test="$result1='false' and $result2='false'">
                               <finding messageId="com.mcafee.pa.msg.winNoSoftwareVersionCheck_crd_MNAC" isViolation="false">
                               <instanceValue key="software">
                                   <xsl:value-of select="$software"/>                                                    
                               </instanceValue>
                           </finding>
                           </xsl:when>
                           <xsl:otherwise>
                       <xsl:for-each select="xalan:nodeset($tests)/descendant::test">
                  <xsl:choose>
                      <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'file']">
                          
                          <xsl:variable name="test" select="@id"/>
                          <xsl:variable name="versionnode" select="@versionnode"/>
                          <xsl:variable name="externalVarId" select="@externalVar"/>
                          
                          <xsl:variable name="inputVersion" 
                              select="$externalVarId"/>
                          
                          <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                              
                              <xsl:variable name="itemRef" select="@item_id"/>
                              
                              <xsl:variable name="version">
                                    <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                              </xsl:variable>
                              <xsl:variable name="message_id">
                                  <xsl:choose>
                                              <xsl:when test="$result1='true' and $result2='false'">
                                                  <xsl:text>com.mcafee.pa.msg.winSoftwareVersionCheck_crd_MNAC</xsl:text>
                                              </xsl:when>
                                      
                                              <xsl:when test="$result1='false' and $result2='true'">
                                                  <xsl:text>com.mcafee.pa.msg.winSoftwareVersionCheck_crd_NA_MNAC</xsl:text>
                                              </xsl:when>
                                    </xsl:choose>                                   
                              </xsl:variable>
                              
                              <finding messageId="{$message_id}" isViolation="false">
                                  <instanceValue key="software">
                                      <xsl:value-of select="$software"/>                                                    
                                  </instanceValue>   
                                  <instanceValue key="inputVersion">
                                      <xsl:value-of select="$inputVersion"/>                                                    
                                  </instanceValue>
                                 <actualValue key="actualVersion">
                                      <xsl:value-of select="$version"/>                                                    
                                  </actualValue>
                              </finding>
                          </xsl:for-each>
                      </xsl:when>
                  </xsl:choose>
                       </xsl:for-each>
                           </xsl:otherwise>
                           </xsl:choose>
                </findings>
             </xsl:if>
        
        
            <xsl:if test="$def_result = 'true' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                       <xsl:for-each select="xalan:nodeset($tests)/descendant::test">
                            <xsl:choose>
                        <xsl:when test="xalan:nodeset($tests)/descendant::test[ @testtype = 'file' ]">
                        <xsl:variable name="test" select="@id"/>
                        <xsl:variable name="versionnode" select="@versionnode"/>
                        <xsl:variable name="externalVarId" select="@externalVar"/>
                        
                        <xsl:variable name="inputVersion" 
                            select="$externalVarId"/>
                        
                        
                        <xsl:for-each  select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true' ] ">
                            
                            <xsl:variable name="itemRef" select="@item_id"/>
                            <xsl:variable name="result" select="@result"/>
                            
                            <xsl:variable name="path" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:path"/>
                            <xsl:variable name="file" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename"/>
                            <xsl:variable name="fileStatus" select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:filename/@status"/>
                            
                            <xsl:variable name="version">
                                 <xsl:value-of select="$SystemData/win-sc:file_item[@id=$itemRef]/win-sc:version"/>
                           </xsl:variable>
                            <xsl:variable name="message_id">
                                    <xsl:text>com.mcafee.pa.msg.winSoftwareVersionCheck_crd_MNAC</xsl:text>          
                            </xsl:variable>
                            
                            <finding messageId="{$message_id}" isViolation="true">
                                <instanceValue key="software">
                                    <xsl:value-of select="$software"/>                                                    
                                </instanceValue>   
                                <instanceValue key="inputVersion">
                                    <xsl:value-of select="$inputVersion"/>                                                    
                                </instanceValue>
                                <actualValue key="actualVersion">
                                    <xsl:value-of select="$version"/>                                                    
                                </actualValue>
                            </finding>
                        </xsl:for-each>
                    </xsl:when>
                            </xsl:choose>
                        </xsl:for-each>
                </findings>
            </xsl:if>
    </xsl:template>
</xsl:stylesheet>