<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    >
    
    <!--
        This library works for the below logic :-
        
        <criteria>
            <criteria operator="AND">
                <criterion comment="SYSTEMROOT/System32/posix.exe exists" negate="true" test_ref="oval:com.mcafee.oval.windows:tst:478"/> - File existence test
                <criterion comment="SYSTEMROOT/System32/psxdll.dll exists" negate="true" test_ref="oval:com.mcafee.oval.windows:tst:479"/> - File existence test
                <criterion comment="SYSTEMROOT/System32/psxss.exe exists" negate="true" test_ref="oval:com.mcafee.oval.windows:tst:480"/> - File existence test
            </criteria>
        </criteria>
     
     Ex: - oval:com.mcafee.oval.windows:def:229
     
     No external variable.
    -->
      
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="result1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        
        <xsl:variable name="title">
             <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
       
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
        
        <xsl:variable name="filePath">
            <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test/oval-res:tested_variable/text()"/>
        </xsl:variable>
        
        <xsl:variable name="fileName1">
            <xsl:value-of select="concat($filePath,'\',/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/win-def:file_object[1]/win-def:filename/text())"/>
        </xsl:variable>
        
        <xsl:variable name="fileName2">
            <xsl:value-of select="concat($filePath,'\',/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/win-def:file_object[2]/win-def:filename/text())"/>
        </xsl:variable>
        
        <xsl:variable name="fileName3">
            <xsl:value-of select="concat($filePath,'\',/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/win-def:file_object[3]/win-def:filename/text())"/>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:choose>
                <xsl:when test="$result='true'">
                    <xsl:text>com.mcafee.pa.msg.winConfigPosixAllFiles_SCAP</xsl:text>
                </xsl:when>
                <xsl:when test="$result1='false' and $result2='false' and $result3='false'">
                    <xsl:text>com.mcafee.pa.msg.winConfigPosixAllFiles_SCAP</xsl:text>
                </xsl:when>
                <xsl:when test="$result1='false' and $result2='false' and $result3='true'">
                    <xsl:text>com.mcafee.pa.msg.winConfigPosixFiles12_SCAP</xsl:text>
                </xsl:when>
                <xsl:when test="$result1='false' and $result2='true' and $result3='true'">
                    <xsl:text>com.mcafee.pa.msg.winConfigPosixFile1_SCAP</xsl:text>
                </xsl:when>
                <xsl:when test="$result1='true' and $result2='false' and $result3='false'">
                    <xsl:text>com.mcafee.pa.msg.winConfigPosixFiles23_SCAP</xsl:text>
                </xsl:when>
                <xsl:when test="$result1='true' and $result2='true' and $result3='false'">
                    <xsl:text>com.mcafee.pa.msg.winConfigPosixFile3_SCAP</xsl:text>
                </xsl:when>
                <xsl:when test="$result1='false' and $result2='true' and $result3='false'">
                    <xsl:text>com.mcafee.pa.msg.winConfigPosixFiles13_SCAP</xsl:text>
                </xsl:when>
                <xsl:when test="$result1='true' and $result2='false' and $result3='true'">
                    <xsl:text>com.mcafee.pa.msg.winConfigPosixFile2_SCAP</xsl:text>
                </xsl:when>
            </xsl:choose>
            
        </xsl:variable>    
            
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">                                                            
                   <instanceValue key="config">
                         <xsl:value-of select="$title"/>
                   </instanceValue>
                <instanceValue key="file1">
                    <xsl:value-of select="$fileName1"/>
                </instanceValue>
                  <instanceValue key="file2">
                    <xsl:value-of select="$fileName2"/>
                  </instanceValue>
                 <instanceValue key="file3">
                    <xsl:value-of select="$fileName3"/>
                </instanceValue>
           </finding>
        </findings>
</xsl:template>
</xsl:stylesheet>