#!/bin/sh
logfile=/var/McAfee/agent/logs/msgbus_cert_updater.log
CURRENT_DIR=$(dirname $0)
current_time=$(date "+%Y.%m.%d-%H.%M.%S")
if [ -f $logfile ] ; then
	mv $logfile /var/McAfee/agent/logs/msgbus_cert_updater_backup.log
fi
echo "start:-------------------------------------- "$current_time >> $logfile 2>&1
platform=`uname -m`
echo "platform is: $platform" >> $logfile 2>&1 
echo "CURRENT_DIR is: $CURRENT_DIR" >> $logfile	2>&1
BIN_PATH="$CURRENT_DIR/mac"
chmod +x $BIN_PATH/ma_updater
 
v=`sed -n -e 's/.*<Version>\(.*\)<\/Version>.*/\1/p' /etc/ma.d/EPOAGENT3000/config.xml`
 
echo "Installed MA version is $v" >> $logfile 2>&1
agent_major_version=`echo $v | cut -d. -f1`
agent_minor_version=`echo $v | cut -d. -f2`
agent_patch_version=`echo $v | cut -d. -f3`
 
installed_agent_version=$(( $agent_major_version*65536 + $agent_minor_version*256 + $agent_patch_version ))
THIS_MAJOR=5
THIS_MINOR=7
THIS_PATCH=9
THIS_AGENT_VERSION=$(( $THIS_MAJOR*65536 + $THIS_MINOR*256 + $THIS_PATCH ))
echo "THIS_AGENT_VERSION: $THIS_AGENT_VERSION" >> $logfile 2>&1
echo "installed_agent_version: $installed_agent_version" >> $logfile 2>&1
 
if [ $THIS_AGENT_VERSION -eq $installed_agent_version ]; then
	echo "Version is 579, so creating softlinks." >> $logfile 2>&1
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_utils.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_utils.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_utils.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/rsdk/libma_logger.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/rsdk/libma_logger.5.7.dylib /Library/McAfee/agent/lib/lib64/rsdk/libma_logger.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_configurator.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_configurator.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_configurator.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_database.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_database.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_database.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_datastore.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_datastore.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_datastore.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_repository.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_repository.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_repository.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/rsdk/libma_variant.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/rsdk/libma_variant.5.7.dylib /Library/McAfee/agent/lib/lib64/rsdk/libma_variant.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_xml.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_xml.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_xml.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_serialization.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_serialization.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_serialization.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/rsdk/libma_client.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/rsdk/libma_client.5.7.dylib /Library/McAfee/agent/lib/lib64/rsdk/libma_client.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/rsdk/libma_msgbus.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/rsdk/libma_msgbus.5.7.dylib /Library/McAfee/agent/lib/lib64/rsdk/libma_msgbus.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_network.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_network.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_network.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/rsdk/libma_crypto.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/rsdk/libma_crypto.5.7.dylib /Library/McAfee/agent/lib/lib64/rsdk/libma_crypto.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/libma_proxy.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/libma_proxy.5.7.dylib /Library/McAfee/agent/lib/lib64/libma_proxy.5.8.dylib
	fi
	if [ ! -f /Library/McAfee/agent/lib/lib64/tools/libmfecryptc.5.8.dylib ] ; then
		ln -sf /Library/McAfee/agent/lib/lib64/tools/libmfecryptc.5.7.dylib /Library/McAfee/agent/lib/lib64/tools/libmfecryptc.5.8.dylib
	fi
fi

if [ -f $BIN_PATH/libcurl.4.dylib  ] ; then
	cp $BIN_PATH/libcurl.4.dylib /Library/McAfee/agent/bin
fi

echo "ma_updater start to run on mac" >> $logfile	2>&1
$BIN_PATH/ma_updater -update_iam_trellix_url -logdir /var/McAfee/agent/logs >> $logfile 2>&1
ret_code=$?
if [ $THIS_AGENT_VERSION -eq $installed_agent_version ]; then
	echo "Version is 579, so removing softlinks." >> $logfile 2>&1
	rm -rf /Library/McAfee/agent/lib/lib64/libma_utils.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/rsdk/libma_logger.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/libma_configurator.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/libma_database.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/libma_datastore.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/libma_repository.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/rsdk/libma_variant.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/libma_xml.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/libma_serialization.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/rsdk/libma_client.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/rsdk/libma_msgbus.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/libma_network.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/rsdk/libma_crypto.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/libma_proxy.5.8.dylib
	rm -rf /Library/McAfee/agent/lib/lib64/tools/libmfecryptc.5.8.dylib
fi
if [ -f /Library/McAfee/agent/bin/libcurl.4.dylib  ] ; then
	rm -rf  /Library/McAfee/agent/bin/libcurl.4.dylib
fi
echo "ret_code is from mac: $ret_code" >> $logfile	2>&1