<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is to verify if the presence of user dot files files in the user home directories.
        
        <criteria operator="AND">
        <criterion comment="Ensure that .netrc files does not exists in any users home directories" test_ref="oval:com.mcafee.oval:tst:215233" /> - File test
        </criteria>
        
       Test Cases:
            1. Final Result is Pass - There are no user dot files in the user home directories.
            2. Final Result is Fail - One or more user home directories have user dot files.
            
            Ex. OVAL ID - oval:com.mcafee.oval:def:215232
                                     oval:com.mcafee.oval:def:215228
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
   
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="definitionFileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
        <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$definitionFileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
            
            <xsl:variable name="OvalResult"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="Tests"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
            
            <xsl:variable name="tests">
                <xsl:for-each
                    select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/unix-def:file_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>fileTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="TestedItems"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    
            <xsl:variable name="apos"> ' </xsl:variable>
        
      <xsl:variable name="slashPath">
        <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fileTest' ]">
            <xsl:variable name="test" select="@id"/>
            <xsl:variable name="type" select="@type"/>
            
            <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                <xsl:variable name="itemRef" select="@item_id"/>
                <xsl:variable name="fileTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemRef]" />
                 <xsl:if test="not($fileTestItem/@status)">
                      <xsl:if test="not($fileTestItem/unix-sc:path/text())">
                          <xsl:text>/</xsl:text>
                      </xsl:if>
                  </xsl:if>  
            </xsl:for-each>
        </xsl:for-each>
      </xsl:variable>
        <xsl:variable name="filePath">
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fileTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item">
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="fileTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$itemRef]" />
                    <xsl:if test="not($fileTestItem/@status)">
                        <xsl:if test="$fileTestItem/unix-sc:path/text()!=''">
                            <xsl:value-of select="concat($apos,'',$fileTestItem/unix-sc:path/text(),'',$apos,'  ')"/>   
                        </xsl:if>
                    </xsl:if>  
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>    
        
        <xsl:variable name="filePathList">
            <xsl:choose>
                <xsl:when test="$slashPath!='' and $filePath!=''">
                    <xsl:value-of select="concat($filePath,$apos,'/',$apos)"/>
                </xsl:when>
                <xsl:when test="$slashPath='' and $filePath!=''">
                    <xsl:value-of select="concat($filePath,'   ')"/>
                </xsl:when>
                <xsl:when test="$slashPath!='' and $filePath=''">
                    <xsl:value-of select="concat($apos,'/',$apos)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$filePath"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:variable name="title">
            <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:text>com.mcafee.pa.msg.UserDotFileExistSCAP</xsl:text>
            </xsl:if>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_path_list</xsl:attribute>
                    <xsl:value-of select="$filePathList"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">file_name</xsl:attribute>
                    <xsl:value-of select="$fileName"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>