﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
<!--  FILENAME: winFilePermissionCheck_1.xsl         DATE: 29th Aug, 2011     AUTHOR: Nandini NR   -->
<!--  MAPPINGFILE: winFilePermissionCheck_1_xsl.txt    -->
    
    <!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECKS TO TEST FOR FILE/FOLDER PERMISSIONS  for the Accounts: Administrators, SYSTEM, INTERACTIVE -->
    
<!-- FOLLOWING ARE SOME OF THE ASSUMPTIONS TAKEN IN THE LOGIC FOR THE LIBRARY  -->
   <!--   1. Filename is being extracted from title only. So string after “Permissions:” and before”-“ would be extracted as file name.
            2. There are total 25 test cases.        
   -->

    <!-- Function to extract File/Folder Name from Title -->
    <!-- String after “Permissions:” and before”-“ would be extracted as file name. -->
    <xsl:template name="getFileNameFromTitle">
        <xsl:param name="title"/>
        
        <xsl:variable name="fileName">
            <xsl:if test="contains($title, 'Permissions:' )">
                <xsl:value-of select="substring-before(substring-after($title, 'Permissions:' ), '-')"/>
            </xsl:if>          
        </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$fileName != '' ">
                <xsl:value-of select="$fileName"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="result1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        <xsl:variable name="result6"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[6]/@result"/>
        <xsl:variable name="result7"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[7]/@result"/>
        <xsl:variable name="result8"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[8]/@result"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:choose>
                        
                        <xsl:when test="$result7 = 'false' ">
                            <xsl:choose>
                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false' and $result4 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_all_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_no_Interactive_MNAC</xsl:text>
                                </xsl:when>
		    
                                <!-- Result is pass even when user input is NO for INTERACTIVE account and permissions are set correctly for INTERACTIVE account -->
		   <xsl:when test="$result5 = 'true' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false' and $result4 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_all_Interactive_MNAC</xsl:text>
                                </xsl:when>
	                 
                                <!-- This is same as first one in the loop except the last result check in case first one is missed out. This is an extra test case. -->
		 <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_all_MNAC</xsl:text>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:when>
                        
                        <!-- =================================================== -->
                        
                        
                        <xsl:when test="$result7 = 'true' ">
                            <xsl:choose>
                                <xsl:when test="$result5 = 'true' and $result8 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileDoesNotExist</xsl:text>                                    
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false' and $result4 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_all_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_no_Interactive_MNAC</xsl:text>
                                </xsl:when>
                                
                                <!-- Result is pass even when user input is NO for INTERACTIVE account and permissions are set correctly for INTERACTIVE account -->
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false' and $result4 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_all_Interactive_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'false' and $result8 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileDoesNotExist</xsl:text>                                    
                                </xsl:when>
                            </xsl:choose>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
                
                <!-- Check if result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                    <xsl:choose>
                        <xsl:when test="$result7 = 'false' ">
                            <xsl:choose>
                                <xsl:when test="$result5 = 'false' and $result8 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileDoesNotExist</xsl:text>                                    
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileDoesNotExist</xsl:text>                                    
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and ($result1 = 'false' or $result2 = 'false')">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_AdmSys_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result3 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_Others_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_no_Interactive_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false' and $result4 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_no_Interactive_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and ($result1 = 'false' or $result2 = 'false')">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_AdmSys_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and $result3 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_Others_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false' and $result4 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_all_Interactive_MNAC</xsl:text>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:when>
                        
                        <!-- =================================================== -->
                        
                        <xsl:when test="$result7 = 'true' ">
                            <xsl:choose>
                                
                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and ($result1 = 'false' or $result2 = 'false')">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_AdmSys_MNAC</xsl:text>
                                </xsl:when>

                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result3 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_Others_MNAC</xsl:text>
                                </xsl:when>

                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'true'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_no_Interactive_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'false' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false' and $result4 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_no_Interactive_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and ($result1 = 'false' or $result2 = 'false')">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_AdmSys_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and $result3 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_Others_MNAC</xsl:text>
                                </xsl:when>
                                
                                <xsl:when test="$result5 = 'true' and $result8 = 'false' and $result1 = 'true' and $result2 = 'true' and $result3 = 'true' and $result6 = 'false' and $result4 = 'false'">
                                    <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions_no_Interactive_MNAC</xsl:text>
                                </xsl:when>
                            </xsl:choose>
                        </xsl:when>
                        
                    </xsl:choose>
                </xsl:if>
  
            </xsl:variable>
            
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Extract File/Folder Name from Title ........................................................................................... -->
        <xsl:variable name="fileName">
            <xsl:call-template name="getFileNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="fileName">
                    <xsl:value-of select="$fileName"/>                                                    
                </instanceValue>               
            </finding>
        </findings>
  
      
    </xsl:template>
</xsl:stylesheet>
