<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="getServiceNameFromTitle">
        <xsl:param name="title"/>
        <xsl:variable name="titleServiceName">
            <xsl:if test="contains($title, 'Boot service' )">
                 <xsl:value-of select="substring-after($title, 'Boot service - ')"/>
            </xsl:if>
            <xsl:if test="contains($title, 'Service - ' )">
                <xsl:value-of select="substring-after($title, 'Service - ')"/>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="serviceName"> 
            <xsl:value-of select="substring-before($titleServiceName, ' - running state')"/>
            <xsl:if test="contains($titleServiceName, 'status' )">
                <xsl:value-of select="substring-before($titleServiceName, ' - status')"/>
            </xsl:if>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$serviceName != '' ">
                <xsl:value-of select="$serviceName"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect service name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
       <!-- Collect all results for the criterias in the variables ......................................... --> 
        <xsl:variable name="test_id1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@test_ref"/>
        <xsl:variable name="test_id2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@test_ref"/>
        <xsl:variable name="test_id3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@test_ref"/>
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        
        <xsl:variable name="item_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_id1]/oval-res:tested_item/@item_id"/>
        <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:runlevel_item[@id=$item_id]"/>
        <xsl:variable name="sysRunLevel" select="$item/unix-sc:runlevel/text()"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="$result1 = 'false' and $result2 = 'false' and $result3 = 'true'">
                        <xsl:text>com.mcafee.pa.msg.linuxServiceRunLevelVarEnabled</xsl:text>
                    </xsl:when>    
                    <xsl:when test="$result1 = 'false' and $result2 = 'true' and $result3 = 'true'">
                        <xsl:text>com.mcafee.pa.msg.linuxServiceRunLevelVarDisabled</xsl:text>
                    </xsl:when> 
                    <xsl:when test="$result1 = 'true' and $result2 = 'true' and $result3 = 'false'">
                        <xsl:text>com.mcafee.pa.msg.serviceDoesNotExists</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>            
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$result1 = 'false' and $result2 = 'false'  and $result3 = 'false'">
                        <xsl:text>com.mcafee.pa.msg.linuxServiceRunLevelVarEnabled</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1 = 'false' and $result2 = 'true' and $result3 = 'false'">
                        <xsl:text>com.mcafee.pa.msg.linuxServiceRunLevelVarDisabled</xsl:text>
                    </xsl:when>
                    <xsl:when test="$result1 = 'true' and $result2 = 'false' and $result3 = 'false'">
                        <xsl:text>com.mcafee.pa.msg.serviceDoesNotExists</xsl:text>
                    </xsl:when>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="serviceName">
            <xsl:call-template name="getServiceNameFromTitle">
                <xsl:with-param name="title" select="$title"/>
            </xsl:call-template>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>                
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">service_name</xsl:attribute>
                    <xsl:value-of select="$serviceName"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">system_runlevel</xsl:attribute>
                    <xsl:value-of select="$sysRunLevel"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>        
        
    </xsl:template>
</xsl:stylesheet>            