<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan">

    <!--
        Criteria (and)
            Criteria ( or ) :  optional 
                 Criterion : Registry test ( Check Software is installed )
                ...one or more
                // registry test might not be exist
             Crteria ( or ) : optional 
                Criterion : wmi test ( Check Software service running status )
                ...one or more
                // wmi test is manadatory

        Apply this XSL on the definition where we want to check whthere perticular
        software is enabled/running or not. 
    
    -->
    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>

    <xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'"/>
    <xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'"/>

    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>


    </xsl:template>

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>

            <xsl:call-template name="winSoftwareServiceStatusCheck">
                <xsl:with-param name="definitionId" select="$definitionId"/>
                <xsl:with-param name="def_result" select="$result"/>
            </xsl:call-template>

    </xsl:template>

    <xsl:template name="winSoftwareServiceStatusCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>


        <xsl:variable name="tests">
            <xsl:for-each
                select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:wmi_test[@id=$test] and (./parent::node()/@result = 'false'  or $def_result = 'true' ) ">
                    <xsl:variable name="object"
                        select="$Tests/win-def:wmi_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"
                        select="$Tests/win-def:wmi_test[@id=$test]/win-def:state/@state_ref"/>

                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="serviceName">
                            <xsl:value-of
                                select="substring-after( $Objects/win-def:wmi_object[@id=$object]/win-def:wql, '=' )"
                            />
                        </xsl:attribute>
                        <xsl:attribute name="expectedServiceStatus">
							<xsl:choose>
								<xsl:when test="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable != ''">
									<xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="$States/win-def:wmi_state[@id=$state]/win-def:result"/>
								</xsl:otherwise>
								</xsl:choose>
                        </xsl:attribute>
                        <xsl:attribute name="testtype">
                            <xsl:text>wmi</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
                <xsl:if test="$Tests/win-def:registry_test[@id=$test] and (./parent::node()/@result = 'false'  or $def_result = 'true' )">
                    <xsl:variable name="object"
                    select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"  select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>                  
                    <xsl:variable name="key"
                        select="$Objects/win-def:registry_object[@id=$object]/win-def:key"/>
                    <xsl:variable name="name"
                        select="$Objects/win-def:registry_object[@id=$object]/win-def:name"/>
                    <xsl:variable name="expectedValue" select="$States/win-def:registry_state[@id=$state]/win-def:value"/>                 

                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="key">
                            <xsl:value-of select="$key"/>
                        </xsl:attribute>
                        <xsl:attribute name="name">
                            <xsl:value-of select="$name"/>
                        </xsl:attribute>
                        <xsl:attribute name="expectedValue">
                            <xsl:value-of select="$expectedValue"/>
                        </xsl:attribute>
                        <xsl:attribute name="testtype">
                            <xsl:text>registry</xsl:text>
                        </xsl:attribute>

                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>

            <xsl:if test="$def_result = 'false' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[@testtype = 'registry' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="key" select="@key"/>
                <xsl:variable name="name" select="@name"/>
                <xsl:variable name="expectedValue" select="@expectedValue"/>
                
                <xsl:for-each
                    select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">

                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="result" select="@result"/>

                 <xsl:if test="$expectedValue = '' ">
                    <xsl:variable name="installedSoftwareStatus"
                        select="$SystemData/win-sc:registry_item[@id=$itemRef]/@status"/>

                    <finding messageId="com.mcafee.pa.msg.winregistryisnotexist" isViolation="true">
                        <instanceValue key="registry">
                            <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>
                        </instanceValue>
                    </finding>
                </xsl:if>
                    
                <xsl:if test="$expectedValue != '' ">
                    
                    <xsl:variable name="actualParameterValue" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"/>
                    <xsl:variable name="actualParameterStatus" select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status"/>
                    
                    <xsl:variable name="message_id">
                        <xsl:choose>
                            <xsl:when test="$actualParameterStatus = 'does not exist' ">
                                <xsl:text>com.mcafee.pa.msg.winregistryisnotexist</xsl:text>                                    
                            </xsl:when>
                            <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                <xsl:text>com.mcafee.pa.msg.winregistryreaderror</xsl:text>                                    
                            </xsl:when>                                
                            <xsl:otherwise>                                
                                <xsl:text>com.mcafee.pa.msg.winregistrysettingmessage</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    
                    <finding messageId="{$message_id}" isViolation="true">
                        <instanceValue key="registry">
                            <xsl:value-of select="$key"/><xsl:text>\</xsl:text><xsl:value-of select="$name"/>                                                    
                        </instanceValue>                         
                        <instanceValue key="expectedValue">
                            <xsl:value-of select="$expectedValue"/>                                                    
                        </instanceValue>
                        <actualValue key="actualValue">
                            <xsl:value-of select="$actualParameterValue"/>                                                    
                        </actualValue>
                    </finding>
                    </xsl:if>
                </xsl:for-each>
            </xsl:for-each>
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[@testtype = 'wmi' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="serviceName" select="@serviceName"/>
                <xsl:variable name="expectedServiceStatus" select="@expectedServiceStatus"/>
                
                <xsl:for-each
                    select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'false'  or @result = 'error'  or  @result='not evaluated' ] ">
                    
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="result" select="@result"/>
                    
                    <xsl:variable name="isViolation">
                        <xsl:call-template name="toggleBoolean">
                            <xsl:with-param name="value">
                                <xsl:value-of select="$result"/>
                            </xsl:with-param>
                        </xsl:call-template>
                    </xsl:variable>
                    
                    <xsl:variable name="serviceExistanceStatus"
                        select="$SystemData/win-sc:wmi_item[@id=$itemRef]/@status"/>
                    <xsl:variable name="actualServiceStatus"
                        select="$SystemData/win-sc:wmi_item[@id=$itemRef]/win-sc:result"/>
                    
                    <xsl:variable name="message_id">
                        <xsl:choose>
                            <xsl:when test="$serviceExistanceStatus = 'does not exist' ">
                                <xsl:text>com.mcafee.pa.msg.winsoftwareservicenotexist</xsl:text>
                            </xsl:when>
                            <xsl:when test="$result = 'error' or  $result='not evaluated' ">
                                <xsl:text>com.mcafee.pa.msg.winsoftwareserviceerror</xsl:text>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:text>com.mcafee.pa.msg.winsoftwareservicestatusmessage</xsl:text>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:variable>
                    
                    <finding messageId="{$message_id}" isViolation="{$isViolation}">
                        <instanceValue key="serviceName">
                            <xsl:value-of select="$serviceName"/>
                        </instanceValue>
                        <instanceValue key="expectedServiceStatus">
                            <xsl:value-of select="$expectedServiceStatus"/>
                        </instanceValue>
                        <actualValue key="actualServiceStatus">
                            <xsl:value-of select="$actualServiceStatus"/>
                        </actualValue>
                    </finding>
                </xsl:for-each>
            </xsl:for-each>
               </findings>
            </xsl:if>            
             <xsl:if test="$def_result = 'true' ">
                 <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                <xsl:for-each select="xalan:nodeset($tests)/descendant::test[@testtype = 'wmi' ]">
                    <xsl:variable name="test" select="@id"/>
                    <xsl:variable name="serviceName" select="@serviceName"/>
                    <xsl:variable name="expectedServiceStatus" select="@expectedServiceStatus"/>
                    
                    <xsl:for-each
                        select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[ @result = 'true' ] ">
                        
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="result" select="@result"/>
                      

                        <xsl:variable name="serviceExistanceStatus"
                            select="$SystemData/win-sc:wmi_item[@id=$itemRef]/@status"/>
                        <xsl:variable name="actualServiceStatus"
                            select="$SystemData/win-sc:wmi_item[@id=$itemRef]/win-sc:result"/>
                        
                        <finding messageId="com.mcafee.pa.msg.winsoftwareservicestatusmessage" isViolation="false">
                            <instanceValue key="serviceName">
                                <xsl:value-of select="$serviceName"/>
                            </instanceValue>
                            <instanceValue key="expectedServiceStatus">
                                <xsl:value-of select="$expectedServiceStatus"/>
                            </instanceValue>
                            <actualValue key="actualServiceStatus">
                                <xsl:value-of select="$actualServiceStatus"/>
                            </actualValue>
                        </finding>
                    </xsl:for-each>
                </xsl:for-each>
                </findings>
             </xsl:if>

    </xsl:template>
</xsl:stylesheet>
