<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is specific to AIX Patch Checks of SCAP Content.
        
        Patch details will be piacked up based on the result of the applicability. 
        
        Usual title pattern would be Patch for AIX <advisory name>.
        
        Example:Patch for AIX ftpd advisory
        
        This is modified version of aixPatchCheckLibrary.xsl
        
         Criteria (AND)
                 Criteria (OR) - Pre-Requisite Tests - Applicability - one or more
                     Criteria
                        Criterion :  Fileset Test 1
                      Criteria
                        Criterion :  Fileset Test  2
                        .......
                        
                 Criteria (OR) - Patch Test - one APAR number
                      Criterion :  Fix Test 1 - This could be only one test when constant variable is used in the test. 
                      .........
                      
       Test Cases:
            1. Final Result is Pass - This is when one and one APAR is installed.
            2. Final Result is Fail - This is when the required APAR is missing.
            3. Final Result is Pass - This is when applicability test fails. None of the APAR's are applicable.
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         
        <xsl:variable name="result"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="patchRes" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/oval-res:criteria/oval-res:criteria[2]/@result"/>
                
          <xsl:variable name="critPos">
              <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criteria/descendant::oval-res:criteria">
                    <xsl:if test="@result='true'">
                        <xsl:value-of select="position()"/>
                    </xsl:if>
               </xsl:for-each>
          </xsl:variable>
   
        <xsl:variable name="missingAPAR">
            <xsl:choose>
                <xsl:when test="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/aix-sc:fix_item[@id=number($critPos)]/aix-sc:apar_number/text()!=''">
                    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/aix-sc:fix_item[@id=number($critPos)]/aix-sc:apar_number/text()"/>
                </xsl:when>
               <xsl:otherwise>
                   <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/aix-sc:fix_item[@id]/aix-sc:apar_number/text()"/>    
               </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="APARList">
            <xsl:variable name="OvalResult"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
            <xsl:variable name="Tests"
                select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
            
            <xsl:variable name="tests">
                <xsl:for-each
                    select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                    <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/aix-def:fix_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>fixTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
                </xsl:for-each>
            </xsl:variable>
            
            <xsl:variable name="TestedItems"
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
            
            <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fixTest' ]">
                <xsl:variable name="test" select="@id"/>
                <xsl:variable name="type" select="@type"/>
                
                <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'true' or @result = 'false' or @result = 'not evaluated']">
                    <xsl:variable name="itemRef" select="@item_id"/>
                    <xsl:variable name="fixTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/aix-sc:fix_item[@id=$itemRef]" />
                    <xsl:value-of select="concat($fixTestItem/aix-sc:apar_number/text(),'  ')"/>
                </xsl:for-each>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="title">
            <xsl:value-of select="substring-after(/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title,'Patch for ')"/>            
        </xsl:variable>
        
        <xsl:variable name="filesetName">
            <xsl:for-each select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/aix-def:fileset_object">
                <xsl:variable name="objID" select="@id"/>
                <xsl:text> </xsl:text>
                <xsl:value-of select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/aix-def:fileset_object[@id=$objID]/aix-def:flstinst/text()"/>
               <xsl:text>  </xsl:text>
            </xsl:for-each>
        </xsl:variable>
        
   <!-- Get APAR number that is installed on the system by parsing fix_test result, tested_item and its corresponding item_id -->
    <xsl:variable name="instAPAR">
        
        <xsl:variable name="OvalResult"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>
        <xsl:variable name="Tests"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
   
        
        <xsl:variable name="tests">
            <xsl:for-each
                select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">
                <xsl:variable name="test" select="@test_ref"/>
                    <xsl:if test="$Tests/aix-def:fix_test[@id=$test]">
                        <xsl:element name="test">
                            <xsl:attribute name="id">
                                <xsl:value-of select="$test"/>
                            </xsl:attribute>
                            <xsl:attribute name="type">
                                <xsl:text>fixTest</xsl:text>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:if>
             </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="TestedItems"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
        
        <xsl:for-each select="xalan:nodeset($tests)/descendant::test[ @type ='fixTest' ]">
            <xsl:variable name="test" select="@id"/>
            <xsl:variable name="type" select="@type"/>

                   <xsl:for-each select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_item[@result = 'true']">
                        <xsl:variable name="itemRef" select="@item_id"/>
                        <xsl:variable name="fixTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/aix-sc:fix_item[@id=$itemRef]" />        
                       <xsl:value-of select="$fixTestItem/aix-sc:apar_number/text()"/>
                       <xsl:text>  </xsl:text>
                   </xsl:for-each>
        </xsl:for-each>
    </xsl:variable>     
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:if test="$result='true'">
                 <xsl:text>com.mcafee.pa.msg.APARNotInstalled</xsl:text>
            </xsl:if>
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$instAPAR!='' and $patchRes='false'">
                        <xsl:text>com.mcafee.pa.msg.APARInstalled</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>com.mcafee.pa.msg.APARNotApplicable</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="aparNum">
            <xsl:choose>
                <xsl:when test="$result='true' and $missingAPAR!=''">
                    <xsl:value-of select="$missingAPAR"/>
                </xsl:when>
                <xsl:when test="$instAPAR!='' and $result='false' and $patchRes='false'">
                    <xsl:value-of select="$instAPAR"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$APARList"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
                   
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">vulnerability</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">filesetname</xsl:attribute>
                    <xsl:value-of select="$filesetName"/>
                </xsl:element>
                <xsl:element name="actualValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">apar_num</xsl:attribute>
                    <xsl:value-of select="$aparNum"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
        
    </xsl:template>
</xsl:stylesheet>