<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:fnd="http://results.pa.mcafee.com/findings/5.2">

    <xsl:template match="/">
        <xsl:variable name="unorderedFindings">
            <xsl:call-template name="getFindings">
                <xsl:with-param name="definitionId">oval:com.mcafee.oval:def:83310</xsl:with-param>
            </xsl:call-template>
        </xsl:variable>
        <!-- Now arrange all the nodes to fit the schema. All <inputValue/> nodes must come first, followed by all <finding/> nodes-->
        <findings id="{xalan:nodeset($unorderedFindings)/descendant::fnd:findings/@id}"  xmlns="http://results.pa.mcafee.com/findings/5.2">
			<xsl:copy>
				<xsl:copy-of select="xalan:nodeset($unorderedFindings)/descendant::fnd:inputValue"/>
				<xsl:copy-of select="xalan:nodeset($unorderedFindings)/descendant::fnd:finding"/>
			</xsl:copy>
		</findings>
    </xsl:template>

    <xsl:variable name="Definitions"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
    <xsl:variable name="Tests"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests"/>
    <xsl:variable name="TestedItems"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests"/>
    <xsl:variable name="CollectedObjects"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:collected_objects"/>
    <xsl:variable name="SystemData"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data"/>
    <xsl:variable name="States"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states"/>
    <xsl:variable name="Objects"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects"/>
    <xsl:variable name="Variables"
        select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:variables"/>
    <xsl:variable name="OvalResult"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions"/>



    <xsl:template name="toggleBoolean">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value = 'true'">
                <xsl:value-of select="false()"/>
            </xsl:when>
            <xsl:when test="$value = 'false'">
                <xsl:value-of select="true()"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="true()"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="removeColon">
        <xsl:param name="string"/>
        <xsl:param name="count"/>
        <xsl:param name="length"/>

        <xsl:if test="$count  &lt;= $length">

            <xsl:variable name="char">
                <xsl:value-of select="substring($string,$count,1)"/>
            </xsl:variable>

            <xsl:choose>
                <xsl:when test="$char != ':' and $char != '.' ">
                    <xsl:value-of select="$char"/>
                    <xsl:call-template name="removeColon">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="count" select="$count + 1"/>
                        <xsl:with-param name="length" select="$length"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="removeColon">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="count" select="$count + 1"/>
                        <xsl:with-param name="length" select="$length"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>

    <xsl:template name="getSuffixForMessageId">
        <xsl:param name="id"/>

        <xsl:variable name="suffix">
            <xsl:value-of select="substring-after($id,'oval:com.mcafee.')"/>
        </xsl:variable>

        <xsl:variable name="suffix1">
            <xsl:call-template name="removeColon">
                <xsl:with-param name="string" select="$suffix"/>
                <xsl:with-param name="length" select="string-length($suffix)"/>
                <xsl:with-param name="count" select="1 + 0"/>
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$suffix1"/>
    </xsl:template>

    <xsl:template name="getVariableSuffix">
        <xsl:param name="test_id"/>
        <xsl:variable name="suffix">
            <xsl:value-of select="substring-after($test_id,'tst:')"/>
        </xsl:variable>
        <xsl:value-of select="$suffix"/>
    </xsl:template>

    <xsl:template name="getMessageId">
        <xsl:param name="id"/>
        <xsl:param name="status"/>

        <xsl:variable name="suffiex">
            <xsl:call-template name="getSuffixForMessageId">
                <xsl:with-param name="id" select="$id"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:if test="$suffiex != '' ">
            <xsl:choose>
                <xsl:when test="$status = 'does not exist' ">
                    <xsl:value-of select="concat('com.mcafee.pa.msg.winnoconfiguration',$suffiex)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('com.mcafee.pa.msg.winconfiguration',$suffiex)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>


    <xsl:template name="getPrintableValue">
        <xsl:param name="numaricValue"/>

        <xsl:variable name="formattedNumaricValue">
            <xsl:choose>
                <xsl:when test="$numaricValue != '' ">
                    <xsl:value-of select="$numaricValue"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>Unknown (Not Configured)</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:value-of select="$formattedNumaricValue"/>

    </xsl:template>

    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>


        <xsl:call-template name="winConfigurationCheck">
            <xsl:with-param name="definitionId" select="$definitionId"/>
            <xsl:with-param name="def_result" select="$result"/>
        </xsl:call-template>

    </xsl:template>

    <xsl:template name="winConfigurationCheck">
        <xsl:param name="definitionId"/>
        <xsl:param name="def_result"/>

        <xsl:variable name="tests">
            <xsl:for-each
                select="$OvalResult/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:criterion">

                <xsl:variable name="test" select="@test_ref"/>
                <xsl:if test="$Tests/win-def:registry_test[@id=$test]">
                    <xsl:variable name="object"
                        select="$Tests/win-def:registry_test[@id=$test]/win-def:object/@object_ref"/>
                    <xsl:variable name="state"
                        select="$Tests/win-def:registry_test[@id=$test]/win-def:state/@state_ref"/>

                    <xsl:variable name="keyref"
                        select="$States/win-def:registry_state[@id=$state]/win-def:key/@var_ref"/>
                    <xsl:variable name="key"
                        select="$Variables/oval-def:constant_variable[@id=$keyref]/oval-def:value"/>

                    <xsl:variable name="name_ref"
                        select="$States/win-def:registry_state[@id=$state]/win-def:name/@var_ref"/>
                    <xsl:variable name="name"
                        select="$Variables/oval-def:constant_variable[@id=$name_ref]/oval-def:value"/>

                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>

                        <xsl:attribute name="key">
                            <xsl:value-of select="$key"/>
                        </xsl:attribute>

                        <xsl:attribute name="state">
                            <xsl:value-of select="$state"/>
                        </xsl:attribute>

                        <xsl:attribute name="name">
                            <xsl:value-of select="$name"/>
                        </xsl:attribute>

                        <xsl:if
                            test="$States/win-def:registry_state[@id=$state]/win-def:value or $state = '' ">
                            <xsl:attribute name="type">
                                <xsl:text>primarytest</xsl:text>
                            </xsl:attribute>
                            <xsl:variable name="value_ref"
                                select="$States/win-def:registry_state[@id=$state]/win-def:value/@var_ref"/>
                            <xsl:variable name="expectedValue">
                                <xsl:choose>
                                    <xsl:when test="$value_ref = ''">
                                        <xsl:value-of
                                            select="$States/win-def:registry_state[@id=$state]/win-def:value"
                                        />
                                    </xsl:when>
                                    <xsl:when
                                        test="$Variables/oval-def:constant_variable[@id=$value_ref]/oval-def:value != ''">
                                        <xsl:value-of
                                            select="$Variables/oval-def:constant_variable[@id=$value_ref]/oval-def:value"
                                        />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of
                                            select="$TestedItems/oval-res:test[@test_id=$test ]/oval-res:tested_variable[@variable_id = $value_ref]"
                                        />
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:variable>
                            <xsl:attribute name="expectedValue">
                                <xsl:value-of select="$expectedValue"/>
                            </xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                </xsl:if>

                <xsl:if test="$Tests/oval-ind:family_test[@id=$test]">
                    <xsl:element name="test">
                        <xsl:attribute name="id">
                            <xsl:value-of select="$test"/>
                        </xsl:attribute>
                        <xsl:attribute name="type">
                            <xsl:text>family</xsl:text>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>

        </xsl:variable>

        <xsl:variable name="exDefinitionId">
            <xsl:for-each
                select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[ @definition_id = $definitionId ]/oval-res:criteria/descendant::oval-res:extend_definition[@result = 'false'] ">
                <xsl:if test="./parent::node()/@result = 'false' ">
                    <xsl:element name="extend_definition">
                        <xsl:attribute name="id">
                            <xsl:value-of select="@definition_ref"/>
                        </xsl:attribute>
                        <xsl:attribute name="result">
                            <xsl:value-of select="@result"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>

        <xsl:variable name="rs_exDefinition">
            <xsl:value-of
                select="xalan:nodeset($exDefinitionId)/descendant::extend_definition/@result"/>
        </xsl:variable>

        <xsl:variable name="pre_test_result">
            <xsl:choose>
                <xsl:when
                    test="xalan:nodeset($tests)/descendant::test[ @type ='family' ]/@id != '' ">
                    <xsl:variable name="test"
                        select="xalan:nodeset($tests)/descendant::test[ @type ='family' ]/@id"/>
                    <xsl:value-of select="$TestedItems/oval-res:test[@test_id=$test ]/@result"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>true</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>


        <xsl:if test=" $pre_test_result = 'true' and $def_result = 'false' ">

            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

                <xsl:if
                    test="$TestedItems/oval-res:test[@test_id='oval:com.mcafee.oval:tst:83870']/@result = 'false'">
                    <inputValue key="{concat('expectedValue_',83870)}">1</inputValue>
                    <xsl:variable name="itemRef"
                        select="$TestedItems/oval-res:test[@test_id='oval:com.mcafee.oval:tst:83870']/oval-res:tested_item/@item_id"/>
                    <xsl:choose>
                        <xsl:when
                            test="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status = 'does not exist'">
                            <finding
                                messageId="com.mcafee.pa.msg.winnoconfigurationovaldef83310_83870"
                                isViolation="true"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <finding
                                messageId="com.mcafee.pa.msg.winconfigurationovaldef83310_83870"
                                isViolation="true">
                                <actualValue key="actualValue_83870">
                                    <xsl:value-of
                                        select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"
                                    />
                                </actualValue>
                            </finding>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>

                <xsl:if
                    test="$TestedItems/oval-res:test[@test_id='oval:com.mcafee.oval:tst:83868']/@result = 'false'">
                    <inputValue key="{concat('expectedValue_',83868)}">40</inputValue>
                    <inputValue key="{concat('expectedValue_',83869)}">28</inputValue>
                    <xsl:variable name="itemRef"
                        select="$TestedItems/oval-res:test[@test_id='oval:com.mcafee.oval:tst:83868']/oval-res:tested_item/@item_id"/>
                    <xsl:choose>
                        <xsl:when
                            test="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:name/@status = 'does not exist'">
                            <finding
                                messageId="com.mcafee.pa.msg.winnoconfigurationovaldef83310_83868"
                                isViolation="true"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <finding
                                messageId="com.mcafee.pa.msg.winconfigurationovaldef83310_83868"
                                isViolation="true">
                                <actualValue key="actualValue_83868">
                                    <xsl:value-of
                                        select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"
                                    />
                                </actualValue>
                            </finding>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </findings>
        </xsl:if>

        <xsl:if test=" $def_result = 'true' ">
            <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                <xsl:for-each select="$TestedItems/oval-res:test[@result = 'true']">
                    <xsl:variable name="test" select="@test_id"/>
                    <xsl:variable name="variableSuffix">
                        <xsl:call-template name="getVariableSuffix">
                            <xsl:with-param name="test_id" select="normalize-space($test)"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <xsl:variable name="message_id"
                        select="concat('com.mcafee.pa.msg.winconfigurationovaldef83310_', $variableSuffix)"/>
                    <xsl:variable name="itemRef"
                        select="$TestedItems/oval-res:test[@test_id=$test]/oval-res:tested_item/@item_id"/>
                    <finding messageId="{$message_id}" isViolation="false">
                        <actualValue key="{concat('actualValue_',$variableSuffix)}">
                            <xsl:value-of
                                select="$SystemData/win-sc:registry_item[@id=$itemRef]/win-sc:value"
                            />
                        </actualValue>
                    </finding>
                </xsl:for-each>
            </findings>
        </xsl:if>

        <xsl:if test="$pre_test_result = 'false'  and $def_result = 'false' ">
            <xsl:variable name="getIE7InstallationResult">
                <xsl:value-of
                    select="xalan:nodeset($exDefinitionId)/descendant::extend_definition[@id = 'oval:com.mcafee.oval.ie7:def:627']/@result"
                />
            </xsl:variable>
            <xsl:if test="$getIE7InstallationResult = 'false' ">
                <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">
                    <finding messageId="com.mcafee.pa.msg.ie7isnotinstalled" isViolation="true"/>
                </findings>
            </xsl:if>
        </xsl:if>

    </xsl:template>

</xsl:stylesheet>
