﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
    xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:win-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#windows"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1"
    xmlns:xsd="http://www.w3.org/2001/XMLSchema"   
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:oval-ind="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:win-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#windows"
    xmlns:xalan="http://xml.apache.org/xalan"    >
    
<!--  FILENAME: winFilePermissionCheck.xsl         DATE: 20th May, 2011     AUTHOR: Niti Dhingra   -->
<!--  MAPPINGFILE: winFilePermissionCheck_xsl.txt    -->
    
<!-- THIS LIBRARY IS DEVELOPED FOR WINDOWS COMPLIANCE CHECKS TO TEST FOR FILE/FOLDER PERMISSIONS  -->
<!--
    Logic:
    <criteria>
        <criteria operator="AND">
            <criteria operator="OR">
                <criteria operator="AND">
                    <criterion comment="Verify Everyone rights. (no access)." test_ref="oval:com.mcafee.oval:tst:213853"/>
                    <criterion comment="Verify Users rights (no access)." test_ref="oval:com.mcafee.oval:tst:213854"/>
                    <criterion comment="Verify Authenticated Users rights. (no access)." test_ref="oval:com.mcafee.oval:tst:213855"/>
                </criteria>
            <criteria operator="AND">
                <criterion comment="Folder expected variable = No" test_ref="oval:com.mcafee.oval:tst:213856"/>
                <criterion comment="Folder repair does not exist" test_ref="oval:com.mcafee.oval:tst:213857"/>
            </criteria>
        </criteria>
      </criteria>
  </criteria>
 
 Ex: oval:com.mcafee.oval:def:213958
        oval:com.mcafee.oval:def:213965
-->    
    <!-- Entry Function for the library  -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result"  select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="Definitions"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title">
            <xsl:value-of select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>            
        </xsl:variable>
        
        <xsl:variable name="fileType">
            <xsl:choose>
                <xsl:when test="contains($title,'Windows Folder')">
                    <xsl:text>Folder</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>File</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="fileName">
            <xsl:choose>
                <xsl:when test="$fileType='File'">
                    <xsl:choose>
                        <xsl:when test="not(/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:file_item/win-sc:filepath)">
                            <xsl:value-of select="concat(/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:file_item/win-sc:path,'\',/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:file_item/win-sc:filename)"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:file_item/win-sc:filepath"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$fileType='Folder'">
                    <xsl:choose>
                        <xsl:when test="not(/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:file_item/win-sc:filepath)">
                            <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:file_item/win-sc:path"/>        
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/win-sc:file_item/win-sc:filepath"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="result1"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>
        <xsl:variable name="result3"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[3]/@result"/>
        <xsl:variable name="result4"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[4]/@result"/>
        <xsl:variable name="result5"
        select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[5]/@result"/>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->

            <xsl:variable name="message_id">
                
                <!-- Check if result is true ........................................................................................... -->
                <xsl:if test="$result='true'">
                    <xsl:choose>
                        <xsl:when test="$result4 = 'true' ">
                                <xsl:choose>
                                       <xsl:when test="$result5 = 'true' ">
                                            <xsl:text>com.mcafee.pa.msg.winFileFolderDoesNotExist</xsl:text>                                    
                                        </xsl:when>
                                        <xsl:when test="$result5 = 'false' ">
                                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissionsAll_SCAP</xsl:text>                                    
                                        </xsl:when>                  
                                </xsl:choose>
                        </xsl:when>
                        <xsl:when test="$result1 = 'true' and $result2='true' and $result3 = 'true'">
                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissionsAll_SCAP</xsl:text>                   
                        </xsl:when>
                   
                    </xsl:choose>
                </xsl:if>
                
                <!-- Check if result is false ........................................................................................... -->
                <xsl:if test="$result='false'">
                    <xsl:choose>
                        <xsl:when test="$result4 = 'false' and $result5='true'">                            
                            <xsl:text>com.mcafee.pa.msg.winFileFolderDoesNotExist</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result1 = 'false' and $result2='false' and $result3='false'">
                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissionsAll_SCAP</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result1 = 'false' and $result2='false' and $result3='true'">
                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions12_SCAP</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result1 = 'false' and $result2='true' and $result3='true'">
                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions1_SCAP</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result1 = 'true' and $result2='false' and $result3='false'">
                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions23_SCAP</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result1 = 'false' and $result2='true' and $result3='false'">
                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions13_SCAP</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result1 = 'true' and $result2='false' and $result3='true'">
                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions2_SCAP</xsl:text>                                    
                        </xsl:when>
                        <xsl:when test="$result1 = 'true' and $result2='true' and $result3='false'">
                            <xsl:text>com.mcafee.pa.msg.winFileFolderPermissions3_SCAP</xsl:text>                                    
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
  
            </xsl:variable>
            
        <!-- Decide about the isViolation value depending upon  the result of the check ........................................................................................... -->
            <xsl:variable name="isViolationValue">
                <xsl:choose>
                    <xsl:when test="$result = 'false' ">
                        <xsl:text>true</xsl:text>                                              
                    </xsl:when>
                    <xsl:when test="$result = 'true' ">
                        <xsl:text>false</xsl:text>                                              
                    </xsl:when>
                    </xsl:choose>               
            </xsl:variable>
        
        <!--Now Create Finding xml with all the values extracted ........................................................................................... -->
        <findings id="{$definitionId}" xmlns="http://results.pa.mcafee.com/findings/5.2">

            <finding messageId="{$message_id}" isViolation="{$isViolationValue}">
                <instanceValue key="fileName">
                    <xsl:value-of select="$fileName"/>                                                    
                </instanceValue>
                <instanceValue key="fileType">
                    <xsl:value-of select="$fileType"/>                                                    
                </instanceValue>
            </finding>
        </findings>
    </xsl:template>
</xsl:stylesheet>
