<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!-- This library is to handle the all Mac OS X patches with follwoing criteria:
        
        Logic :-
        <criteria negate="true" operator="OR">
        <criterion test_ref="oval:com.mcafee.oval:tst:239091" comment="Mac OSX 10.5 Security Update 2012-003 is installed"/>
        .
        .
        </criteria>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:239087 and all patch checks having bom file check.
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid" />
        </xsl:call-template>
    </xsl:template>
    
    <!-- This library is for Mac OS bom file related checks -->
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect all the required data from checks like test ref, obj ref, ste ref and their data and results................................. -->
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>        
        <xsl:variable name="fileTest" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$fileTest_id]"/>
        <xsl:variable name="filePath" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$fileTest/unix-def:object/@object_ref]/unix-def:path/text()" />
        <xsl:variable name="fileName" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$fileTest/unix-def:object/@object_ref]/unix-def:filename/text()" />
        
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileTest_id]/@result"/>     
        
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <!-- Decide about the message id depending upon  the combination of results for the criterion ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                  <!---The Bom file $$fileName$$ should be present in the path $$filePath$$ -->
                  <xsl:text>com.mcafee.pa.msg.macosBomFilePresent</xsl:text>
            </xsl:if>
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false'">
                   <!-- The Bom file $$fileName$$ is present in the path $$filePath$$ -->
                   <xsl:text>com.mcafee.pa.msg.macosBomFilePresent</xsl:text>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>        
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">FilePath</xsl:attribute>
                    <xsl:value-of select="$filePath"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">FileName</xsl:attribute>
                    <xsl:value-of select="$fileName"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">patch_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>        
    </xsl:template>
</xsl:stylesheet>