<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    
    <!--
        
        This library is designed for following logic specific to Flash Player checks for MacOS 11.7.700.x series where x >=232
        
        <criteria operator='AND' comment="This test will check the condition that if Adobe Flash Player is installed and version is less than 11.7.700.x on Mac return fail" >
            <criteria operator='OR' comment="This test will check either 10.3.x or 11.7.700.x or greater version is present" >
                <criterion comment="Adobe Flash Player 10.3.x installed on Mac" test_ref="oval:com.mcafee.oval:tst:404880"/>
                <criterion comment="Adobe Flash Player 11.7.700.x or greater installed on Mac" test_ref="oval:com.mcafee.oval:tst:404881"/>
            </criteria>   
            <criterion comment="Adobe Flash Player version is less than 11.7.700.xxx on Mac" test_ref="oval:com.mcafee.oval:tst:405892"/>
        </criteria>
        
    -->
        
   
    
    <xsl:param name="defid"/>
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getProductNameFromTitle">
        
        <xsl:param name="title"/>
        
        <xsl:variable name="product">
             <xsl:value-of select="concat('Adobe Flash Player',substring-before(substring-after($title,'Update'),'.'))"/>
        </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$product != '' ">
                <xsl:value-of select="$product"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
      
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id1]/@result"/>
       
       <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
       <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id2]/@result"/>
        
      <xsl:variable name="expectedVersion" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state[3]/ind-def:subexpression/text()"/>
      <xsl:variable name="actualVersion" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item/ind-sc:subexpression/text()"/>
        
        <xsl:variable name="product">
            <xsl:call-template name="getProductNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
      
        <xsl:variable name="isViolationValue">
            <xsl:choose>
             <xsl:when test="$result='false'">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
                <xsl:choose> 
                    <xsl:when test="$result='true' ">
                    <xsl:text>com.mcafee.pa.msg.MacSecUpdateStatus</xsl:text>
                    </xsl:when>
                   <xsl:when test="$result='false' and ($result1='false' and  $result2='false')">
                        <xsl:text>com.mcafee.pa.msg.MacPatchNotApplicable</xsl:text>
                   </xsl:when>
                    <xsl:when test="$result='false' and ($result1='true' or  $result2='true')">
                        <xsl:text>com.mcafee.pa.msg.MacSecUpdateStatus</xsl:text>
                    </xsl:when>
                 </xsl:choose>
        </xsl:variable>
          
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                 <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                     <xsl:attribute name="key">product</xsl:attribute>
                     <xsl:value-of select="$product"/>
                </xsl:element>
             <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedVersion</xsl:attribute>
                 <xsl:value-of select="$expectedVersion"/>
             </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actualVersion</xsl:attribute>
                    <xsl:value-of select="$actualVersion"/>
                </xsl:element>
          </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

