<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    
    <!-- XSL for handling a single file test for file user and group ownership -->
    
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <xsl:template name="tfcDefinition">
        <xsl:param name="definition_id"/>

        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <findings xmlns="http://results.pa.mcafee.com/findings/5.2" id="{$definition_id}">
                <xsl:variable name="test_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="tfcTest">
                        <xsl:with-param name="test_Id" select="$test_id"/>
                </xsl:call-template>
            </findings>
        </xsl:if>
    </xsl:template>
    <xsl:template name="tfcTest">
        <xsl:param name="test_Id"/>
        
        <xsl:for-each
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[@result='false' or @result='not evaluated']">
            <xsl:variable name="item_id" select="@item_id"/>
            <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:textfilecontent_item[@id=$item_id]"/>
            <xsl:variable name="status" select="$item/@status"/>
            <xsl:variable name="path" select="$item/unix-sc:path"/>
            <xsl:variable name="filename" select="$item/unix-sc:filename"/>
            <xsl:choose>
                
                <xsl:when test="$item/@status='does not exist'">
                    <!-- Message  'The file ##filename## does not exist.' -->
                    <inputValue xmlns="http://results.pa.mcafee.com/findings/5.2" key="filename"><xsl:value-of select="$path"/>/<xsl:value-of select="$filename"/></inputValue>
                    <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.unixfile0" isViolation="true">
                    </finding>
                </xsl:when>
                
                <xsl:when test="not($item/@status)">
                    <!-- Message  'The file ##filename## is not compliant' -->
                    <inputValue xmlns="http://results.pa.mcafee.com/findings/5.2" key="filename"><xsl:value-of select="$path"/>/<xsl:value-of select="$filename"/></inputValue>
                    <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.unixfilecontent1" isViolation="true">
                    </finding>
                </xsl:when>
                
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>

