<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>

    <xsl:template name="redhatPatchDefinition">
        <xsl:param name="definition_id"/>
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:variable name="definitionTitle" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition/oval-def:metadata/oval-def:title"></xsl:variable>
        <findings xmlns="http://results.pa.mcafee.com/findings/5.2" id="{$definition_id}">
            <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="key">title</xsl:attribute>
                <xsl:value-of select="$definitionTitle"/>
            </xsl:element>
            <xsl:choose>
                <xsl:when test="$result='false'">
                    <xsl:variable name="test_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                    <xsl:call-template name="redhatPatchTest">
                        <xsl:with-param name="test_Id" select="$test_id"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <!-- Message 'The patch (##title##) is not installed on this system.' -->
                    <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.patchNotInstalled" isViolation="true">
                    </finding>
                </xsl:otherwise>
            </xsl:choose>
        </findings>
    </xsl:template>
    
    <xsl:template name="redhatPatchTest">
        <xsl:param name="test_Id"/>
        <xsl:variable name="testedItemResult" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$test_Id]/oval-res:tested_item[1]/@result"/>
        <xsl:choose>
            <xsl:when test="$testedItemResult='not evaluated'">
            <!-- Message 'The patch (##title##) is not applicable to this system.' -->
            <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.patchNotApplicable" isViolation="false">
            </finding>
            </xsl:when>
            <xsl:otherwise>
                <!-- Message 'The patch (##title##) has been applied to this system.' -->
                <finding xmlns="http://results.pa.mcafee.com/findings/5.2" messageId="com.mcafee.pa.msg.patchInstalled" isViolation="false">
                </finding>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
